/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security.adduser;

import java.util.Locale;
import org.jboss.as.domain.management.logging.DomainManagementLogger;
import org.jboss.as.domain.management.security.adduser.AddUser;
import org.jboss.as.domain.management.security.adduser.ConsoleWrapper;
import org.jboss.as.domain.management.security.adduser.ErrorState;
import org.jboss.as.domain.management.security.adduser.PropertyFileFinder;
import org.jboss.as.domain.management.security.adduser.State;
import org.jboss.as.domain.management.security.adduser.StateValues;

public class PropertyFilePrompt
implements State {
    private ConsoleWrapper theConsole;
    private StateValues stateValues;

    public PropertyFilePrompt(ConsoleWrapper theConsole, StateValues stateValues) {
        this.theConsole = theConsole;
        this.stateValues = stateValues;
    }

    @Override
    public State execute() {
        this.theConsole.printf(AddUser.NEW_LINE, new Object[0]);
        this.theConsole.printf(DomainManagementLogger.ROOT_LOGGER.filePrompt(), new Object[0]);
        this.theConsole.printf(AddUser.NEW_LINE, new Object[0]);
        String temp = this.theConsole.readLine("(a): ", new Object[0]);
        if (temp == null) {
            this.theConsole.printf(AddUser.NEW_LINE, new Object[0]);
            return null;
        }
        boolean setRealm = this.stateValues.getRealmMode() != AddUser.RealmMode.USER_SUPPLIED;
        switch (this.convertResponse(temp)) {
            case MANAGEMENT: {
                this.stateValues.setFileMode(AddUser.FileMode.MANAGEMENT);
                if (setRealm) {
                    this.stateValues.setRealm("ManagementRealm");
                }
                return new PropertyFileFinder(this.theConsole, this.stateValues);
            }
            case APPLICATION: {
                this.stateValues.setFileMode(AddUser.FileMode.APPLICATION);
                if (setRealm) {
                    this.stateValues.setRealm("ApplicationRealm");
                }
                return new PropertyFileFinder(this.theConsole, this.stateValues);
            }
        }
        return new ErrorState(this.theConsole, DomainManagementLogger.ROOT_LOGGER.invalidChoiceResponse(), this, this.stateValues);
    }

    private Option convertResponse(String response) {
        String temp = response.toLowerCase(Locale.ENGLISH);
        if ("".equals(temp) || "a".equals(temp)) {
            return Option.MANAGEMENT;
        }
        if ("b".equals(temp)) {
            return Option.APPLICATION;
        }
        return Option.INVALID;
    }

    private static enum Option {
        MANAGEMENT,
        APPLICATION,
        INVALID;

    }
}

