/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.negotiation.spnego;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.Oid;
import org.jboss.logging.Logger;
import org.jboss.security.negotiation.Constants;
import org.jboss.security.negotiation.MessageFactory;
import org.jboss.security.negotiation.NegotiationMessage;
import org.jboss.security.negotiation.spnego.KerberosMessage;
import org.jboss.security.negotiation.spnego.encoding.NegTokenInitDecoder;

public class KerberosMessageFactory
extends MessageFactory {
    private static final Logger log = Logger.getLogger(KerberosMessageFactory.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean accepts(InputStream in) throws IOException {
        if (!in.markSupported()) {
            throw new IllegalArgumentException("The passed in InputStream needs to support mark/reset.");
        }
        in.mark(1);
        try {
            int dataRead = in.read();
            if (dataRead == 96) {
                int length = NegTokenInitDecoder.readLength(in);
                Oid messageId = new Oid(in);
                boolean bl = Constants.KERBEROS_V5.equals(messageId);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (GSSException e) {
            log.debug((Object)"Error determining message Oid", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            in.reset();
        }
    }

    public NegotiationMessage createMessage(InputStream in) throws IOException {
        if (this.accepts(in)) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] temp = new byte[256];
            int count = -1;
            while ((count = in.read(temp)) > -1) {
                baos.write(temp, 0, count);
            }
            return new KerberosMessage(Constants.KERBEROS_V5, baos.toByteArray());
        }
        throw new IllegalArgumentException("InputStream does not contain Kerberos message.");
    }
}

