/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.xsite;

import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.context.impl.LocalTxInvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.interceptors.InvocationStage;
import org.infinispan.interceptors.xsite.BaseBackupInterceptor;

public class OptimisticBackupInterceptor
extends BaseBackupInterceptor {
    @Override
    public Object visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
        if (!this.shouldInvokeRemoteTxCommand(ctx)) {
            return this.invokeNext(ctx, command);
        }
        if (this.isTxFromRemoteSite(command.getGlobalTransaction())) {
            return this.invokeNext(ctx, command);
        }
        InvocationStage stage = this.backupSender.backupCommit(command, ctx.getTransaction());
        return this.invokeNextAndWaitForCrossSite(ctx, command, stage);
    }

    @Override
    public Object visitRollbackCommand(TxInvocationContext ctx, RollbackCommand command) throws Throwable {
        if (!this.shouldRollbackRemoteTxCommand(ctx)) {
            return this.invokeNext(ctx, command);
        }
        if (this.isTxFromRemoteSite(command.getGlobalTransaction())) {
            return this.invokeNext(ctx, command);
        }
        InvocationStage stage = this.backupSender.backupRollback(command, ctx.getTransaction());
        return this.invokeNextAndWaitForCrossSite(ctx, command, stage);
    }

    private boolean shouldRollbackRemoteTxCommand(TxInvocationContext ctx) {
        return this.shouldInvokeRemoteTxCommand(ctx) && this.hasBeenPrepared((LocalTxInvocationContext)ctx);
    }

    private boolean hasBeenPrepared(LocalTxInvocationContext ctx) {
        return !ctx.getRemoteLocksAcquired().isEmpty();
    }
}

