/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.notifications.cachelistener.cluster;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.infinispan.Cache;
import org.infinispan.commands.InitializableCommand;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.notifications.cachelistener.cluster.ClusterCacheNotifier;
import org.infinispan.notifications.cachelistener.cluster.ClusterEvent;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.ByteString;
import org.infinispan.util.concurrent.AggregateCompletionStage;
import org.infinispan.util.concurrent.CompletionStages;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class MultiClusterEventCommand<K, V>
extends BaseRpcCommand
implements InitializableCommand {
    public static final int COMMAND_ID = 19;
    private static final Log log = LogFactory.getLog(MultiClusterEventCommand.class);
    private static final boolean trace = log.isTraceEnabled();
    private Cache<K, V> cache;
    private ClusterCacheNotifier<K, V> clusterCacheNotifier;
    private Map<UUID, Collection<ClusterEvent<K, V>>> multiEvents;

    public MultiClusterEventCommand() {
        super(null);
    }

    public MultiClusterEventCommand(ByteString cacheName) {
        super(cacheName);
    }

    public MultiClusterEventCommand(ByteString cacheName, Map<UUID, Collection<ClusterEvent<K, V>>> events) {
        super(cacheName);
        this.multiEvents = events;
    }

    @Override
    public void init(ComponentRegistry componentRegistry, boolean isRemote) {
        this.cache = componentRegistry.getCache().wired();
        this.clusterCacheNotifier = componentRegistry.getClusterCacheNotifier().running();
    }

    @Override
    public CompletableFuture<Object> invokeAsync() {
        if (trace) {
            log.tracef("Received multiple cluster event(s) %s", this.multiEvents);
        }
        AggregateCompletionStage<Void> innerComposed = CompletionStages.aggregateCompletionStage();
        for (Map.Entry<UUID, Collection<ClusterEvent<K, V>>> event : this.multiEvents.entrySet()) {
            UUID identifier = event.getKey();
            Collection<ClusterEvent<K, V>> events = event.getValue();
            for (ClusterEvent<K, V> ce : events) {
                ce.cache = this.cache;
            }
            innerComposed.dependsOn(this.clusterCacheNotifier.notifyClusterListeners(events, identifier));
        }
        return innerComposed.freeze().toCompletableFuture();
    }

    @Override
    public byte getCommandId() {
        return 19;
    }

    @Override
    public boolean isReturnValueExpected() {
        return false;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        output.writeObject(this.getOrigin());
        if (this.multiEvents.size() == 1) {
            output.writeBoolean(true);
            Map.Entry<UUID, Collection<ClusterEvent<K, V>>> entry = this.multiEvents.entrySet().iterator().next();
            output.writeObject(entry.getKey());
            output.writeObject(entry.getValue());
        } else {
            output.writeBoolean(false);
            output.writeObject(this.multiEvents);
        }
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.setOrigin((Address)input.readObject());
        boolean single = input.readBoolean();
        this.multiEvents = single ? Collections.singletonMap((UUID)input.readObject(), (Collection)input.readObject()) : (Map)input.readObject();
    }
}

