/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.transport.jgroups;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.LongConsumer;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.Util;
import org.infinispan.remoting.CacheUnreachableException;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.ValidResponse;
import org.infinispan.remoting.transport.BackupResponse;
import org.infinispan.remoting.transport.XSiteAsyncAckListener;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.infinispan.util.logging.TraceException;
import org.infinispan.xsite.XSiteBackup;
import org.jgroups.UnreachableException;

public class JGroupsBackupResponse
implements BackupResponse {
    private static Log log = LogFactory.getLog(JGroupsBackupResponse.class);
    private final Map<XSiteBackup, CompletableFuture<ValidResponse>> backupCalls;
    private Map<String, Throwable> errors;
    private Set<String> communicationErrors;
    private final TimeService timeService;
    private final long sendTimeNanos;
    private volatile LongConsumer timeElapsedConsumer = value -> {};

    public JGroupsBackupResponse(Map<XSiteBackup, CompletableFuture<ValidResponse>> backupCalls, TimeService timeService) {
        this.backupCalls = Objects.requireNonNull(backupCalls);
        this.timeService = timeService;
        this.sendTimeNanos = timeService.time();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForBackupToFinish() throws Exception {
        long deductFromTimeout = this.timeService.timeDuration(this.sendTimeNanos, TimeUnit.MILLISECONDS);
        this.errors = new HashMap<String, Throwable>(this.backupCalls.size());
        long elapsedTime = 0L;
        boolean hasSyncBackups = false;
        for (Map.Entry<XSiteBackup, CompletableFuture<ValidResponse>> entry : this.backupCalls.entrySet()) {
            XSiteBackup xSiteBackup = entry.getKey();
            if (!xSiteBackup.isSync()) continue;
            hasSyncBackups = true;
            long timeout = xSiteBackup.getTimeout();
            String siteName = xSiteBackup.getSiteName();
            if (timeout > 0L) {
                timeout -= deductFromTimeout;
                if ((timeout -= elapsedTime) <= 0L && !entry.getValue().isDone()) {
                    log.tracef("Timeout period %d exhausted with site %s", xSiteBackup.getTimeout(), siteName);
                    this.errors.put(siteName, (Throwable)((Object)this.newTimeoutException(xSiteBackup.getTimeout(), xSiteBackup)));
                    this.addCommunicationError(siteName);
                    continue;
                }
            }
            long startNanos = this.timeService.time();
            Response response = null;
            try {
                response = entry.getValue().get(timeout, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException te) {
                this.errors.put(siteName, (Throwable)((Object)this.newTimeoutException(xSiteBackup.getTimeout(), xSiteBackup)));
                this.addCommunicationError(siteName);
            }
            catch (ExecutionException ue) {
                Throwable cause = ue.getCause();
                cause.addSuppressed(new TraceException());
                log.tracef(cause, "Communication error with site %s", siteName);
                this.errors.put(siteName, this.filterException(cause));
                this.addCommunicationError(siteName);
            }
            finally {
                elapsedTime += this.timeService.timeDuration(startNanos, TimeUnit.MILLISECONDS);
            }
            log.tracef("Received response from site %s: %s", siteName, response);
        }
        if (hasSyncBackups) {
            this.timeElapsedConsumer.accept(this.timeService.timeDuration(this.sendTimeNanos, TimeUnit.MILLISECONDS));
        }
    }

    private void addCommunicationError(String siteName) {
        if (this.communicationErrors == null) {
            this.communicationErrors = new HashSet<String>(1);
        }
        this.communicationErrors.add(siteName);
    }

    @Override
    public Set<String> getCommunicationErrors() {
        return this.communicationErrors == null ? Collections.emptySet() : this.communicationErrors;
    }

    @Override
    public long getSendTimeMillis() {
        return TimeUnit.NANOSECONDS.toMillis(this.sendTimeNanos);
    }

    @Override
    public boolean isEmpty() {
        return this.backupCalls.keySet().stream().noneMatch(XSiteBackup::isSync);
    }

    @Override
    public void notifyFinish(LongConsumer timeElapsedConsumer) {
        this.timeElapsedConsumer = Objects.requireNonNull(timeElapsedConsumer);
    }

    @Override
    public Map<String, Throwable> getFailedBackups() {
        return this.errors;
    }

    private org.infinispan.util.concurrent.TimeoutException newTimeoutException(long timeout, XSiteBackup xSiteBackup) {
        return new org.infinispan.util.concurrent.TimeoutException(Util.formatString((Object)"Timed out after %s waiting for a response from %s", (Object[])new Object[]{Util.prettyPrintTime((long)timeout), xSiteBackup}));
    }

    public String toString() {
        return "JGroupsBackupResponse{backupCalls=" + this.backupCalls + ", errors=" + this.errors + ", communicationErrors=" + this.communicationErrors + ", sendTimeNanos=" + this.sendTimeNanos + '}';
    }

    private Throwable filterException(Throwable throwable) {
        if (throwable instanceof UnreachableException) {
            return new CacheUnreachableException((UnreachableException)throwable);
        }
        return throwable;
    }

    @Override
    public void notifyAsyncAck(XSiteAsyncAckListener listener) {
        XSiteAsyncAckListener nonNullListener = Objects.requireNonNull(listener);
        for (Map.Entry<XSiteBackup, CompletableFuture<ValidResponse>> entry : this.backupCalls.entrySet()) {
            XSiteBackup backup = entry.getKey();
            if (backup.isSync()) continue;
            entry.getValue().whenComplete((response, throwable) -> nonNullListener.onAckReceived(this.sendTimeNanos, backup.getSiteName(), (Throwable)throwable));
        }
    }

    @Override
    public boolean isSync(String siteName) {
        for (XSiteBackup backup : this.backupCalls.keySet()) {
            if (!backup.getSiteName().equals(siteName)) continue;
            return backup.isSync();
        }
        return false;
    }
}

