/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan;

import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Consumer;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.ExpirationConfiguration;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.eviction.EvictionType;
import org.jboss.as.clustering.controller.CapabilityServiceConfigurator;
import org.jboss.as.controller.ServiceNameFactory;
import org.jboss.as.server.deployment.Services;
import org.jboss.msc.service.ServiceName;
import org.wildfly.clustering.ejb.BeanContext;
import org.wildfly.clustering.ejb.BeanManagerFactoryServiceConfiguratorConfiguration;
import org.wildfly.clustering.ejb.BeanManagerFactoryServiceConfiguratorFactory;
import org.wildfly.clustering.ejb.infinispan.BeanGroupKey;
import org.wildfly.clustering.ejb.infinispan.InfinispanBeanManagerFactoryServiceConfigurator;
import org.wildfly.clustering.ejb.infinispan.logging.InfinispanEjbLogger;
import org.wildfly.clustering.infinispan.spi.DataContainerConfigurationBuilder;
import org.wildfly.clustering.infinispan.spi.InfinispanCacheRequirement;
import org.wildfly.clustering.infinispan.spi.service.CacheServiceConfigurator;
import org.wildfly.clustering.infinispan.spi.service.TemplateConfigurationServiceConfigurator;
import org.wildfly.clustering.service.Dependency;
import org.wildfly.clustering.service.ServiceDependency;

public class InfinispanBeanManagerFactoryServiceConfiguratorFactory<I>
implements BeanManagerFactoryServiceConfiguratorFactory {
    private final String name;
    private final BeanManagerFactoryServiceConfiguratorConfiguration config;

    static String getCacheName(ServiceName deploymentUnitServiceName, String beanManagerFactoryName) {
        ArrayList<String> parts = new ArrayList<String>(3);
        if (Services.JBOSS_DEPLOYMENT_SUB_UNIT.isParentOf(deploymentUnitServiceName)) {
            parts.add(deploymentUnitServiceName.getParent().getSimpleName());
        }
        parts.add(deploymentUnitServiceName.getSimpleName());
        parts.add(beanManagerFactoryName);
        return String.join((CharSequence)"/", parts);
    }

    public InfinispanBeanManagerFactoryServiceConfiguratorFactory(String name, BeanManagerFactoryServiceConfiguratorConfiguration config) {
        this.name = name;
        this.config = config;
    }

    public Collection<CapabilityServiceConfigurator> getDeploymentServiceConfigurators(ServiceName name) {
        String cacheName = InfinispanBeanManagerFactoryServiceConfiguratorFactory.getCacheName(name, this.name);
        String containerName = this.config.getContainerName();
        String templateCacheName = this.config.getCacheName();
        Consumer<ConfigurationBuilder> configurator = builder -> {
            int size;
            ExpirationConfiguration expiration = builder.expiration().create();
            if (expiration.lifespan() >= 0L || expiration.maxIdle() >= 0L) {
                builder.expiration().lifespan(-1L).maxIdle(-1L);
                InfinispanEjbLogger.ROOT_LOGGER.expirationDisabled(InfinispanCacheRequirement.CONFIGURATION.resolve(containerName, templateCacheName));
            }
            EvictionStrategy strategy = (size = this.config.getMaxSize()) > 0 ? EvictionStrategy.REMOVE : EvictionStrategy.MANUAL;
            builder.memory().evictionStrategy(strategy).evictionType(EvictionType.COUNT).storageType(StorageType.OBJECT).size((long)size);
            if (strategy.isEnabled()) {
                ((DataContainerConfigurationBuilder)builder.addModule(DataContainerConfigurationBuilder.class)).evictable(BeanGroupKey.class::isInstance);
            }
        };
        ArrayList<CapabilityServiceConfigurator> builders = new ArrayList<CapabilityServiceConfigurator>(3);
        builders.add((CapabilityServiceConfigurator)new TemplateConfigurationServiceConfigurator(ServiceNameFactory.parseServiceName((String)InfinispanCacheRequirement.CONFIGURATION.getName()).append(new String[]{containerName, cacheName}), containerName, cacheName, templateCacheName, configurator));
        builders.add((CapabilityServiceConfigurator)new CacheServiceConfigurator(ServiceNameFactory.parseServiceName((String)InfinispanCacheRequirement.CACHE.getName()).append(new String[]{containerName, cacheName}), containerName, cacheName).require((Dependency)new ServiceDependency(name.append(new String[]{"marshalling"}))));
        return builders;
    }

    public CapabilityServiceConfigurator getBeanManagerFactoryServiceConfigurator(BeanContext context) {
        return new InfinispanBeanManagerFactoryServiceConfigurator(this.name, context, this.config);
    }
}

