/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.routing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.distribution.DistributionInfo;
import org.infinispan.remoting.transport.Address;
import org.wildfly.clustering.group.Node;
import org.wildfly.clustering.infinispan.spi.distribution.Key;
import org.wildfly.clustering.registry.Registry;
import org.wildfly.clustering.spi.NodeFactory;
import org.wildfly.clustering.web.infinispan.routing.RankedRouteLocatorConfiguration;
import org.wildfly.clustering.web.routing.RouteLocator;

public class RankedRouteLocator
implements RouteLocator {
    private final NodeFactory<Address> factory;
    private final Registry<String, Void> registry;
    private final Cache<Key<String>, ?> cache;
    private final String localRoute;
    private final boolean preferPrimary;
    private final String delimiter;
    private final int maxRoutes;

    public RankedRouteLocator(RankedRouteLocatorConfiguration config) {
        this.cache = config.getCache();
        this.registry = config.getRegistry();
        this.factory = config.getMemberFactory();
        this.localRoute = (String)this.registry.getEntry(this.registry.getGroup().getLocalMember()).getKey();
        CacheMode mode = config.getCache().getCacheConfiguration().clustering().cacheMode();
        this.preferPrimary = mode.needsStateTransfer() && !mode.isScattered();
        this.delimiter = config.getDelimiter();
        this.maxRoutes = config.getMaxRoutes();
    }

    public String locate(String sessionId) {
        Map.Entry entry;
        boolean localOwner;
        DistributionInfo info = this.preferPrimary ? this.cache.getAdvancedCache().getDistributionManager().getCacheTopology().getDistribution((Object)new Key((Object)sessionId)) : null;
        List addresses = info != null ? info.writeOwners() : Collections.emptyList();
        int size = Math.min(addresses.size(), this.maxRoutes);
        boolean bl = localOwner = info == null || info.isWriteOwner();
        ArrayList routes = !addresses.isEmpty() ? new ArrayList(localOwner ? size : size + 1) : Collections.emptyList();
        for (Address address : addresses.subList(0, size)) {
            Node member = this.factory.createNode((Object)address);
            Map.Entry entry2 = this.registry.getEntry(member);
            if (entry2 == null) continue;
            routes.add(entry2.getKey());
        }
        if (!localOwner && routes.size() < this.maxRoutes && (entry = this.registry.getEntry(this.registry.getGroup().getLocalMember())) != null) {
            routes.add(entry.getKey());
        }
        return !routes.isEmpty() ? String.join((CharSequence)this.delimiter, routes) : this.localRoute;
    }
}

