/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.federation;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQNonExistentQueueException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.MessageHandler;
import org.apache.activemq.artemis.api.core.client.SessionFailureListener;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.federation.FederatedConsumerKey;
import org.apache.activemq.artemis.core.server.federation.Federation;
import org.apache.activemq.artemis.core.server.federation.FederationUpstream;
import org.apache.activemq.artemis.core.server.transformer.Transformer;

public class FederatedQueueConsumer
implements MessageHandler,
SessionFailureListener {
    public static final String FEDERATION_NAME = "federation-name";
    public static final String FEDERATION_UPSTREAM_NAME = "federation-upstream-name";
    private final ActiveMQServer server;
    private final Federation federation;
    private final FederatedConsumerKey key;
    private final Transformer transformer;
    private final FederationUpstream upstream;
    private final AtomicInteger count = new AtomicInteger();
    private final ScheduledExecutorService scheduledExecutorService;
    private final int intialConnectDelayMultiplier = 2;
    private final int intialConnectDelayMax = 30;
    private final ClientSessionCallback clientSessionCallback;
    private ClientSessionFactory clientSessionFactory;
    private ClientSession clientSession;
    private ClientConsumer clientConsumer;

    public FederatedQueueConsumer(Federation federation, ActiveMQServer server, Transformer transformer, FederatedConsumerKey key, FederationUpstream upstream, ClientSessionCallback clientSessionCallback) {
        this.federation = federation;
        this.server = server;
        this.key = key;
        this.transformer = transformer;
        this.upstream = upstream;
        this.scheduledExecutorService = server.getScheduledPool();
        this.clientSessionCallback = clientSessionCallback;
    }

    public int incrementCount() {
        return this.count.incrementAndGet();
    }

    public int decrementCount() {
        return this.count.decrementAndGet();
    }

    public void start() {
        this.scheduleConnect(0);
    }

    private void scheduleConnect(int delay) {
        this.scheduledExecutorService.schedule(() -> {
            try {
                this.connect();
            }
            catch (Exception e) {
                this.scheduleConnect(FederatedQueueConsumer.getNextDelay(delay, 2, 30));
            }
        }, (long)delay, TimeUnit.SECONDS);
    }

    static int getNextDelay(int delay, int delayMultiplier, int delayMax) {
        int nextDelay;
        if (delay == 0) {
            nextDelay = 1;
        } else {
            nextDelay = delay * delayMultiplier;
            if (nextDelay > delayMax) {
                nextDelay = delayMax;
            }
        }
        return nextDelay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect() throws Exception {
        block10: {
            try {
                if (this.clientConsumer != null) break block10;
                FederatedQueueConsumer federatedQueueConsumer = this;
                synchronized (federatedQueueConsumer) {
                    this.clientSessionFactory = this.upstream.getConnection().clientSessionFactory();
                    this.clientSession = this.clientSessionFactory.createSession(this.upstream.getUser(), this.upstream.getPassword(), false, true, true, this.clientSessionFactory.getServerLocator().isPreAcknowledge(), this.clientSessionFactory.getServerLocator().getAckBatchSize());
                    this.clientSession.addFailureListener((SessionFailureListener)this);
                    this.clientSession.addMetaData(FEDERATION_NAME, this.federation.getName().toString());
                    this.clientSession.addMetaData(FEDERATION_UPSTREAM_NAME, this.upstream.getName().toString());
                    this.clientSession.start();
                    if (this.clientSessionCallback != null) {
                        this.clientSessionCallback.callback(this.clientSession);
                    }
                    if (!this.clientSession.queueQuery(this.key.getQueueName()).isExists()) {
                        throw new ActiveMQNonExistentQueueException("Queue " + this.key.getQueueName() + " does not exist on remote");
                    }
                    this.clientConsumer = this.clientSession.createConsumer(this.key.getQueueName(), this.key.getFilterString(), this.key.getPriority(), false);
                    this.clientConsumer.setMessageHandler((MessageHandler)this);
                }
            }
            catch (Exception e) {
                try {
                    if (this.clientSessionFactory != null) {
                        this.clientSessionFactory.cleanup();
                    }
                    this.disconnect();
                }
                catch (ActiveMQException activeMQException) {
                    // empty catch block
                }
                throw e;
            }
        }
    }

    public void close() {
        this.scheduleDisconnect(0);
    }

    private void scheduleDisconnect(int delay) {
        this.scheduledExecutorService.schedule(() -> {
            try {
                this.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }, (long)delay, TimeUnit.SECONDS);
    }

    private void disconnect() throws ActiveMQException {
        if (this.clientConsumer != null) {
            this.clientConsumer.close();
        }
        if (this.clientSession != null) {
            this.clientSession.close();
        }
        if (this.clientSessionFactory != null) {
            this.clientSessionFactory.close();
        }
        this.clientConsumer = null;
        this.clientSession = null;
        this.clientSessionFactory = null;
    }

    public void onMessage(ClientMessage clientMessage) {
        try {
            ClientMessage message;
            Object object = message = this.transformer == null ? clientMessage : this.transformer.transform((Message)clientMessage);
            if (message != null) {
                this.server.getPostOffice().route((Message)message, true);
            }
            clientMessage.acknowledge();
        }
        catch (Exception e) {
            try {
                this.clientSession.rollback();
            }
            catch (ActiveMQException activeMQException) {
                // empty catch block
            }
        }
    }

    public void connectionFailed(ActiveMQException exception, boolean failedOver) {
        this.connectionFailed(exception, failedOver, null);
    }

    public void connectionFailed(ActiveMQException exception, boolean failedOver, String scaleDownTargetNodeID) {
        try {
            this.clientSessionFactory.cleanup();
            this.clientSessionFactory.close();
            this.clientConsumer = null;
            this.clientSession = null;
            this.clientSessionFactory = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.start();
    }

    public void beforeReconnect(ActiveMQException exception) {
    }

    public static interface ClientSessionCallback {
        public void callback(ClientSession var1) throws ActiveMQException;
    }
}

