/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.cache.session;

import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.wildfly.clustering.web.cache.session.ImmutableSessionAttributesFilter;
import org.wildfly.clustering.web.cache.session.SessionAttributesFilter;
import org.wildfly.clustering.web.cache.session.SessionBindingNotifier;
import org.wildfly.clustering.web.session.HttpSessionBindingListenerProvider;
import org.wildfly.clustering.web.session.ImmutableSession;

public class ImmutableSessionBindingNotifier<S, C, L>
implements SessionBindingNotifier {
    private final HttpSessionBindingListenerProvider<S, C, L> provider;
    private final ImmutableSession session;
    private final C context;
    private final SessionAttributesFilter filter;

    public ImmutableSessionBindingNotifier(HttpSessionBindingListenerProvider<S, C, L> provider, ImmutableSession session, C context) {
        this(provider, session, context, new ImmutableSessionAttributesFilter(session));
    }

    ImmutableSessionBindingNotifier(HttpSessionBindingListenerProvider<S, C, L> provider, ImmutableSession session, C context, SessionAttributesFilter filter) {
        this.provider = provider;
        this.session = session;
        this.context = context;
        this.filter = filter;
    }

    @Override
    public void bound() {
        this.notify(arg_0 -> this.provider.valueBoundNotifier(arg_0));
    }

    @Override
    public void unbound() {
        this.notify(arg_0 -> this.provider.valueUnboundNotifier(arg_0));
    }

    private void notify(Function<L, BiConsumer<S, String>> notifierFactory) {
        Map listeners = this.filter.getAttributes(this.provider.getHttpSessionBindingListenerClass());
        if (!listeners.isEmpty()) {
            for (Map.Entry entry : listeners.entrySet()) {
                Object listener = entry.getValue();
                Object session = this.provider.createHttpSession(this.session, this.context);
                notifierFactory.apply(listener).accept(session, entry.getKey());
            }
        }
    }
}

