/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem.remote;

import io.reactivex.Flowable;
import io.reactivex.functions.Action;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.reactivex.internal.functions.Functions;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.MetadataValue;
import org.infinispan.client.hotrod.ProtocolVersion;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.impl.Util;
import org.infinispan.client.hotrod.impl.operations.OperationsFactory;
import org.infinispan.client.hotrod.impl.operations.PingResponse;
import org.infinispan.commons.configuration.ConfiguredBy;
import org.infinispan.commons.io.ByteBuffer;
import org.infinispan.commons.persistence.Store;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.IteratorMapper;
import org.infinispan.persistence.PersistenceUtil;
import org.infinispan.persistence.spi.AdvancedCacheWriter;
import org.infinispan.persistence.spi.InitializationContext;
import org.infinispan.persistence.spi.MarshallableEntry;
import org.infinispan.persistence.spi.MarshallableEntryFactory;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.persistence.spi.SegmentedAdvancedLoadWriteStore;
import org.jboss.as.clustering.infinispan.InfinispanLogger;
import org.jboss.as.clustering.infinispan.subsystem.remote.HotRodStoreConfiguration;
import org.reactivestreams.Publisher;
import org.wildfly.clustering.infinispan.client.RemoteCacheContainer;
import org.wildfly.clustering.infinispan.client.near.EmptyNearCacheService;

@Store(shared=true)
@ConfiguredBy(value=HotRodStoreConfiguration.class)
public class HotRodStore<K, V>
implements SegmentedAdvancedLoadWriteStore<K, V>,
Function<CloseableIterator<byte[]>, Publisher<K>>,
Consumer<K> {
    private InitializationContext ctx;
    private MarshallableEntryFactory<K, V> entryFactory;
    private OperationsFactory operationsFactory;
    private RemoteCache<byte[], byte[]> remoteCache;
    private int maxBatchSize;

    public void init(InitializationContext ctx) {
        this.ctx = ctx;
        HotRodStoreConfiguration configuration = (HotRodStoreConfiguration)ctx.getConfiguration();
        RemoteCacheContainer remoteCacheContainer = (RemoteCacheContainer)configuration.attributes().attribute(HotRodStoreConfiguration.REMOTE_CACHE_CONTAINER).get();
        String cacheConfiguration = (String)configuration.attributes().attribute(HotRodStoreConfiguration.CACHE_CONFIGURATION).get();
        String cacheName = ctx.getCache().getName();
        this.maxBatchSize = configuration.maxBatchSize();
        this.entryFactory = ctx.getMarshallableEntryFactory();
        try {
            RemoteCacheContainer.NearCacheRegistration registration;
            ProtocolVersion protocolVersion = remoteCacheContainer.getConfiguration().version();
            if (protocolVersion.compareTo((Enum)ProtocolVersion.PROTOCOL_VERSION_27) < 0) {
                registration = remoteCacheContainer.registerNearCacheFactory(cacheName, EmptyNearCacheService::new);
                Throwable throwable = null;
                try {
                    this.remoteCache = remoteCacheContainer.getCache(cacheName, false);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (registration != null) {
                        if (throwable != null) {
                            try {
                                registration.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            registration.close();
                        }
                    }
                }
                if (this.remoteCache == null) {
                    throw InfinispanLogger.ROOT_LOGGER.remoteCacheMustBeDefined(protocolVersion.toString(), cacheName);
                }
            } else {
                InfinispanLogger.ROOT_LOGGER.remoteCacheCreated(cacheName, cacheConfiguration);
                registration = remoteCacheContainer.registerNearCacheFactory(cacheName, EmptyNearCacheService::new);
                Throwable throwable = null;
                try {
                    this.remoteCache = remoteCacheContainer.administration().getOrCreateCache(cacheName, cacheConfiguration);
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (registration != null) {
                        if (throwable != null) {
                            try {
                                registration.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            registration.close();
                        }
                    }
                }
            }
            RemoteCacheManager manager = this.remoteCache.getRemoteCacheManager();
            this.operationsFactory = new OperationsFactory(manager.getChannelFactory(), manager.getCodec(), null, manager.getConfiguration());
        }
        catch (HotRodClientException ex) {
            throw new PersistenceException((Throwable)ex);
        }
    }

    public void start() {
        this.remoteCache.start();
    }

    public void stop() {
        this.remoteCache.stop();
    }

    public MarshallableEntry<K, V> loadEntry(Object key) throws PersistenceException {
        MetadataValue value = this.remoteCache.getWithMetadata((Object)this.marshall(key));
        if (value == null) {
            return null;
        }
        Map.Entry<ByteBuffer, ByteBuffer> entry = this.unmarshallEntry((byte[])value.getValue());
        return this.entryFactory.create(key, entry.getKey(), entry.getValue(), value.getCreated(), value.getLastUsed());
    }

    private MarshallableEntry<K, V> asMarshalledEntry(Object key) {
        return this.entryFactory.create(key, null);
    }

    public void write(MarshallableEntry<? extends K, ? extends V> entry) {
        this.remoteCache.put((Object)this.marshall(entry.getKey()), (Object)this.marshall(entry));
    }

    public CompletionStage<Void> bulkUpdate(Publisher<MarshallableEntry<? extends K, ? extends V>> marshalledEntries) {
        final CompletableFuture<Void> future = new CompletableFuture<Void>();
        Action completeAction = new Action(){

            public void run() {
                future.complete(null);
            }
        };
        Flowable.fromPublisher(marshalledEntries).buffer(this.maxBatchSize).doOnNext(entries -> this.remoteCache.putAll(entries.stream().collect(Collectors.toMap(this::marshallKey, this::marshallEntry)))).doOnError(PersistenceException::new).subscribe(Functions.emptyConsumer(), future::completeExceptionally, completeAction);
        return future;
    }

    public boolean contains(Object key) {
        return this.remoteCache.containsKey((Object)this.marshall(key));
    }

    public boolean delete(Object key) {
        return this.remoteCache.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).remove((Object)this.marshall(key)) != null;
    }

    public Flowable<K> publishKeys(Predicate<? super K> filter) {
        return this.publishKeys(null, filter);
    }

    public Flowable<K> publishKeys(IntSet segments, Predicate<? super K> filter) {
        Flowable keys = Flowable.using((Callable)Functions.justCallable((Object)this.remoteCache.keySet(segments).iterator()), (Function)this, CloseableIterator::close);
        return filter != null ? keys.filter(filter::test) : keys;
    }

    public Publisher<K> apply(CloseableIterator<byte[]> iterator) {
        return Flowable.fromIterable(new SimpleIterable(new IteratorMapper(iterator, this::unmarshallKey)));
    }

    public Publisher<MarshallableEntry<K, V>> entryPublisher(IntSet segments, Predicate<? super K> filter, boolean fetchValue, boolean fetchMetadata) {
        Flowable<? super K> keys = this.publishKeys(filter);
        return fetchValue || fetchMetadata ? keys.map(this::loadEntry) : keys.map(this::asMarshalledEntry);
    }

    public int size() {
        return this.remoteCache.size();
    }

    public void clear() {
        this.remoteCache.clear();
    }

    public void purge(Executor threadPool, AdvancedCacheWriter.PurgeListener<? super K> listener) {
    }

    private byte[] marshallKey(MarshallableEntry<? extends K, ? extends V> entry) {
        return this.marshall(entry.getKey());
    }

    private byte[] marshallEntry(MarshallableEntry<? extends K, ? extends V> entry) {
        return this.marshall(new AbstractMap.SimpleImmutableEntry<ByteBuffer, ByteBuffer>(entry.getValueBytes(), entry.getMetadataBytes()));
    }

    private byte[] marshall(Object object) {
        try {
            return this.ctx.getPersistenceMarshaller().objectToByteBuffer(object);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PersistenceException((Throwable)e);
        }
        catch (IOException e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    private K unmarshallKey(byte[] bytes) {
        return (K)this.unmarshall(bytes);
    }

    private Map.Entry<ByteBuffer, ByteBuffer> unmarshallEntry(byte[] bytes) {
        return (Map.Entry)this.unmarshall(bytes);
    }

    private Object unmarshall(byte[] bytes) {
        try {
            return this.ctx.getPersistenceMarshaller().objectFromByteBuffer(bytes);
        }
        catch (IOException | ClassNotFoundException e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    public boolean isAvailable() {
        return ((PingResponse)Util.await((CompletableFuture)this.operationsFactory.newFaultTolerantPingOperation().execute())).isSuccess();
    }

    public int size(IntSet segments) {
        return PersistenceUtil.count((SegmentedAdvancedLoadWriteStore)this, (IntSet)segments);
    }

    public void clear(IntSet segments) {
        this.publishKeys(segments, null).blockingForEach((Consumer)this);
    }

    public void accept(K key) {
        this.remoteCache.remove((Object)this.marshall(key));
    }

    private static class SimpleIterable<T>
    implements Iterable<T> {
        private final Iterator<T> iterator;

        SimpleIterable(Iterator<T> iterator) {
            this.iterator = iterator;
        }

        @Override
        public Iterator<T> iterator() {
            return this.iterator;
        }
    }
}

