/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.xsite;

import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.DDAsyncInterceptor;
import org.infinispan.interceptors.InvocationStage;
import org.infinispan.interceptors.InvocationSuccessFunction;
import org.infinispan.transaction.impl.AbstractCacheTransaction;
import org.infinispan.transaction.impl.LocalTransaction;
import org.infinispan.transaction.impl.TransactionTable;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.infinispan.xsite.BackupSender;

public class BaseBackupInterceptor
extends DDAsyncInterceptor {
    @Inject
    protected BackupSender backupSender;
    @Inject
    protected TransactionTable txTable;
    protected static final Log log = LogFactory.getLog(BaseBackupInterceptor.class);
    protected static final boolean trace = log.isTraceEnabled();
    private final InvocationSuccessFunction<ClearCommand> handleClearReturn = this::handleClearReturn;

    @Override
    public final Object visitClearCommand(InvocationContext ctx, ClearCommand command) {
        if (!ctx.isOriginLocal() || BaseBackupInterceptor.skipXSiteBackup(command)) {
            return this.invokeNext(ctx, command);
        }
        return this.invokeNextThenApply(ctx, command, this.handleClearReturn);
    }

    @Override
    public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        if (!this.shouldInvokeRemoteTxCommand(ctx)) {
            return this.invokeNext(ctx, command);
        }
        boolean isTxFromRemoteSite = this.isTxFromRemoteSite(command.getGlobalTransaction());
        if (isTxFromRemoteSite) {
            return this.invokeNext(ctx, command);
        }
        InvocationStage stage = this.backupSender.backupPrepare(command, (AbstractCacheTransaction)ctx.getCacheTransaction(), ctx.getTransaction());
        return this.invokeNextAndWaitForCrossSite(ctx, command, stage);
    }

    Object invokeNextAndWaitForCrossSite(TxInvocationContext ctx, VisitableCommand command, InvocationStage stage) {
        return this.invokeNextThenApply(ctx, command, stage::thenReturn);
    }

    boolean isTxFromRemoteSite(GlobalTransaction gtx) {
        LocalTransaction remoteTx = this.txTable.getLocalTransaction(gtx);
        return remoteTx != null && remoteTx.isFromRemoteSite();
    }

    boolean shouldInvokeRemoteTxCommand(TxInvocationContext ctx) {
        boolean shouldBackupRemotely = ctx.isOriginLocal() && ctx.hasModifications() && !((AbstractCacheTransaction)ctx.getCacheTransaction()).isFromStateTransfer();
        this.getLog().tracef("Should backup remotely? %s", shouldBackupRemotely);
        return shouldBackupRemotely;
    }

    static boolean skipXSiteBackup(FlagAffectedCommand command) {
        return command.hasAnyFlag(FlagBitSets.SKIP_XSITE_BACKUP);
    }

    protected Log getLog() {
        return log;
    }

    private Object handleClearReturn(InvocationContext ctx, ClearCommand rCommand, Object rv) throws Throwable {
        InvocationStage stage = this.backupSender.backupWrite(rCommand, rCommand);
        return stage.thenReturn(ctx, rCommand, rv);
    }
}

