/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.functional;

import java.util.Optional;
import org.infinispan.commons.util.Experimental;
import org.infinispan.container.versioning.EntryVersion;

@Experimental
public interface MetaParam<T> {
    public T get();

    @Experimental
    public static final class MetaLoadedFromPersistence
    implements MetaParam<Boolean> {
        public static MetaLoadedFromPersistence LOADED = new MetaLoadedFromPersistence(true);
        public static MetaLoadedFromPersistence NOT_LOADED = new MetaLoadedFromPersistence(false);
        private boolean loaded;

        private MetaLoadedFromPersistence(boolean loaded) {
            this.loaded = loaded;
        }

        @Override
        public Boolean get() {
            return this.loaded;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MetaLoadedFromPersistence that = (MetaLoadedFromPersistence)o;
            return this.loaded == that.loaded;
        }

        public int hashCode() {
            return this.loaded ? 1 : 0;
        }

        public static MetaLoadedFromPersistence of(boolean loaded) {
            return loaded ? LOADED : NOT_LOADED;
        }
    }

    @Experimental
    public static abstract class MetaLong
    implements MetaParam<Long> {
        protected final long value;

        public MetaLong(long value) {
            this.value = value;
        }

        @Override
        public Long get() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MetaLong longMeta = (MetaLong)o;
            return this.value == longMeta.value;
        }

        public int hashCode() {
            return (int)(this.value ^ this.value >>> 32);
        }
    }

    @Experimental
    public static class MetaEntryVersion
    implements Writable<EntryVersion> {
        private final EntryVersion entryVersion;

        public MetaEntryVersion(EntryVersion entryVersion) {
            this.entryVersion = entryVersion;
        }

        @Override
        public EntryVersion get() {
            return this.entryVersion;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MetaEntryVersion that = (MetaEntryVersion)o;
            return this.entryVersion.equals(that.entryVersion);
        }

        public int hashCode() {
            return this.entryVersion.hashCode();
        }

        public String toString() {
            return "MetaEntryVersion=" + this.entryVersion;
        }
    }

    @Experimental
    public static final class MetaLastUsed
    extends MetaLong {
        public MetaLastUsed(long lastUsed) {
            super(lastUsed);
        }

        public String toString() {
            return "MetaLastUsed=" + this.value;
        }
    }

    @Experimental
    public static final class MetaMaxIdle
    extends MetaLong
    implements Writable<Long> {
        private static final MetaMaxIdle DEFAULT = new MetaMaxIdle(-1L);

        public MetaMaxIdle(long maxIdle) {
            super(maxIdle);
        }

        public String toString() {
            return "MetaMaxIdle=" + this.value;
        }

        public static MetaMaxIdle defaultValue() {
            return DEFAULT;
        }
    }

    @Experimental
    public static final class MetaCreated
    extends MetaLong {
        public MetaCreated(long created) {
            super(created);
        }

        public String toString() {
            return "MetaCreated=" + this.value;
        }
    }

    @Experimental
    public static final class MetaLifespan
    extends MetaLong
    implements Writable<Long> {
        private static final MetaLifespan DEFAULT = new MetaLifespan(-1L);

        public MetaLifespan(long lifespan) {
            super(lifespan);
        }

        public String toString() {
            return "MetaLifespan=" + this.value;
        }

        public static MetaLifespan defaultValue() {
            return DEFAULT;
        }
    }

    @Experimental
    public static interface Writable<T>
    extends MetaParam<T> {
    }

    @Experimental
    public static interface Lookup {
        public <T extends MetaParam> Optional<T> findMetaParam(Class<T> var1);
    }
}

