/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.async;

import io.reactivex.Flowable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Spliterators;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.jcip.annotations.GuardedBy;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.configuration.cache.AsyncStoreConfiguration;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.PersistenceConfiguration;
import org.infinispan.factories.threads.DefaultThreadFactory;
import org.infinispan.persistence.async.BufferLock;
import org.infinispan.persistence.async.State;
import org.infinispan.persistence.modifications.Modification;
import org.infinispan.persistence.modifications.ModificationsList;
import org.infinispan.persistence.modifications.Remove;
import org.infinispan.persistence.modifications.Store;
import org.infinispan.persistence.spi.CacheWriter;
import org.infinispan.persistence.spi.InitializationContext;
import org.infinispan.persistence.spi.MarshallableEntry;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.persistence.support.DelegatingCacheWriter;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.reactivestreams.Publisher;

public class AsyncCacheWriter
extends DelegatingCacheWriter {
    private static final Log log = LogFactory.getLog(AsyncCacheWriter.class);
    private static final boolean trace = log.isTraceEnabled();
    private ExecutorService executor;
    private Thread coordinator;
    private int concurrencyLevel;
    private String cacheName;
    private String nodeName;
    protected BufferLock stateLock;
    @GuardedBy(value="stateLock")
    protected final AtomicReference<State> state = new AtomicReference();
    @GuardedBy(value="stateLock")
    private boolean stopped;
    private final Lock availabilityLock = new ReentrantLock();
    private final Condition availability = this.availabilityLock.newCondition();
    @GuardedBy(value="availabilityLock")
    private volatile boolean delegateAvailable = true;
    protected AsyncStoreConfiguration asyncConfiguration;

    public AsyncCacheWriter(CacheWriter delegate) {
        super(delegate);
    }

    @Override
    public void init(InitializationContext ctx) {
        super.init(ctx);
        this.asyncConfiguration = ctx.getConfiguration().async();
        Cache cache = ctx.getCache();
        Configuration cacheCfg = cache != null ? cache.getCacheConfiguration() : null;
        this.concurrencyLevel = cacheCfg != null ? cacheCfg.locking().concurrencyLevel() : 16;
        this.cacheName = cache != null ? cache.getName() : null;
        this.nodeName = cache != null ? cache.getCacheManager().getCacheManagerConfiguration().transport().nodeName() : null;
    }

    @Override
    public void start() {
        log.debugf("Async cache loader starting %s", this);
        this.state.set(this.newState(false, null));
        this.stopped = false;
        this.stateLock = new BufferLock(this.asyncConfiguration.modificationQueueSize());
        int poolSize = this.asyncConfiguration.threadPoolSize();
        DefaultThreadFactory processorThreadFactory = new DefaultThreadFactory(null, 5, "%c-%n-p%f-t%t", this.nodeName, "AsyncStoreProcessor");
        this.executor = new ThreadPoolExecutor(poolSize, poolSize, 120L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), processorThreadFactory);
        ((ThreadPoolExecutor)this.executor).allowCoreThreadTimeOut(true);
        DefaultThreadFactory coordinatorThreadFactory = new DefaultThreadFactory(null, 5, "%c-%n-p%f-t%t", this.nodeName, "AsyncStoreCoordinator");
        this.coordinator = coordinatorThreadFactory.newThread(new AsyncStoreCoordinator(this.asyncConfiguration.failSilently()));
        this.coordinator.start();
    }

    @Override
    public void stop() {
        if (trace) {
            log.tracef("Stop async store %s", this);
        }
        this.stateLock.writeLock(0);
        this.stopped = true;
        this.stateLock.writeUnlock();
        try {
            if (!this.asyncConfiguration.failSilently() && !this.delegateAvailable) {
                this.coordinator.interrupt();
                this.executor.shutdownNow();
            } else {
                this.coordinator.join();
                this.executor.shutdown();
            }
            if (!this.executor.awaitTermination(1L, TimeUnit.SECONDS)) {
                Log.PERSISTENCE.errorAsyncStoreNotStopped();
            }
        }
        catch (InterruptedException e) {
            Log.PERSISTENCE.interruptedWaitingAsyncStorePush(e);
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public boolean isAvailable() {
        if (this.stopped) {
            return false;
        }
        if (this.asyncConfiguration.failSilently()) {
            return true;
        }
        boolean available = false;
        try {
            available = this.actual.isAvailable();
        }
        catch (Throwable t) {
            log.debugf("Error encountered when calling isAvailable on %s: %s", this.actual, t);
        }
        this.availabilityLock.lock();
        try {
            if (available != this.delegateAvailable) {
                this.delegateAvailable = available;
                if (this.delegateAvailable) {
                    this.availability.signalAll();
                }
            }
        }
        finally {
            this.availabilityLock.unlock();
        }
        return this.delegateAvailable || this.stateLock.hasCapacity();
    }

    @Override
    public void write(MarshallableEntry entry) {
        this.put(new Store(entry.getKey(), entry), 1);
    }

    @Override
    public CompletionStage<Void> bulkUpdate(Publisher publisher) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        Flowable.fromPublisher((Publisher)publisher).map(me -> new Store(me.getKey(), (MarshallableEntry)me)).cast(Modification.class).toList().subscribe(modifications -> {
            this.putAll((List<Modification>)modifications);
            future.complete(null);
        }, future::completeExceptionally);
        return future;
    }

    @Override
    public void deleteBatch(Iterable keys) {
        this.putAll(StreamSupport.stream(keys.spliterator(), false).map(Remove::new).collect(Collectors.toList()));
    }

    @Override
    public boolean delete(Object key) {
        this.put(new Remove(key), 1);
        return true;
    }

    protected void applyModificationsSync(List<Modification> mods) throws PersistenceException {
        this.actual.bulkUpdate(Flowable.fromIterable(mods).filter(m -> m.getType() == Modification.Type.STORE).map(Store.class::cast).map(Store::getStoredValue));
        this.actual.deleteBatch(() -> StreamSupport.stream(Spliterators.spliterator(mods, 256), false).filter(m -> m.getType() == Modification.Type.REMOVE).map(Remove.class::cast).map(Remove::getKey).iterator());
    }

    protected State newState(boolean clear, State next) {
        ConcurrentHashMap<Object, Modification> map = new ConcurrentHashMap<Object, Modification>(64, 0.75f, this.concurrencyLevel);
        return new State(clear, map, next);
    }

    void assertNotStopped() throws CacheException {
        if (this.stopped) {
            throw new CacheException("AsyncCacheWriter stopped; no longer accepting more entries.");
        }
    }

    private void put(Modification mod, int count) {
        this.stateLock.writeLock(count);
        try {
            if (trace) {
                log.tracef("Queue modification: %s", mod);
            }
            this.assertNotStopped();
            this.state.get().put(mod);
        }
        finally {
            this.stateLock.writeUnlock();
        }
    }

    private void putAll(List<Modification> mods) {
        this.stateLock.writeLock(mods.size());
        try {
            this.state.get().put(new ModificationsList(mods));
        }
        finally {
            this.stateLock.writeUnlock();
        }
    }

    public AtomicReference<State> getState() {
        return this.state;
    }

    protected void clearStore() {
    }

    private class AsyncStoreProcessor
    implements Runnable {
        private final List<Modification> modifications;
        private final State myState;
        private final boolean failSilently;
        private final PersistenceConfiguration configuration;

        AsyncStoreProcessor(List<Modification> modifications, State myState, boolean failSilently) {
            this.modifications = modifications;
            this.myState = myState;
            this.failSilently = failSilently;
            this.configuration = AsyncCacheWriter.this.ctx.getCache().getCacheConfiguration().persistence();
        }

        @Override
        public void run() {
            block7: {
                State s;
                try {
                    this.retryWork(this.configuration.connectionAttempts());
                    this.myState.workerThreads.countDown();
                    if (this.myState.workerThreads.getCount() != 0L || this.myState.next != null) break block7;
                    s = AsyncCacheWriter.this.state.get();
                }
                catch (Throwable throwable) {
                    this.myState.workerThreads.countDown();
                    if (this.myState.workerThreads.getCount() == 0L && this.myState.next == null) {
                        State s2 = AsyncCacheWriter.this.state.get();
                        while (s2 != null) {
                            if (s2.next == this.myState) {
                                s2.next = null;
                            }
                            s2 = s2.next;
                        }
                    }
                    throw throwable;
                }
                while (s != null) {
                    if (s.next == this.myState) {
                        s.next = null;
                    }
                    s = s.next;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void retryWork(int maxRetries) {
            for (int attempt = 0; attempt < maxRetries; ++attempt) {
                if (attempt > 0 && log.isDebugEnabled()) {
                    log.debugf("Retrying due to previous failure. %s attempts left.", maxRetries - attempt);
                }
                try {
                    if (!this.failSilently) {
                        AsyncCacheWriter.this.availabilityLock.lock();
                        try {
                            if (!AsyncCacheWriter.this.delegateAvailable) {
                                if (AsyncCacheWriter.this.stopped) {
                                    log.debugf("Failed to write async modifications to %s as the store is unavailable and stop() was called", AsyncCacheWriter.this.actual);
                                    return;
                                }
                                AsyncCacheWriter.this.availability.await();
                            }
                        }
                        catch (InterruptedException e) {
                            log.debugf("%s interrupted: %s", this, e);
                            Thread.currentThread().interrupt();
                            break;
                        }
                        finally {
                            AsyncCacheWriter.this.availabilityLock.unlock();
                        }
                    }
                    AsyncCacheWriter.this.applyModificationsSync(this.modifications);
                    return;
                }
                catch (Exception e) {
                    if (log.isDebugEnabled()) {
                        log.debug("Failed to process async modifications", e);
                    }
                    if (this.failSilently) continue;
                    try {
                        Thread.sleep(this.configuration.availabilityInterval());
                        continue;
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                        break;
                    }
                }
            }
            Log.PERSISTENCE.unableToProcessAsyncModifications(maxRetries);
        }
    }

    private class AsyncStoreCoordinator
    implements Runnable {
        final boolean failSilently;

        AsyncStoreCoordinator(boolean failSilently) {
            this.failSilently = failSilently;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            LogFactory.pushNDC(AsyncCacheWriter.this.cacheName, trace);
            try {
                while (true) {
                    State tail;
                    boolean shouldStop;
                    State s;
                    AsyncCacheWriter.this.stateLock.readLock();
                    if (!this.failSilently) {
                        AsyncCacheWriter.this.availabilityLock.lock();
                        try {
                            if (!AsyncCacheWriter.this.delegateAvailable) {
                                AsyncCacheWriter.this.stateLock.readUnlock();
                                AsyncCacheWriter.this.availability.await();
                                continue;
                            }
                        }
                        catch (InterruptedException e) {
                            log.debugf("%s interrupted: %s", this, e);
                            Thread.currentThread().interrupt();
                            LogFactory.popNDC(trace);
                            return;
                        }
                        finally {
                            AsyncCacheWriter.this.availabilityLock.unlock();
                            continue;
                        }
                    }
                    try {
                        s = AsyncCacheWriter.this.state.get();
                        shouldStop = AsyncCacheWriter.this.stopped;
                        tail = s.next;
                        assert (tail == null || tail.next == null) : "State chain longer than 3 entries!";
                        State head = AsyncCacheWriter.this.newState(false, s);
                        AsyncCacheWriter.this.state.set(head);
                        AsyncCacheWriter.this.stateLock.reset(0);
                    }
                    finally {
                        AsyncCacheWriter.this.stateLock.readUnlock();
                    }
                    try {
                        if (s.clear) {
                            if (tail != null) {
                                tail.workerThreads.await();
                            }
                            AsyncCacheWriter.this.clearStore();
                        }
                        ArrayList<Modification> mods = new ArrayList<Modification>(s.modifications.size());
                        ArrayList<Modification> deferredMods = new ArrayList<Modification>();
                        if (tail == null || tail.workerThreads.getCount() <= 0L) {
                            mods.addAll(s.modifications.values());
                        } else {
                            for (Map.Entry e : s.modifications.entrySet()) {
                                if (!tail.modifications.containsKey(e.getKey())) {
                                    mods.add((Modification)e.getValue());
                                    continue;
                                }
                                deferredMods.add((Modification)e.getValue());
                            }
                        }
                        List<AsyncStoreProcessor> procs = this.createProcessors(s, mods);
                        List<AsyncStoreProcessor> deferredProcs = this.createProcessors(s, deferredMods);
                        s.workerThreads = new CountDownLatch(procs.size() + deferredProcs.size());
                        for (AsyncStoreProcessor processor : procs) {
                            AsyncCacheWriter.this.executor.execute(processor);
                        }
                        if (tail != null) {
                            tail.workerThreads.await();
                            s.next = null;
                        }
                        for (AsyncStoreProcessor processor : deferredProcs) {
                            AsyncCacheWriter.this.executor.execute(processor);
                        }
                        if (!shouldStop) continue;
                        s.workerThreads.await();
                        return;
                    }
                    catch (Exception e) {
                        Log.PERSISTENCE.unexpectedErrorInAsyncStoreCoordinator(e);
                    }
                }
            }
            finally {
                LogFactory.popNDC(trace);
            }
        }

        private List<AsyncStoreProcessor> createProcessors(State state, List<Modification> mods) {
            ArrayList<AsyncStoreProcessor> result = new ArrayList<AsyncStoreProcessor>();
            int threads = Math.min(mods.size(), AsyncCacheWriter.this.asyncConfiguration.threadPoolSize());
            if (threads > 0) {
                int start = 0;
                int quotient = mods.size() / threads;
                int remainder = mods.size() % threads;
                for (int i = 0; i < threads; ++i) {
                    int end = start + quotient + (i < remainder ? 1 : 0);
                    result.add(new AsyncStoreProcessor(mods.subList(start, end), state, this.failSilently));
                    start = end;
                }
                assert (start == mods.size()) : "Thread distribution is broken!";
            }
            return result;
        }
    }
}

