/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.authz;

import org.wildfly.common.Assert;
import org.wildfly.security.authz.Roles;

@FunctionalInterface
public interface RoleMapper {
    public static final RoleMapper IDENTITY_ROLE_MAPPER = rolesToMap -> rolesToMap;

    public Roles mapRoles(Roles var1);

    default public RoleMapper and(RoleMapper other) {
        Assert.checkNotNullParam("other", other);
        return rolesToMap -> this.mapRoles(rolesToMap).and(other.mapRoles(rolesToMap));
    }

    default public RoleMapper or(RoleMapper other) {
        Assert.checkNotNullParam("other", other);
        return rolesToMap -> this.mapRoles(rolesToMap).or(other.mapRoles(rolesToMap));
    }

    default public RoleMapper xor(RoleMapper other) {
        Assert.checkNotNullParam("other", other);
        return rolesToMap -> this.mapRoles(rolesToMap).xor(other.mapRoles(rolesToMap));
    }

    default public RoleMapper minus(RoleMapper other) {
        Assert.checkNotNullParam("other", other);
        return rolesToMap -> this.mapRoles(rolesToMap).minus(other.mapRoles(rolesToMap));
    }

    public static RoleMapper aggregate(RoleMapper mapper1, RoleMapper mapper2) {
        Assert.checkNotNullParam("mapper1", mapper1);
        Assert.checkNotNullParam("mapper2", mapper2);
        return rolesToMap -> mapper2.mapRoles(mapper1.mapRoles(rolesToMap));
    }

    public static RoleMapper aggregate(RoleMapper ... mappers) {
        Assert.checkNotNullParam("mappers", mappers);
        RoleMapper[] clone = (RoleMapper[])mappers.clone();
        for (int i = 0; i < clone.length; ++i) {
            Assert.checkNotNullArrayParam("mappers", i, clone[i]);
        }
        return rolesToMap -> {
            for (RoleMapper r : clone) {
                rolesToMap = r.mapRoles(rolesToMap);
            }
            return rolesToMap;
        };
    }

    public static RoleMapper constant(Roles roles) {
        Assert.checkNotNullParam("roles", roles);
        return rolesToMap -> roles;
    }
}

