/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.appclient.service;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Set;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityContextAssociation;
import org.jboss.security.SubjectInfo;
import org.jboss.security.identity.Identity;
import org.jboss.security.identity.extensions.CredentialIdentity;

public class DefaultApplicationClientCallbackHandler
implements CallbackHandler {
    public static final String DOLLAR_LOCAL = "$local";
    private static PrivilegedAction<SecurityContext> SECURITY_CONTEXT = new PrivilegedAction<SecurityContext>(){

        @Override
        public SecurityContext run() {
            return SecurityContextAssociation.getSecurityContext();
        }
    };

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        SecurityContext context = AccessController.doPrivileged(SECURITY_CONTEXT);
        for (Callback current : callbacks) {
            RealmCallback realmCallback;
            Identity identity;
            Set identities;
            if (current instanceof NameCallback) {
                NameCallback ncb = (NameCallback)current;
                if (context != null) {
                    identities = this.getSubjectInfo(context).getIdentities();
                    if (identities.isEmpty()) {
                        ncb.setName(DOLLAR_LOCAL);
                        continue;
                    }
                    identity = (Identity)identities.iterator().next();
                    ncb.setName(identity.getName());
                    continue;
                }
                ncb.setName(DOLLAR_LOCAL);
                continue;
            }
            if (current instanceof PasswordCallback) {
                if (context == null) continue;
                PasswordCallback pcb = (PasswordCallback)current;
                identities = this.getSubjectInfo(context).getIdentities();
                if (identities.isEmpty()) {
                    throw new UnsupportedCallbackException(current);
                }
                identity = (Identity)identities.iterator().next();
                if (identity instanceof CredentialIdentity) {
                    pcb.setPassword((char[])((CredentialIdentity)identity).getCredential());
                    continue;
                }
                throw new UnsupportedCallbackException(current);
            }
            if (!(current instanceof RealmCallback) || (realmCallback = (RealmCallback)current).getText() != null) continue;
            realmCallback.setText(realmCallback.getDefaultText());
        }
    }

    private SubjectInfo getSubjectInfo(final SecurityContext context) {
        if (System.getSecurityManager() == null) {
            return context.getSubjectInfo();
        }
        return AccessController.doPrivileged(new PrivilegedAction<SubjectInfo>(){

            @Override
            public SubjectInfo run() {
                return context.getSubjectInfo();
            }
        });
    }
}

