/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.sso;

import io.undertow.server.session.SessionIdGenerator;
import java.io.Externalizable;
import java.io.Serializable;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jboss.as.clustering.controller.CapabilityServiceConfigurator;
import org.jboss.marshalling.ClassResolver;
import org.jboss.marshalling.ClassTable;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.ModularClassResolver;
import org.jboss.marshalling.ObjectTable;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.marshalling.jboss.DynamicClassTable;
import org.wildfly.clustering.marshalling.jboss.ExternalizerObjectTable;
import org.wildfly.clustering.marshalling.jboss.MarshallingConfigurationRepository;
import org.wildfly.clustering.marshalling.jboss.MarshallingContext;
import org.wildfly.clustering.marshalling.jboss.SimpleClassTable;
import org.wildfly.clustering.marshalling.jboss.SimpleMarshalledValueFactory;
import org.wildfly.clustering.marshalling.jboss.SimpleMarshallingConfigurationRepository;
import org.wildfly.clustering.marshalling.jboss.SimpleMarshallingContextFactory;
import org.wildfly.clustering.marshalling.spi.MarshalledValueFactory;
import org.wildfly.clustering.service.CompositeDependency;
import org.wildfly.clustering.service.Dependency;
import org.wildfly.clustering.service.FunctionalService;
import org.wildfly.clustering.service.SimpleServiceNameProvider;
import org.wildfly.clustering.service.SupplierDependency;
import org.wildfly.clustering.web.IdentifierFactory;
import org.wildfly.clustering.web.LocalContextFactory;
import org.wildfly.clustering.web.sso.SSOManager;
import org.wildfly.clustering.web.sso.SSOManagerConfiguration;
import org.wildfly.clustering.web.sso.SSOManagerFactory;
import org.wildfly.clustering.web.undertow.IdentifierFactoryAdapter;

public class SSOManagerServiceConfigurator<A, D, S, L>
extends SimpleServiceNameProvider
implements CapabilityServiceConfigurator,
Supplier<SSOManager<A, D, S, L, Batch>>,
Consumer<SSOManager<A, D, S, L, Batch>>,
SSOManagerConfiguration<MarshallingContext, L> {
    private final SupplierDependency<SSOManagerFactory<A, D, S, Batch>> factory;
    private final SupplierDependency<SessionIdGenerator> generator;
    private final LocalContextFactory<L> localContextFactory;
    private volatile MarshallingContext context;

    public SSOManagerServiceConfigurator(ServiceName name, SupplierDependency<SSOManagerFactory<A, D, S, Batch>> factory, SupplierDependency<SessionIdGenerator> generator, LocalContextFactory<L> localContextFactory) {
        super(name);
        this.factory = factory;
        this.generator = generator;
        this.localContextFactory = localContextFactory;
    }

    public ServiceBuilder<?> build(ServiceTarget target) {
        ServiceBuilder builder = target.addService(this.getServiceName());
        Consumer manager = new CompositeDependency(new Dependency[]{this.factory, this.generator}).register(builder).provides(new ServiceName[]{this.getServiceName()});
        FunctionalService service = new FunctionalService(manager, Function.identity(), (Supplier)this, (Consumer)this);
        return builder.setInstance((Service)service).setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    @Override
    public SSOManager<A, D, S, L, Batch> get() {
        SSOManagerFactory factory = (SSOManagerFactory)this.factory.get();
        Module module = Module.forClass(this.getClass());
        this.context = new SimpleMarshallingContextFactory().createMarshallingContext((MarshallingConfigurationRepository)new SimpleMarshallingConfigurationRepository(MarshallingVersion.class, (Enum)MarshallingVersion.CURRENT, (Object)module), null);
        SSOManager manager = factory.createSSOManager((SSOManagerConfiguration)this);
        manager.start();
        return manager;
    }

    @Override
    public void accept(SSOManager<A, D, S, L, Batch> manager) {
        manager.stop();
    }

    public IdentifierFactory<String> getIdentifierFactory() {
        return new IdentifierFactoryAdapter((SessionIdGenerator)this.generator.get());
    }

    public LocalContextFactory<L> getLocalContextFactory() {
        return this.localContextFactory;
    }

    public MarshalledValueFactory<MarshallingContext> getMarshalledValueFactory() {
        return new SimpleMarshalledValueFactory(this.context);
    }

    static enum MarshallingVersion implements Function<Module, MarshallingConfiguration>
    {
        VERSION_1{

            @Override
            public MarshallingConfiguration apply(Module module) {
                ModuleLoader loader = module.getModuleLoader();
                MarshallingConfiguration config = new MarshallingConfiguration();
                config.setClassResolver((ClassResolver)ModularClassResolver.getInstance((ModuleLoader)loader));
                config.setClassTable((ClassTable)new SimpleClassTable(new Class[]{Serializable.class, Externalizable.class}));
                return config;
            }
        }
        ,
        VERSION_2{

            @Override
            public MarshallingConfiguration apply(Module module) {
                ModuleLoader loader = module.getModuleLoader();
                MarshallingConfiguration config = new MarshallingConfiguration();
                config.setClassResolver((ClassResolver)ModularClassResolver.getInstance((ModuleLoader)loader));
                config.setClassTable((ClassTable)new DynamicClassTable(new ClassLoader[]{module.getClassLoader()}));
                config.setObjectTable((ObjectTable)new ExternalizerObjectTable(new ClassLoader[]{module.getClassLoader()}));
                return config;
            }
        };

        static final MarshallingVersion CURRENT;

        static {
            CURRENT = VERSION_2;
        }
    }
}

