/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.impl;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import org.apache.lucene.document.Document;
import org.apache.lucene.facet.FacetsConfig;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public final class FacetHandling {
    private static final Log log = LoggerFactory.make(MethodHandles.lookup());
    private FacetsConfig facetConfig = null;

    public Document build(Document doc) {
        if (this.facetConfig == null) {
            return doc;
        }
        try {
            return this.facetConfig.build(doc);
        }
        catch (IOException e) {
            throw log.errorDuringFacetingIndexing(e);
        }
    }

    public void setMultiValued(String facetName) {
        this.facetConfig.setMultiValued(facetName, true);
    }

    public void enableFacetProcessing() {
        if (this.facetConfig == null) {
            this.facetConfig = new FacetsConfig();
        }
    }
}

