/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.producer;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.picketlink.IdentityConfigurationEvent;
import org.picketlink.extension.PicketLinkExtension;
import org.picketlink.idm.config.IdentityConfiguration;
import org.picketlink.idm.config.IdentityConfigurationBuilder;
import org.picketlink.idm.config.IdentityStoreConfigurationBuilder;
import org.picketlink.idm.config.IdentityStoresConfigurationBuilder;
import org.picketlink.idm.config.JPAStoreConfigurationBuilder;
import org.picketlink.idm.config.NamedIdentityConfigurationBuilder;
import org.picketlink.idm.config.SecurityConfigurationException;
import org.picketlink.idm.config.TokenStoreConfigurationBuilder;
import org.picketlink.idm.credential.Token;
import org.picketlink.idm.spi.ContextInitializer;
import org.picketlink.internal.AuthenticatedAccountContextInitializer;
import org.picketlink.internal.CDIEventBridge;
import org.picketlink.internal.EntityManagerContextInitializer;
import org.picketlink.internal.EntityManagerProvider;
import org.picketlink.log.BaseLog;

public class IdentityManagementConfiguration {
    private static final String DEFAULT_CONFIGURATION_NAME = "default";
    @Inject
    private PicketLinkExtension picketLinkExtension;
    @Inject
    private Instance<IdentityConfiguration> identityConfigInstance;
    @Inject
    private EntityManagerProvider entityManagerProvider;
    @Inject
    private EntityManagerContextInitializer entityManagerContextInitializer;
    @Inject
    private AuthenticatedAccountContextInitializer authenticatedAccountContextInitializer;
    @Inject
    private Instance<Token.Consumer<?>> tokenConsumerInstance;
    @Inject
    private Instance<Token.Provider<?>> tokenProviderInstance;
    @Inject
    private CDIEventBridge eventBridge;
    private List<IdentityConfiguration> identityConfiguration;

    List<IdentityConfiguration> getIdentityConfiguration() {
        if (this.identityConfiguration == null) {
            IdentityConfigurationBuilder builder;
            if (BaseLog.ROOT_LOGGER.isDebugEnabled()) {
                BaseLog.ROOT_LOGGER.debugf("Building identity management configuration.", new Object[0]);
            }
            ArrayList configurations = new ArrayList();
            if (!this.identityConfigInstance.isUnsatisfied()) {
                Iterator iterator = this.identityConfigInstance.iterator();
                while (iterator.hasNext()) {
                    configurations.add(iterator.next());
                }
            }
            if (configurations.isEmpty()) {
                if (BaseLog.ROOT_LOGGER.isDebugEnabled()) {
                    BaseLog.ROOT_LOGGER.debugf("IdentityConfiguration not provided by the application, creating a default IdentityConfigurationBuilder.", new Object[0]);
                }
                builder = this.picketLinkExtension.getSecurityConfigurationBuilder().idmConfig();
            } else {
                if (BaseLog.ROOT_LOGGER.isDebugEnabled()) {
                    BaseLog.ROOT_LOGGER.debugf("Found IdentityConfiguration from the environment. Creating a IdentityConfigurationBuilder with them.", new Object[0]);
                }
                builder = new IdentityConfigurationBuilder(configurations);
            }
            this.eventBridge.fireEvent(new IdentityConfigurationEvent(builder));
            if (!builder.isConfigured()) {
                this.configureDefaults(builder);
            }
            this.configureIdentityStores(builder);
            this.identityConfiguration = builder.buildAll();
        }
        return this.identityConfiguration;
    }

    private void configureIdentityStores(IdentityConfigurationBuilder builder) {
        for (NamedIdentityConfigurationBuilder identityConfigurationBuilder : builder.getNamedIdentityConfigurationBuilders()) {
            IdentityStoresConfigurationBuilder stores = identityConfigurationBuilder.stores();
            for (IdentityStoreConfigurationBuilder storeBuilder : stores.getIdentityStoresConfigurationBuilder()) {
                storeBuilder.addContextInitializer((ContextInitializer)this.authenticatedAccountContextInitializer);
                if (JPAStoreConfigurationBuilder.class.isInstance(storeBuilder)) {
                    JPAStoreConfigurationBuilder jpaBuilder = (JPAStoreConfigurationBuilder)storeBuilder;
                    if (jpaBuilder.getMappedEntities().isEmpty()) {
                        Class[] mappedEntities = this.entityManagerProvider.getMappedEntities();
                        if (mappedEntities.length == 0) {
                            throw new SecurityConfigurationException("You provided a configuration for the JPA Identity Store, but no mapped entities were found.");
                        }
                        jpaBuilder.mappedEntity(mappedEntities);
                    }
                    jpaBuilder.addContextInitializer((ContextInitializer)this.entityManagerContextInitializer);
                }
                if (!TokenStoreConfigurationBuilder.class.isInstance(storeBuilder)) continue;
                TokenStoreConfigurationBuilder tokenBuilder = (TokenStoreConfigurationBuilder)storeBuilder;
                if (this.tokenConsumerInstance.isUnsatisfied()) continue;
                tokenBuilder.tokenConsumer(new Token.Consumer[]{(Token.Consumer)this.tokenConsumerInstance.get()});
            }
        }
    }

    private void configureDefaults(IdentityConfigurationBuilder builder) {
        if (BaseLog.ROOT_LOGGER.isDebugEnabled()) {
            BaseLog.ROOT_LOGGER.debugf("No configuration provided by the application. Configuring defaults.", new Object[0]);
        }
        if (this.entityManagerProvider.hasMappedEntities()) {
            builder.named(DEFAULT_CONFIGURATION_NAME).stores().jpa().supportAllFeatures();
            if (BaseLog.ROOT_LOGGER.isDebugEnabled()) {
                BaseLog.ROOT_LOGGER.debugf("Auto configuring JPA Identity Store.", new Object[0]);
            }
        } else {
            builder.named(DEFAULT_CONFIGURATION_NAME).stores().file().supportAllFeatures();
            if (BaseLog.ROOT_LOGGER.isDebugEnabled()) {
                BaseLog.ROOT_LOGGER.debugf("Auto configuring File Identity Store.", new Object[0]);
            }
        }
    }
}

