/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.protocol.remote;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.security.AccessController;
import java.util.concurrent.Executor;
import javax.ejb.CreateException;
import org.jboss.ejb._private.Logs;
import org.jboss.ejb.client.AbstractInvocationContext;
import org.jboss.ejb.client.Affinity;
import org.jboss.ejb.client.AttachmentKey;
import org.jboss.ejb.client.ClusterAffinity;
import org.jboss.ejb.client.EJBReceiver;
import org.jboss.ejb.client.EJBReceiverContext;
import org.jboss.ejb.client.EJBReceiverInvocationContext;
import org.jboss.ejb.client.EJBReceiverSessionCreationContext;
import org.jboss.ejb.client.RequestSendFailedException;
import org.jboss.ejb.client.SessionID;
import org.jboss.ejb.client.StatefulEJBLocator;
import org.jboss.ejb.client.StatelessEJBLocator;
import org.jboss.ejb.protocol.remote.EJBClientChannel;
import org.jboss.ejb.protocol.remote.RemoteTransportProvider;
import org.jboss.ejb.protocol.remote.RemotingEJBDiscoveryProvider;
import org.jboss.ejb.protocol.remote.RetryExecutorWrapper;
import org.jboss.remoting3.ClientServiceHandle;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.ConnectionPeerIdentity;
import org.jboss.remoting3.Endpoint;
import org.wildfly.common.Assert;
import org.wildfly.common.annotation.NotNull;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.xnio.IoFuture;
import org.xnio.OptionMap;

class RemoteEJBReceiver
extends EJBReceiver {
    private static final Logs log = Logs.MAIN;
    static final AttachmentKey<EJBClientChannel> EJBCC_KEY = new AttachmentKey();
    private final RemoteTransportProvider remoteTransportProvider;
    private final EJBReceiverContext receiverContext;
    private final RemotingEJBDiscoveryProvider discoveredNodeRegistry;
    final ClientServiceHandle<EJBClientChannel> serviceHandle;
    private final RetryExecutorWrapper retryExecutorWrapper = new RetryExecutorWrapper();
    final IoFuture.HandlingNotifier<ConnectionPeerIdentity, EJBReceiverInvocationContext> notifier = new IoFuture.HandlingNotifier<ConnectionPeerIdentity, EJBReceiverInvocationContext>(){

        public void handleDone(ConnectionPeerIdentity peerIdentity, EJBReceiverInvocationContext attachment) {
            RemoteEJBReceiver.this.serviceHandle.getClientService(peerIdentity.getConnection(), OptionMap.EMPTY).addNotifier((ioFuture, attachment1) -> {
                EJBClientChannel ejbClientChannel;
                try {
                    ejbClientChannel = (EJBClientChannel)ioFuture.getInterruptibly();
                }
                catch (IOException e) {
                    attachment1.requestFailed((Exception)((Object)new RequestSendFailedException(e + "@" + peerIdentity.getConnection().getPeerURI(), false)), RemoteEJBReceiver.this.retryExecutorWrapper.getExecutor((Executor)peerIdentity.getConnection().getEndpoint().getXnioWorker()));
                    return;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    attachment1.requestFailed((Exception)((Object)new RequestSendFailedException(e + "@" + peerIdentity.getConnection().getPeerURI(), false)), RemoteEJBReceiver.this.retryExecutorWrapper.getExecutor((Executor)peerIdentity.getConnection().getEndpoint().getXnioWorker()));
                    return;
                }
                attachment1.getClientInvocationContext().putAttachment(EJBCC_KEY, ejbClientChannel);
                ejbClientChannel.processInvocation((EJBReceiverInvocationContext)attachment1, peerIdentity);
            }, (Object)attachment);
        }

        public void handleCancelled(EJBReceiverInvocationContext attachment) {
            attachment.requestCancelled();
        }

        public void handleFailed(IOException exception, EJBReceiverInvocationContext attachment) {
            attachment.requestFailed((Exception)((Object)new RequestSendFailedException("Destination @ " + attachment.getClientInvocationContext().getDestination(), exception, false)), RemoteEJBReceiver.this.retryExecutorWrapper.getExecutor((Executor)Endpoint.getCurrent().getXnioWorker()));
        }
    };

    RemoteEJBReceiver(RemoteTransportProvider remoteTransportProvider, EJBReceiverContext receiverContext, RemotingEJBDiscoveryProvider discoveredNodeRegistry) {
        this.remoteTransportProvider = remoteTransportProvider;
        this.receiverContext = receiverContext;
        this.discoveredNodeRegistry = discoveredNodeRegistry;
        this.serviceHandle = new ClientServiceHandle("jboss.ejb", channel -> EJBClientChannel.construct(channel, this.discoveredNodeRegistry, this.retryExecutorWrapper));
    }

    RemoteTransportProvider getRemoteTransportProvider() {
        return this.remoteTransportProvider;
    }

    RemotingEJBDiscoveryProvider getDiscoveredNodeRegistry() {
        return this.discoveredNodeRegistry;
    }

    EJBReceiverContext getReceiverContext() {
        return this.receiverContext;
    }

    EJBClientChannel getClientChannel(Connection connection) throws IOException {
        try {
            log.tracef("RemoteEJBReceiver %s getting client service channel %s", this, this.serviceHandle);
            return (EJBClientChannel)this.serviceHandle.getClientService(connection, OptionMap.EMPTY).getInterruptibly();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new InterruptedIOException();
        }
    }

    @Override
    protected void processInvocation(EJBReceiverInvocationContext receiverContext) throws Exception {
        AuthenticationContext authenticationContext = receiverContext.getAuthenticationContext();
        IoFuture<ConnectionPeerIdentity> futureConnection = this.getConnection(receiverContext.getClientInvocationContext(), receiverContext.getClientInvocationContext().getDestination(), authenticationContext);
        futureConnection.addNotifier(this.notifier, (Object)receiverContext);
    }

    @Override
    protected boolean cancelInvocation(EJBReceiverInvocationContext receiverContext, boolean cancelIfRunning) {
        try {
            EJBClientChannel channel = receiverContext.getClientInvocationContext().getAttachment(EJBCC_KEY);
            return channel != null && channel.cancelInvocation(receiverContext, cancelIfRunning);
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    protected SessionID createSession(EJBReceiverSessionCreationContext context) throws Exception {
        StatelessEJBLocator<?> statelessLocator = context.getClientInvocationContext().getLocator().asStateless();
        AuthenticationContext authenticationContext = context.getAuthenticationContext();
        try {
            IoFuture<ConnectionPeerIdentity> futureConnection = this.getConnection(context.getClientInvocationContext(), context.getClientInvocationContext().getDestination(), authenticationContext);
            ConnectionPeerIdentity identity = (ConnectionPeerIdentity)futureConnection.getInterruptibly();
            EJBClientChannel ejbClientChannel = this.getClientChannel(identity.getConnection());
            StatefulEJBLocator<?> result = ejbClientChannel.openSession(statelessLocator, identity, context.getClientInvocationContext());
            return result.getSessionId();
        }
        catch (IOException e) {
            RequestSendFailedException failed = new RequestSendFailedException("Failed to create stateful EJB: " + e.getMessage(), true);
            failed.initCause(e);
            throw failed;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CreateException("Stateful EJB creation interrupted");
        }
    }

    @Override
    protected InetSocketAddress getSourceAddress(InetSocketAddress destination) {
        return Endpoint.getCurrent().getXnioWorker().getBindAddress(destination.getAddress());
    }

    @Override
    protected boolean isConnected(URI uri) {
        IoFuture future = Endpoint.getCurrent().getConnectedIdentityIfExists(uri, "ejb", "jboss", AuthenticationContext.captureCurrent());
        try {
            return future != null && future.getStatus() == IoFuture.Status.DONE && ((ConnectionPeerIdentity)future.get()).getConnection().isOpen();
        }
        catch (IOException e) {
            throw Assert.unreachableCode();
        }
    }

    private IoFuture<ConnectionPeerIdentity> getConnection(AbstractInvocationContext context, URI target, @NotNull AuthenticationContext authenticationContext) throws Exception {
        String cluster;
        Affinity affinity = context.getLocator().getAffinity();
        String string = cluster = affinity instanceof ClusterAffinity ? ((ClusterAffinity)affinity).getClusterName() : context.getInitialCluster();
        if (cluster != null) {
            if (System.getSecurityManager() == null) {
                return this.discoveredNodeRegistry.getConnectedIdentityUsingClusterEffective(Endpoint.getCurrent(), target, "ejb", "jboss", authenticationContext, cluster);
            }
            return AccessController.doPrivileged(() -> this.discoveredNodeRegistry.getConnectedIdentityUsingClusterEffective(Endpoint.getCurrent(), target, "ejb", "jboss", authenticationContext, cluster));
        }
        if (System.getSecurityManager() == null) {
            return Endpoint.getCurrent().getConnectedIdentity(target, "ejb", "jboss", authenticationContext);
        }
        return AccessController.doPrivileged(() -> Endpoint.getCurrent().getConnectedIdentity(target, "ejb", "jboss", authenticationContext));
    }

    public void close() throws Exception {
        this.serviceHandle.closeChannel();
    }
}

