/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import org.jboss.as.controller.AbstractAttributeDefinitionBuilder;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.logging.ConfigurationProperty;
import org.jboss.as.logging.resolvers.ModelNodeResolver;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.logmanager.config.PropertyConfigurable;

public class PropertyAttributeDefinition
extends SimpleAttributeDefinition
implements ConfigurationProperty<String> {
    private final ModelNodeResolver<String> resolver;
    private final String propertyName;

    private PropertyAttributeDefinition(Builder builder) {
        super((AbstractAttributeDefinitionBuilder)builder);
        this.propertyName = builder.propertyName;
        this.resolver = builder.resolver;
    }

    @Override
    public void setPropertyValue(OperationContext context, ModelNode model, PropertyConfigurable configuration) throws OperationFailedException {
        String value = this.resolvePropertyValue(context, model);
        if (value == null) {
            configuration.removeProperty(this.propertyName);
        } else {
            String currentValue = configuration.getPropertyValueString(this.propertyName);
            if (!value.equals(currentValue)) {
                configuration.setPropertyValueString(this.propertyName, value);
            }
        }
    }

    @Override
    public ModelNodeResolver<String> resolver() {
        return this.resolver;
    }

    @Override
    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public String resolvePropertyValue(OperationContext context, ModelNode model) throws OperationFailedException {
        String result = null;
        ModelNode value = this.resolveModelAttribute(context, model);
        if (value.isDefined()) {
            result = this.resolver == null ? value.asString() : this.resolver.resolveValue(context, value);
        }
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int hash = 17;
        hash = 31 * hash + (this.propertyName == null ? 0 : this.propertyName.hashCode());
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PropertyAttributeDefinition)) {
            return false;
        }
        PropertyAttributeDefinition other = (PropertyAttributeDefinition)obj;
        return this.propertyName == null ? other.propertyName == null : this.propertyName.equals(other.propertyName);
    }

    public String toString() {
        return String.format("%s{propertyName=%s,attributeName=%s}", this.getClass().getName(), this.propertyName, this.getName());
    }

    public static class Builder
    extends AbstractAttributeDefinitionBuilder<Builder, PropertyAttributeDefinition> {
        private ModelNodeResolver<String> resolver;
        private String propertyName;

        Builder(String name, ModelType type) {
            super(name, type);
        }

        public static Builder of(String name, ModelType type) {
            return new Builder(name, type);
        }

        public static Builder of(String name, ModelType type, boolean allowNull) {
            return (Builder)new Builder(name, type).setRequired(!allowNull);
        }

        public PropertyAttributeDefinition build() {
            if (this.propertyName == null) {
                this.propertyName = this.getName();
            }
            return new PropertyAttributeDefinition(this);
        }

        public Builder setPropertyName(String propertyName) {
            this.propertyName = propertyName;
            return this;
        }

        public Builder setResolver(ModelNodeResolver<String> resolver) {
            this.resolver = resolver;
            return this;
        }
    }
}

