/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.xacml.locators.attrib;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Properties;
import org.jboss.security.xacml.locators.attrib.SecurityActions;
import org.jboss.security.xacml.locators.attrib.StorageAttributeLocator;
import org.jboss.security.xacml.sunxacml.EvaluationCtx;
import org.jboss.security.xacml.sunxacml.attr.AttributeValue;
import org.jboss.security.xacml.sunxacml.attr.BagAttribute;
import org.jboss.security.xacml.sunxacml.cond.EvaluationResult;
import org.jboss.security.xacml.util.JBossXACMLUtil;

public class FileSystemAttributeLocator
extends StorageAttributeLocator {
    private Properties properties = new Properties();
    public static final String FILE_NAME = "fileName";

    protected void usePassedOption(String optionTag, String optionValue) {
        super.usePassedOption(optionTag, optionValue);
        if (optionTag.equalsIgnoreCase(FILE_NAME)) {
            ClassLoader tcl = SecurityActions.getContextClassLoader();
            InputStream is = tcl.getResourceAsStream(optionValue);
            if (is == null) {
                throw new RuntimeException("Unable to load fileName using the context classloader. Does the file exist?");
            }
            try {
                this.properties.loadFromXML(is);
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to load fileName", e);
            }
        }
    }

    public EvaluationResult findAttribute(URI attributeType, URI attributeId, URI issuer, URI subjectCategory, EvaluationCtx context, int designatorType) {
        HashSet<AttributeValue> bagSet = new HashSet<AttributeValue>();
        if (this.properties.size() <= 0) {
            if (attributeType != null) {
                return new EvaluationResult(BagAttribute.createEmptyBag(attributeType));
            }
            return new EvaluationResult(BagAttribute.createEmptyBag(attributeId));
        }
        this.attributeValue = this.properties.getProperty(attributeId.toASCIIString());
        bagSet.add(JBossXACMLUtil.getAttributeValue(this.attributeValue));
        return new EvaluationResult(new BagAttribute(attributeType, bagSet));
    }

    protected Object getSubstituteValue(URI attributeType, EvaluationCtx context) throws URISyntaxException {
        throw new RuntimeException("Not Applicable for this locator");
    }
}

