/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.controller.transform;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.jboss.as.clustering.controller.Operations;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.transform.OperationResultTransformer;
import org.jboss.as.controller.transform.OperationTransformer;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.dmr.ModelNode;

public class ChainedOperationTransformer
implements OperationTransformer {
    private final List<OperationTransformer> transformers;
    private final boolean collate;

    public ChainedOperationTransformer(List<OperationTransformer> transformers) {
        this.transformers = transformers;
        this.collate = true;
    }

    public ChainedOperationTransformer(List<OperationTransformer> transformers, boolean collate) {
        this.transformers = transformers;
        this.collate = collate;
    }

    public OperationTransformer.TransformedOperation transformOperation(TransformationContext context, PathAddress address, ModelNode originalOperation) throws OperationFailedException {
        int count;
        String originalName = Operations.getName(originalOperation);
        PathAddress originalAddress = Operations.getPathAddress(originalOperation);
        LinkedList<ModelNode> preSteps = new LinkedList<ModelNode>();
        LinkedList<ModelNode> postSteps = new LinkedList<ModelNode>();
        ModelNode operation = originalOperation;
        block0: for (OperationTransformer transformer : this.transformers) {
            PathAddress operationAddress;
            String operationName;
            ModelNode step;
            operation = transformer.transformOperation(context, address, operation).getTransformedOperation();
            if (!this.collate || !operation.get("operation").asString().equals("composite")) continue;
            List stepList = operation.get("steps").asList();
            ListIterator steps = stepList.listIterator();
            while (steps.hasNext()) {
                step = (ModelNode)steps.next();
                operationName = Operations.getName(step);
                operationAddress = Operations.getPathAddress(step);
                if (operationName.equals(originalName) && operationAddress.equals(originalAddress)) {
                    operation = step;
                    break;
                }
                preSteps.addLast(step);
            }
            steps = stepList.listIterator(stepList.size());
            while (steps.hasPrevious()) {
                step = (ModelNode)steps.previous();
                operationName = Operations.getName(step);
                operationAddress = Operations.getPathAddress(step);
                if (operationName.equals(originalName) && operationAddress.equals(originalAddress)) continue block0;
                postSteps.addFirst(step);
            }
        }
        if (this.collate && (count = preSteps.size() + postSteps.size() + 1) > 1) {
            ArrayList<ModelNode> steps = new ArrayList<ModelNode>(count);
            steps.addAll(preSteps);
            steps.add(operation);
            steps.addAll(postSteps);
            operation = Operations.createCompositeOperation(steps);
        }
        return new OperationTransformer.TransformedOperation(operation, OperationResultTransformer.ORIGINAL_RESULT);
    }
}

