/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.entries;

import java.util.concurrent.CompletionStage;
import org.infinispan.commons.util.Util;
import org.infinispan.container.entries.RepeatableReadEntry;
import org.infinispan.container.entries.versioned.Versioned;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.container.versioning.InequalVersionComparisonResult;
import org.infinispan.container.versioning.VersionGenerator;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.metadata.Metadata;
import org.infinispan.persistence.util.EntryLoader;
import org.infinispan.transaction.impl.AbstractCacheTransaction;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class VersionedRepeatableReadEntry
extends RepeatableReadEntry
implements Versioned {
    private static final Log log = LogFactory.getLog(VersionedRepeatableReadEntry.class);
    private static final boolean trace = log.isTraceEnabled();

    public VersionedRepeatableReadEntry(Object key, Object value, Metadata metadata) {
        super(key, value, metadata);
    }

    public CompletionStage<Boolean> performWriteSkewCheck(EntryLoader entryLoader, int segment, TxInvocationContext ctx, EntryVersion versionSeen, VersionGenerator versionGenerator) {
        CompletionStage<EntryVersion> entryStage;
        if (versionSeen == null) {
            if (trace) {
                log.tracef("Perform write skew check for key %s but the key was not read. Skipping check!", Util.toStr((Object)this.key));
            }
            return CompletableFutures.completedTrue();
        }
        if (ctx.isOriginLocal()) {
            entryStage = this.getCurrentEntryVersion(entryLoader, segment, ctx, versionGenerator);
        } else {
            EntryVersion prevVersion2 = (EntryVersion)((AbstractCacheTransaction)ctx.getCacheTransaction()).getVersionsRead().get(this.key);
            if (prevVersion2 == null) {
                entryStage = this.getCurrentEntryVersion(entryLoader, segment, ctx, versionGenerator);
            } else {
                return CompletableFutures.booleanStage(this.skewed(prevVersion2, versionSeen, versionGenerator));
            }
        }
        return entryStage.thenApply(prevVersion -> this.skewed((EntryVersion)prevVersion, versionSeen, versionGenerator));
    }

    private boolean skewed(EntryVersion prevVersion, EntryVersion versionSeen, VersionGenerator versionGenerator) {
        if (this.isExpired() && prevVersion == versionGenerator.nonExistingVersion()) {
            return true;
        }
        if (prevVersion.compareTo(this.metadata.version()) != InequalVersionComparisonResult.EQUAL) {
            if (trace) {
                log.tracef("Updating version in metadata %s -> %s", this.metadata.version(), prevVersion);
            }
            this.metadata = this.metadata.builder().version(prevVersion).build();
        }
        InequalVersionComparisonResult result = prevVersion.compareTo(versionSeen);
        if (trace) {
            log.tracef("Comparing versions %s and %s for key %s: %s", new Object[]{prevVersion, versionSeen, this.key, result});
        }
        return InequalVersionComparisonResult.EQUAL == result;
    }

    private CompletionStage<EntryVersion> getCurrentEntryVersion(EntryLoader entryLoader, int segment, TxInvocationContext ctx, VersionGenerator versionGenerator) {
        CompletionStage entry = entryLoader.loadAndStoreInDataContainer(ctx, this.getKey(), segment, null);
        return entry.thenApply(ice -> {
            EntryVersion prevVersion;
            if (ice == null) {
                if (trace) {
                    log.tracef("No entry for key %s found in data container", Util.toStr((Object)this.key));
                }
                prevVersion = versionGenerator.nonExistingVersion();
            } else {
                prevVersion = ice.getMetadata().version();
                if (prevVersion == null) {
                    throw new IllegalStateException("Entries cannot have null versions!");
                }
            }
            return prevVersion;
        });
    }

    @Override
    public EntryVersion getVersion() {
        return this.metadata.version();
    }

    @Override
    public void setVersion(EntryVersion version) {
        this.metadata = this.metadata.builder().version(version).build();
    }

    @Override
    public VersionedRepeatableReadEntry clone() {
        return (VersionedRepeatableReadEntry)super.clone();
    }
}

