/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.context.impl;

import javax.transaction.Transaction;
import org.infinispan.context.AbstractInvocationContextFactory;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.LocalTxInvocationContext;
import org.infinispan.context.impl.NonTxInvocationContext;
import org.infinispan.context.impl.RemoteTxInvocationContext;
import org.infinispan.context.impl.SingleKeyNonTxInvocationContext;
import org.infinispan.factories.annotations.SurvivesRestarts;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.remoting.transport.Address;
import org.infinispan.transaction.impl.LocalTransaction;
import org.infinispan.transaction.impl.RemoteTransaction;

@Scope(value=Scopes.NAMED_CACHE)
@SurvivesRestarts
public class NonTransactionalInvocationContextFactory
extends AbstractInvocationContextFactory {
    @Override
    public InvocationContext createInvocationContext(boolean isWrite, int keyCount) {
        if (keyCount == 1) {
            return new SingleKeyNonTxInvocationContext(null);
        }
        if (keyCount > 0) {
            return new NonTxInvocationContext(keyCount, null);
        }
        return this.createInvocationContext(null, false);
    }

    @Override
    public InvocationContext createInvocationContext(Transaction tx, boolean implicitTransaction) {
        return this.createNonTxInvocationContext();
    }

    @Override
    public NonTxInvocationContext createNonTxInvocationContext() {
        return new NonTxInvocationContext(null);
    }

    @Override
    public InvocationContext createSingleKeyNonTxInvocationContext() {
        return new SingleKeyNonTxInvocationContext(null);
    }

    @Override
    public NonTxInvocationContext createRemoteInvocationContext(Address origin) {
        return new NonTxInvocationContext(origin);
    }

    @Override
    public LocalTxInvocationContext createTxInvocationContext(LocalTransaction localTransaction) {
        throw this.exception();
    }

    @Override
    public RemoteTxInvocationContext createRemoteTxInvocationContext(RemoteTransaction tx, Address origin) {
        throw this.exception();
    }

    private IllegalStateException exception() {
        return new IllegalStateException("This is a non-transactional cache - why need to build a transactional context for it!");
    }
}

