/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.reactive;

import io.reactivex.Completable;
import io.reactivex.Flowable;
import io.reactivex.Maybe;
import io.reactivex.Single;
import io.reactivex.internal.functions.Functions;
import io.reactivex.processors.AsyncProcessor;
import io.reactivex.subjects.CompletableSubject;
import io.reactivex.subjects.MaybeSubject;
import io.reactivex.subjects.SingleSubject;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.stream.Stream;
import org.infinispan.commons.util.Util;
import org.reactivestreams.Publisher;

public class RxJavaInterop {
    private static final io.reactivex.functions.Function<Completable, CompletionStage<Void>> completableToCompletionStage = completable -> {
        CompletableFuture cf = new CompletableFuture();
        completable.subscribe(() -> cf.complete(null), cf::completeExceptionally);
        return cf;
    };
    private static final io.reactivex.functions.Function<Single<Object>, CompletionStage<Object>> singleToCompletionStage = single -> {
        CompletableFuture cf = new CompletableFuture();
        single.subscribe(cf::complete, cf::completeExceptionally);
        return cf;
    };
    private static final io.reactivex.functions.Function<Flowable<Object>, CompletionStage<Void>> flowableToCompletionStage = flowable -> {
        CompletableFuture cf = new CompletableFuture();
        flowable.subscribe(Functions.emptyConsumer(), cf::completeExceptionally, () -> cf.complete(null));
        return cf;
    };
    private static final io.reactivex.functions.Function<Maybe<Object>, CompletionStage<Object>> maybeToCompletionStage = maybe -> {
        CompletableFuture cf = new CompletableFuture();
        maybe.subscribe(cf::complete, cf::completeExceptionally, () -> cf.complete(null));
        return cf;
    };
    private static final Function<CompletionStage<Object>, Flowable<Object>> completionStageToPublisher = stage -> {
        AsyncProcessor asyncProcessor = AsyncProcessor.create();
        stage.whenComplete((value, t) -> {
            if (t != null) {
                asyncProcessor.onError(t);
            } else {
                if (value != null) {
                    asyncProcessor.onNext(value);
                }
                asyncProcessor.onComplete();
            }
        });
        return asyncProcessor;
    };
    private static final io.reactivex.functions.Function<Map.Entry<Object, Object>, Object> entryToKeyFunction = Map.Entry::getKey;
    private static final Function<CompletionStage<?>, Completable> completionStageCompletableFunction = completionStage -> {
        CompletableSubject cs = CompletableSubject.create();
        completionStage.whenComplete((o, throwable) -> {
            if (throwable != null) {
                cs.onError(throwable);
            } else {
                cs.onComplete();
            }
        });
        return cs;
    };
    private static final io.reactivex.functions.Function<? super Throwable, Publisher<?>> wrapThrowable = t -> Flowable.error((Throwable)Util.rewrapAsCacheException((Throwable)t));

    private RxJavaInterop() {
    }

    public static io.reactivex.functions.Function<Completable, CompletionStage<Void>> completableToCompletionStage() {
        return completableToCompletionStage;
    }

    public static <E> io.reactivex.functions.Function<Single<? extends E>, CompletionStage<E>> singleToCompletionStage() {
        return singleToCompletionStage;
    }

    public static <E> io.reactivex.functions.Function<Maybe<E>, CompletionStage<E>> maybeToCompletionStage() {
        return maybeToCompletionStage;
    }

    public static <E> io.reactivex.functions.Function<Flowable<E>, CompletionStage<Void>> flowableToCompletionStage() {
        return flowableToCompletionStage;
    }

    public static Completable completionStageToCompletable(CompletionStage<Void> stage) {
        CompletableSubject cs = CompletableSubject.create();
        stage.whenComplete((o, throwable) -> {
            if (throwable != null) {
                cs.onError(throwable);
            } else {
                cs.onComplete();
            }
        });
        return cs;
    }

    public static Function<CompletionStage<?>, Completable> completionStageToCompletable() {
        return completionStageCompletableFunction;
    }

    public static <E> Single<E> completionStageToSingle(CompletionStage<E> stage) {
        SingleSubject ss = SingleSubject.create();
        stage.whenComplete((value, t) -> {
            if (t != null) {
                ss.onError(t);
            }
            if (value != null) {
                ss.onSuccess(value);
            } else {
                ss.onError((Throwable)new NoSuchElementException());
            }
        });
        return ss;
    }

    public static <E> Maybe<E> completionStageToMaybe(CompletionStage<E> stage) {
        MaybeSubject ms = MaybeSubject.create();
        stage.whenComplete((value, t) -> {
            if (t != null) {
                ms.onError(t);
            }
            if (value != null) {
                ms.onSuccess(value);
            } else {
                ms.onComplete();
            }
        });
        return ms;
    }

    public static <E> Flowable<E> fromStream(Stream<E> stream) {
        return Flowable.fromIterable(stream::iterator).doOnTerminate(stream::close);
    }

    public static <K, V> io.reactivex.functions.Function<Map.Entry<K, V>, K> entryToKeyFunction() {
        return entryToKeyFunction;
    }

    public static <R> io.reactivex.functions.Function<? super Throwable, Publisher<R>> cacheExceptionWrapper() {
        return wrapThrowable;
    }
}

