/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stream.impl.intops.object;

import io.reactivex.Flowable;
import java.util.function.Function;
import java.util.stream.Stream;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.reactive.RxJavaInterop;
import org.infinispan.stream.impl.intops.FlatMappingOperation;

public class FlatMapOperation<I, O>
implements FlatMappingOperation<I, Stream<I>, O, Stream<O>> {
    private final Function<? super I, ? extends Stream<? extends O>> function;

    public FlatMapOperation(Function<? super I, ? extends Stream<? extends O>> function) {
        this.function = function;
    }

    @Override
    public Stream<O> perform(Stream<I> stream) {
        return stream.flatMap(this.function);
    }

    public Function<? super I, ? extends Stream<? extends O>> getFunction() {
        return this.function;
    }

    @Override
    public void handleInjection(ComponentRegistry registry) {
        registry.wireDependencies(this.function);
    }

    @Override
    public Stream<Stream<O>> map(Stream<I> iStream) {
        return iStream.map(this.function);
    }

    @Override
    public Flowable<O> mapFlowable(Flowable<I> input) {
        return input.concatMap(o -> RxJavaInterop.fromStream(this.function.apply(o)));
    }
}

