/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.batch.jberet.deployment;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import org.jberet.repository.InMemoryRepository;
import org.jberet.repository.JobRepository;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.jbossallxml.JBossAllXMLParser;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.wildfly.extension.batch.jberet.Attribute;
import org.wildfly.extension.batch.jberet.Element;
import org.wildfly.extension.batch.jberet._private.BatchLogger;
import org.wildfly.extension.batch.jberet.deployment.BatchEnvironmentMetaData;

public class BatchDeploymentDescriptorParser_1_0
implements XMLStreamConstants,
JBossAllXMLParser<BatchEnvironmentMetaData> {
    public static final String NAMESPACE = "urn:jboss:batch-jberet:1.0";
    public static final QName ROOT_ELEMENT = new QName("urn:jboss:batch-jberet:1.0", "batch");

    public BatchEnvironmentMetaData parse(XMLExtendedStreamReader reader, DeploymentUnit deploymentUnit) throws XMLStreamException {
        InMemoryRepository jobRepository = null;
        String jobRepositoryName = null;
        String jobExecutorName = null;
        Boolean restartJobsOnResume = null;
        boolean empty = true;
        while (reader.hasNext() && reader.nextTag() != 2) {
            String localName = reader.getLocalName();
            Element element = Element.forName(localName);
            if (element == Element.JOB_REPOSITORY) {
                if (jobRepository != null || jobRepositoryName != null) {
                    BatchLogger.LOGGER.multipleJobRepositoriesFound();
                } else {
                    if (reader.hasNext() && reader.nextTag() != 2) {
                        String name = reader.getLocalName();
                        Element jobRepositoryElement = Element.forName(name);
                        if (jobRepositoryElement == Element.IN_MEMORY) {
                            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                            jobRepository = new InMemoryRepository();
                        } else if (jobRepositoryElement == Element.NAMED) {
                            jobRepositoryName = BatchDeploymentDescriptorParser_1_0.readRequiredAttribute(reader, Attribute.NAME);
                            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                        } else {
                            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                        }
                    }
                    if (jobRepository == null && jobRepositoryName == null) {
                        BatchLogger.LOGGER.emptyJobRepositoryElement(deploymentUnit.getName());
                    }
                }
                ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
            } else if (element == Element.THREAD_POOL) {
                jobExecutorName = BatchDeploymentDescriptorParser_1_0.readRequiredAttribute(reader, Attribute.NAME);
                ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
            } else if (element == Element.RESTART_JOBS_ON_RESUME) {
                restartJobsOnResume = Boolean.valueOf(BatchDeploymentDescriptorParser_1_0.readRequiredAttribute(reader, Attribute.VALUE));
                ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
            } else {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            empty = false;
        }
        if (empty) {
            BatchLogger.LOGGER.debugf("An empty batch element in the deployment descriptor was found for %s.", deploymentUnit.getName());
            return null;
        }
        return new BatchEnvironmentMetaData((JobRepository)jobRepository, jobRepositoryName, jobExecutorName, restartJobsOnResume);
    }

    private static String readRequiredAttribute(XMLExtendedStreamReader reader, Attribute attribute) throws XMLStreamException {
        int attributeCount = reader.getAttributeCount();
        for (int i = 0; i < attributeCount; ++i) {
            Attribute current = Attribute.forName(reader.getAttributeLocalName(i));
            if (current != attribute) continue;
            return reader.getAttributeValue(i);
        }
        throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, (String[])new String[]{attribute.getLocalName()});
    }
}

