/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.el;

import java.beans.FeatureDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.el.ELContext;
import javax.el.ELResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeELResolver
extends javax.el.CompositeELResolver {
    private Collection<ELResolver> _elResolvers;

    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        Collection<ELResolver> resolvers = this._elResolvers;
        if (resolvers == null) {
            resolvers = Collections.emptyList();
        }
        return new CompositeIterator(context, base, resolvers.iterator());
    }

    public final synchronized void add(ELResolver elResolver) {
        super.add(elResolver);
        if (this._elResolvers == null) {
            this._elResolvers = new ArrayList<ELResolver>();
        }
        this._elResolvers.add(elResolver);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CompositeIterator
    implements Iterator<FeatureDescriptor> {
        private final ELContext _context;
        private final Object _base;
        private final Iterator<ELResolver> _elResolvers;
        private FeatureDescriptor _nextFD;
        private Iterator<FeatureDescriptor> _currentFDIter;

        public CompositeIterator(ELContext context, Object base, Iterator<ELResolver> elResolvers) {
            this._context = context;
            this._base = base;
            this._elResolvers = elResolvers;
        }

        @Override
        public boolean hasNext() {
            if (this._nextFD != null) {
                return true;
            }
            if (this._currentFDIter != null) {
                while (this._nextFD == null && this._currentFDIter.hasNext()) {
                    this._nextFD = this._currentFDIter.next();
                }
            }
            if (this._nextFD == null) {
                if (this._elResolvers.hasNext()) {
                    this._currentFDIter = this._elResolvers.next().getFeatureDescriptors(this._context, this._base);
                } else {
                    return false;
                }
            }
            return this.hasNext();
        }

        @Override
        public FeatureDescriptor next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            FeatureDescriptor next = this._nextFD;
            this._nextFD = null;
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

