/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream.util;

import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.wildfly.clustering.marshalling.Externalizer;
import org.wildfly.clustering.marshalling.protostream.ExternalizerMarshaller;
import org.wildfly.clustering.marshalling.protostream.MarshallerProvider;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.util.CollectionMarshaller;
import org.wildfly.clustering.marshalling.protostream.util.EnumMapMarshaller;
import org.wildfly.clustering.marshalling.protostream.util.EnumSetMarshaller;
import org.wildfly.clustering.marshalling.protostream.util.HashMapMarshaller;
import org.wildfly.clustering.marshalling.protostream.util.LinkedHashMapMarshaller;
import org.wildfly.clustering.marshalling.protostream.util.MapEntryMarshaller;
import org.wildfly.clustering.marshalling.protostream.util.OptionalMarshaller;
import org.wildfly.clustering.marshalling.protostream.util.SingletonCollectionMarshaller;
import org.wildfly.clustering.marshalling.protostream.util.SingletonMapMarshaller;
import org.wildfly.clustering.marshalling.protostream.util.SortedMapMarshaller;
import org.wildfly.clustering.marshalling.protostream.util.SortedSetMarshaller;
import org.wildfly.clustering.marshalling.protostream.util.UUIDMarshaller;
import org.wildfly.clustering.marshalling.spi.util.UtilExternalizerProvider;

public enum UtilMarshaller implements MarshallerProvider
{
    ARRAY_DEQUE(new CollectionMarshaller<ArrayDeque>(ArrayDeque.class, ArrayDeque::new)),
    ARRAY_LIST(new CollectionMarshaller<ArrayList>(ArrayList.class, ArrayList::new)),
    BIT_SET((Externalizer<?>)UtilExternalizerProvider.BIT_SET),
    CALENDAR((Externalizer<?>)UtilExternalizerProvider.CALENDAR),
    CURRENCY((Externalizer<?>)UtilExternalizerProvider.CURRENCY),
    DATE((Externalizer<?>)UtilExternalizerProvider.DATE),
    EMPTY_ENUMERATION((Externalizer<?>)UtilExternalizerProvider.EMPTY_ENUMERATION),
    EMPTY_ITERATOR((Externalizer<?>)UtilExternalizerProvider.EMPTY_ITERATOR),
    EMPTY_LIST((Externalizer<?>)UtilExternalizerProvider.EMPTY_LIST),
    EMPTY_LIST_ITERATOR((Externalizer<?>)UtilExternalizerProvider.EMPTY_LIST_ITERATOR),
    EMPTY_MAP((Externalizer<?>)UtilExternalizerProvider.EMPTY_MAP),
    EMPTY_NAVIGABLE_MAP((Externalizer<?>)UtilExternalizerProvider.EMPTY_NAVIGABLE_MAP),
    EMPTY_NAVIGABLE_SET((Externalizer<?>)UtilExternalizerProvider.EMPTY_NAVIGABLE_SET),
    EMPTY_SET((Externalizer<?>)UtilExternalizerProvider.EMPTY_SET),
    EMPTY_SORTED_MAP((Externalizer<?>)UtilExternalizerProvider.EMPTY_SORTED_MAP),
    EMPTY_SORTED_SET((Externalizer<?>)UtilExternalizerProvider.EMPTY_SORTED_SET),
    ENUM_MAP(new EnumMapMarshaller<E>()),
    ENUM_SET(new EnumSetMarshaller<E>()),
    HASH_MAP(new HashMapMarshaller<HashMap>(HashMap.class, HashMap::new)),
    HASH_SET(new CollectionMarshaller<HashSet>(HashSet.class, HashSet::new)),
    LINKED_HASH_MAP(new LinkedHashMapMarshaller()),
    LINKED_HASH_SET(new CollectionMarshaller<LinkedHashSet>(LinkedHashSet.class, LinkedHashSet::new)),
    LINKED_LIST(new CollectionMarshaller<LinkedList>(LinkedList.class, size -> new LinkedList())),
    LOCALE((Externalizer<?>)UtilExternalizerProvider.LOCALE),
    OPTIONAL(OptionalMarshaller.OBJECT),
    OPTIONAL_DOUBLE(OptionalMarshaller.DOUBLE),
    OPTIONAL_INT(OptionalMarshaller.INT),
    OPTIONAL_LONG(OptionalMarshaller.LONG),
    SIMPLE_ENTRY(new MapEntryMarshaller<AbstractMap.SimpleEntry>(AbstractMap.SimpleEntry.class, AbstractMap.SimpleEntry::new)),
    SIMPLE_IMMUTABLE_ENTRY(new MapEntryMarshaller<AbstractMap.SimpleImmutableEntry>(AbstractMap.SimpleImmutableEntry.class, AbstractMap.SimpleImmutableEntry::new)),
    SINGLETON_LIST(new SingletonCollectionMarshaller<List>(Collections::singletonList)),
    SINGLETON_MAP(new SingletonMapMarshaller<Map>(Collections::singletonMap)),
    SINGLETON_SET(new SingletonCollectionMarshaller<Set>(Collections::singleton)),
    TIME_ZONE((Externalizer<?>)UtilExternalizerProvider.TIME_ZONE),
    TREE_MAP(new SortedMapMarshaller<TreeMap>(TreeMap.class, TreeMap::new)),
    TREE_SET(new SortedSetMarshaller<TreeSet>(TreeSet.class, TreeSet::new)),
    UUID(UUIDMarshaller.INSTANCE);

    private final ProtoStreamMarshaller<Object> marshaller;

    private UtilMarshaller(ProtoStreamMarshaller<?> marshaller) {
        this.marshaller = marshaller;
    }

    private UtilMarshaller(Externalizer<?> externalizer) {
        this(new ExternalizerMarshaller(externalizer));
    }

    @Override
    public ProtoStreamMarshaller<?> getMarshaller() {
        return this.marshaller;
    }
}

