/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.readline.cursor;

import java.util.ArrayList;
import java.util.List;
import org.aesh.readline.Buffer;
import org.aesh.readline.cursor.CursorLocation;

public class CursorLocator {
    private final List<Integer> linesSize = new ArrayList<Integer>();
    private boolean invalidatedLines;
    private final Buffer buffer;

    public CursorLocator(Buffer buffer) {
        this.buffer = buffer;
    }

    public void addLine(int size, int promptSize) {
        this.linesSize.add(size);
        this.linesSize.add(promptSize);
    }

    public boolean isLocationInvalidated() {
        return this.invalidatedLines;
    }

    public void invalidateCursorLocation() {
        this.invalidatedLines = true;
    }

    public CursorLocation locate(int index, int width) {
        if (this.isLocationInvalidated()) {
            return null;
        }
        int cumulated = 0;
        ArrayList<Integer> allLines = new ArrayList<Integer>();
        allLines.addAll(this.linesSize);
        allLines.add(this.buffer.length());
        allLines.add(this.buffer.prompt().getLength());
        int lineIndex = 0;
        for (int i = 0; i < allLines.size(); ++i) {
            int cmdSize = (Integer)allLines.get(i++);
            int promptSize = (Integer)allLines.get(i);
            ++lineIndex;
            if (cumulated + cmdSize > index) {
                int part = index - cumulated;
                int col = (part + promptSize) % width;
                return new CursorLocation((lineIndex += (promptSize + part) / width) - 1, col);
            }
            cumulated += cmdSize;
            lineIndex += (cmdSize + promptSize) / width;
        }
        if (cumulated == index) {
            int cmdSize = (Integer)allLines.get(allLines.size() - 2);
            int promptSize = (Integer)allLines.get(allLines.size() - 1);
            int col = (cmdSize + promptSize) % width;
            return new CursorLocation(lineIndex - 1, col);
        }
        return null;
    }

    public void clear() {
        this.linesSize.clear();
    }
}

