/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jmx.model;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.JMRuntimeException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryEval;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.descriptions.NonResolvingResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.core.security.AccessMechanism;
import org.jboss.as.jmx.logging.JmxLogger;
import org.jboss.as.jmx.model.ChildAddOperationFinder;
import org.jboss.as.jmx.model.ConfiguredDomains;
import org.jboss.as.jmx.model.MBeanInfoFactory;
import org.jboss.as.jmx.model.ManagementModelIntegration;
import org.jboss.as.jmx.model.MutabilityChecker;
import org.jboss.as.jmx.model.NameConverter;
import org.jboss.as.jmx.model.ObjectNameAddressUtil;
import org.jboss.as.jmx.model.ResourceAccessControlUtil;
import org.jboss.as.jmx.model.RootResourceIterator;
import org.jboss.as.jmx.model.TypeConverters;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.common.Assert;

public class ModelControllerMBeanHelper {
    private static final Set<ModelType> COMPLEX_TYPES = Collections.unmodifiableSet(EnumSet.of(ModelType.LIST, ModelType.OBJECT, ModelType.PROPERTY));
    static final String CLASS_NAME = ModelController.class.getName();
    private static final String AUTHORIZED_ERROR = "WFLYCTL0313";
    private final MutabilityChecker mutabilityChecker;
    private final ModelController controller;
    private final ResourceAccessControlUtil accessControlUtil;
    private final PathAddress CORE_SERVICE_PLATFORM_MBEAN = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"core-service", (String)"platform-mbean")});
    private final TypeConverters converters;
    private final ConfiguredDomains configuredDomains;
    private final String domain;
    private final ObjectInstance rootObjectInstance;
    private final ManagementModelIntegration.ManagementModelProvider managementModelProvider;

    ModelControllerMBeanHelper(TypeConverters converters, ConfiguredDomains configuredDomains, String domain, ModelController controller, MutabilityChecker mutabilityChecker, ManagementModelIntegration.ManagementModelProvider managementModelProvider) {
        this.converters = converters;
        this.configuredDomains = configuredDomains;
        this.domain = domain;
        this.controller = controller;
        this.accessControlUtil = new ResourceAccessControlUtil(controller);
        this.mutabilityChecker = mutabilityChecker;
        this.managementModelProvider = managementModelProvider;
        this.rootObjectInstance = ModelControllerMBeanHelper.createRootObjectInstance(domain);
    }

    int getMBeanCount() {
        return new RootResourceIterator<Integer>(null, this.getRootResourceAndRegistration().getResource(), new RootResourceIterator.ResourceAction<Integer>(){
            int count;
            final ImmutableManagementResourceRegistration rootRegistration;
            {
                this.rootRegistration = ModelControllerMBeanHelper.this.getRootResourceAndRegistration().getRegistration();
            }

            @Override
            public ObjectName onAddress(PathAddress address) {
                return ModelControllerMBeanHelper.this.isExcludeAddress(address) || this.rootRegistration.getSubModel(address) == null ? null : ModelControllerMBeanHelper.this.rootObjectInstance.getObjectName();
            }

            @Override
            public boolean onResource(ObjectName address) {
                ++this.count;
                return true;
            }

            @Override
            public Integer getResult() {
                return this.count;
            }
        }).iterate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<ObjectInstance> queryMBeans(MBeanServer mbeanServer, final ObjectName name, QueryExp query) {
        Set<ObjectInstance> result;
        Set<ObjectInstance> basic = new RootResourceIterator<Set<ObjectInstance>>(this.accessControlUtil, this.getRootResourceAndRegistration().getResource(), new ObjectNameMatchResourceAction<Set<ObjectInstance>>(name){
            Set<ObjectInstance> set;
            {
                super(baseName);
                this.set = new HashSet<ObjectInstance>();
            }

            @Override
            public boolean onResource(ObjectName resourceName) {
                if (name == null || name.apply(resourceName)) {
                    this.set.add(new ObjectInstance(resourceName, CLASS_NAME));
                }
                return true;
            }

            @Override
            public Set<ObjectInstance> getResult() {
                return this.set;
            }
        }).iterate();
        if (query == null || basic.isEmpty()) {
            result = basic;
        } else {
            result = new HashSet<ObjectInstance>(basic.size());
            for (ObjectInstance oi : basic) {
                MBeanServer oldServer = ModelControllerMBeanHelper.setQueryExpServer(query, mbeanServer);
                try {
                    if (!query.apply(oi.getObjectName())) continue;
                    result.add(oi);
                }
                catch (Exception exception) {}
                continue;
                finally {
                    ModelControllerMBeanHelper.setQueryExpServer(query, oldServer);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<ObjectName> queryNames(MBeanServer mbeanServer, final ObjectName name, QueryExp query) {
        Set<ObjectName> result;
        Set<ObjectName> basic = new RootResourceIterator<Set<ObjectName>>(this.accessControlUtil, this.getRootResourceAndRegistration().getResource(), new ObjectNameMatchResourceAction<Set<ObjectName>>(name){
            Set<ObjectName> set;
            {
                super(baseName);
                this.set = new HashSet<ObjectName>();
            }

            @Override
            public boolean onResource(ObjectName resourceName) {
                if (name == null || name.apply(resourceName)) {
                    this.set.add(resourceName);
                }
                return true;
            }

            @Override
            public Set<ObjectName> getResult() {
                return this.set;
            }
        }).iterate();
        if (query == null || basic.isEmpty()) {
            result = basic;
        } else {
            result = new HashSet<ObjectName>(basic.size());
            for (ObjectName on : basic) {
                MBeanServer oldServer = ModelControllerMBeanHelper.setQueryExpServer(query, mbeanServer);
                try {
                    if (!query.apply(on)) continue;
                    result.add(on);
                }
                catch (Exception exception) {}
                continue;
                finally {
                    ModelControllerMBeanHelper.setQueryExpServer(query, oldServer);
                }
            }
        }
        return result;
    }

    private static MBeanServer setQueryExpServer(QueryExp query, MBeanServer toSet) {
        MBeanServer result = QueryEval.getMBeanServer();
        query.setMBeanServer(toSet);
        return result;
    }

    PathAddress resolvePathAddress(ObjectName name) {
        return ObjectNameAddressUtil.resolvePathAddress(this.rootObjectInstance.getObjectName(), this.getRootResourceAndRegistration().getResource(), name);
    }

    private PathAddress resolvePathAddress(ObjectName name, ManagementModelIntegration.ResourceAndRegistration reg) {
        return ObjectNameAddressUtil.resolvePathAddress(this.rootObjectInstance.getObjectName(), reg.getResource(), name);
    }

    PathAddress toPathAddress(ObjectName name) {
        return ObjectNameAddressUtil.toPathAddress(this.rootObjectInstance.getObjectName(), this.getRootResourceAndRegistration().getRegistration(), name);
    }

    MBeanInfo getMBeanInfo(ObjectName name) throws InstanceNotFoundException {
        ManagementModelIntegration.ResourceAndRegistration reg = this.getRootResourceAndRegistration();
        PathAddress address = this.resolvePathAddress(name, reg);
        if (address == null) {
            throw JmxLogger.ROOT_LOGGER.mbeanNotFound(name);
        }
        this.accessControlUtil.getResourceAccessWithInstanceNotFoundExceptionIfNotAccessible(name, address, true);
        return MBeanInfoFactory.createMBeanInfo(name, this.converters, this.configuredDomains, this.mutabilityChecker, address, this.getMBeanRegistration(address, reg));
    }

    Object getAttribute(ObjectName name, String attribute) throws AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
        ManagementModelIntegration.ResourceAndRegistration reg = this.getRootResourceAndRegistration();
        PathAddress address = this.resolvePathAddress(name, reg);
        if (address == null) {
            throw JmxLogger.ROOT_LOGGER.mbeanNotFound(name);
        }
        ResourceAccessControlUtil.ResourceAccessControl accessControl = this.accessControlUtil.getResourceAccessWithInstanceNotFoundExceptionIfNotAccessible(name, address, false);
        return this.getAttribute(reg, address, attribute, accessControl);
    }

    AttributeList getAttributes(ObjectName name, String[] attributes) throws InstanceNotFoundException, ReflectionException {
        ManagementModelIntegration.ResourceAndRegistration reg = this.getRootResourceAndRegistration();
        PathAddress address = this.resolvePathAddress(name, reg);
        if (address == null) {
            throw JmxLogger.ROOT_LOGGER.mbeanNotFound(name);
        }
        ResourceAccessControlUtil.ResourceAccessControl accessControl = this.accessControlUtil.getResourceAccessWithInstanceNotFoundExceptionIfNotAccessible(name, address, false);
        AttributeList list = new AttributeList();
        for (String attribute : attributes) {
            try {
                list.add(new Attribute(attribute, this.getAttribute(reg, address, attribute, accessControl)));
            }
            catch (AttributeNotFoundException e) {
                throw new ReflectionException(e);
            }
        }
        return list;
    }

    private Object getAttribute(ManagementModelIntegration.ResourceAndRegistration reg, PathAddress address, String attribute, ResourceAccessControlUtil.ResourceAccessControl accessControl) throws ReflectionException, AttributeNotFoundException, InstanceNotFoundException {
        ImmutableManagementResourceRegistration registration = this.getMBeanRegistration(address, reg);
        Map attributes = registration.getAttributes(PathAddress.EMPTY_ADDRESS);
        String attributeName = this.findAttributeName(attributes.keySet(), attribute);
        if (!accessControl.isReadableAttribute(attributeName)) {
            throw JmxLogger.ROOT_LOGGER.notAuthorizedToReadAttribute(attributeName);
        }
        ModelNode op = new ModelNode();
        op.get("operation").set("read-attribute");
        op.get("address").set(address.toModelNode());
        op.get("name").set(attributeName);
        ModelNode result = this.execute(op);
        String error = this.getFailureDescription(result);
        if (error != null) {
            throw new AttributeNotFoundException(error);
        }
        ModelNode attrDesc = this.getAttributeDescription(attributeName, registration, attributes);
        return this.converters.fromModelNode(((AttributeAccess)attributes.get(attributeName)).getAttributeDefinition(), attrDesc, result.get("result"));
    }

    private ModelNode getAttributeDescription(String attributeName, ImmutableManagementResourceRegistration registration, Map<String, AttributeAccess> attributes) {
        ModelNode desc;
        AttributeAccess aa = attributes.get(attributeName);
        AttributeDefinition ad = aa.getAttributeDefinition();
        if (ad != null) {
            if (!COMPLEX_TYPES.contains(ad.getType())) {
                desc = ad.getNoTextDescription(false);
            } else {
                ModelNode wrapped = new ModelNode();
                ad.addResourceAttributeDescription(wrapped, (ResourceDescriptionResolver)NonResolvingResourceDescriptionResolver.INSTANCE, null, NonResolvingResourceDescriptionResolver.INSTANCE.getResourceBundle(null));
                desc = wrapped.get(new String[]{"attributes", attributeName});
            }
        } else {
            desc = registration.getModelDescription(PathAddress.EMPTY_ADDRESS).getModelDescription(null).get(new String[]{"attributes", attributeName});
        }
        return desc;
    }

    void setAttribute(ObjectName name, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException {
        ManagementModelIntegration.ResourceAndRegistration reg = this.getRootResourceAndRegistration();
        PathAddress address = this.resolvePathAddress(name, reg);
        if (address == null) {
            throw JmxLogger.ROOT_LOGGER.mbeanNotFound(name);
        }
        ResourceAccessControlUtil.ResourceAccessControl accessControl = this.accessControlUtil.getResourceAccessWithInstanceNotFoundExceptionIfNotAccessible(name, address, false);
        this.setAttribute(reg, address, attribute, accessControl);
    }

    AttributeList setAttributes(ObjectName name, AttributeList attributes) throws InstanceNotFoundException, ReflectionException {
        ManagementModelIntegration.ResourceAndRegistration reg = this.getRootResourceAndRegistration();
        PathAddress address = this.resolvePathAddress(name, reg);
        if (address == null) {
            throw JmxLogger.ROOT_LOGGER.mbeanNotFound(name);
        }
        ResourceAccessControlUtil.ResourceAccessControl accessControl = this.accessControlUtil.getResourceAccessWithInstanceNotFoundExceptionIfNotAccessible(name, address, false);
        for (Attribute attribute : attributes.asList()) {
            try {
                this.setAttribute(reg, address, attribute, accessControl);
            }
            catch (JMRuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw JmxLogger.ROOT_LOGGER.cannotSetAttribute(e, attribute.getName());
            }
        }
        return attributes;
    }

    private void setAttribute(ManagementModelIntegration.ResourceAndRegistration reg, PathAddress address, Attribute attribute, ResourceAccessControlUtil.ResourceAccessControl accessControl) throws InvalidAttributeValueException, AttributeNotFoundException, InstanceNotFoundException {
        ImmutableManagementResourceRegistration registration = this.getMBeanRegistration(address, reg);
        Map attributes = registration.getAttributes(PathAddress.EMPTY_ADDRESS);
        String attributeName = this.findAttributeName(attributes.keySet(), attribute.getName());
        if (!this.mutabilityChecker.mutable(address)) {
            throw JmxLogger.ROOT_LOGGER.attributeNotWritable(attribute);
        }
        if (!accessControl.isWritableAttribute(attributeName)) {
            throw JmxLogger.ROOT_LOGGER.notAuthorizedToWriteAttribute(attributeName);
        }
        ModelNode op = new ModelNode();
        op.get("operation").set("write-attribute");
        op.get("address").set(address.toModelNode());
        op.get("name").set(attributeName);
        try {
            ModelNode attrDesc = this.getAttributeDescription(attributeName, registration, attributes);
            op.get("value").set(this.converters.toModelNode(((AttributeAccess)attributes.get(attributeName)).getAttributeDefinition(), attrDesc, attribute.getValue()));
        }
        catch (ClassCastException e) {
            throw JmxLogger.ROOT_LOGGER.invalidAttributeType(e, attribute.getName());
        }
        ModelNode result = this.execute(op);
        String error = this.getFailureDescription(result);
        if (error != null) {
            if (this.isVaultExpression(attribute.getValue()) && error.contains(AUTHORIZED_ERROR)) {
                throw JmxLogger.ROOT_LOGGER.notAuthorizedToWriteAttribute(attributeName);
            }
            throw new InvalidAttributeValueException(error);
        }
    }

    ObjectInstance getObjectInstance(ObjectName name) throws InstanceNotFoundException {
        PathAddress address = this.resolvePathAddress(name);
        if (address == null) {
            throw JmxLogger.ROOT_LOGGER.mbeanNotFound(name);
        }
        this.accessControlUtil.getResourceAccessWithInstanceNotFoundExceptionIfNotAccessible(name, address, false);
        return new ObjectInstance(name, CLASS_NAME);
    }

    Object invoke(ObjectName name, String operationName, Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException {
        Assert.checkNotNullParam((String)"operationName", (Object)operationName);
        if (params == null) {
            params = new Object[]{};
        }
        if (signature == null) {
            signature = new String[]{};
        }
        if (params.length != signature.length) {
            throw JmxLogger.ROOT_LOGGER.differentLengths("params", "signature");
        }
        ManagementModelIntegration.ResourceAndRegistration reg = this.getRootResourceAndRegistration();
        PathAddress address = this.resolvePathAddress(name, reg);
        if (address == null) {
            throw JmxLogger.ROOT_LOGGER.mbeanNotFound(name);
        }
        ImmutableManagementResourceRegistration registration = this.getMBeanRegistration(address, reg);
        String realOperationName = null;
        OperationEntry opEntry = registration.getOperationEntry(PathAddress.EMPTY_ADDRESS, operationName);
        if (opEntry != null) {
            realOperationName = operationName;
        } else {
            String opName = NameConverter.convertFromCamelCase(operationName);
            opEntry = registration.getOperationEntry(PathAddress.EMPTY_ADDRESS, opName);
            if (opEntry != null) {
                realOperationName = opName;
            }
        }
        if (opEntry == null) {
            Map ops = registration.getOperationDescriptions(PathAddress.EMPTY_ADDRESS, false);
            for (Map.Entry entry : ops.entrySet()) {
                if (!operationName.equals(NameConverter.convertToCamelCase((String)entry.getKey()))) continue;
                opEntry = (OperationEntry)entry.getValue();
                realOperationName = (String)entry.getKey();
                break;
            }
        }
        if (opEntry == null) {
            ChildAddOperationFinder.ChildAddOperationEntry entry = ChildAddOperationFinder.findAddChildOperation(address, this.mutabilityChecker, reg.getRegistration().getSubModel(address), operationName);
            if (entry == null) {
                throw JmxLogger.ROOT_LOGGER.noOperationCalled(null, operationName, address);
            }
            PathElement element = entry.getElement();
            if (element.isWildcard()) {
                if (params.length == 0) {
                    throw JmxLogger.ROOT_LOGGER.wildcardNameParameterRequired();
                }
                element = PathElement.pathElement((String)element.getKey(), (String)((String)params[0]));
                Object[] newParams = new Object[params.length - 1];
                System.arraycopy(params, 1, newParams, 0, newParams.length);
                params = newParams;
            }
            return this.invoke(entry.getOperationEntry(), "add", address.append(new PathElement[]{element}), params);
        }
        return this.invoke(opEntry, realOperationName, address, params);
    }

    private Object invoke(OperationEntry entry, String operationName, PathAddress address, Object[] params) throws InstanceNotFoundException, MBeanException, ReflectionException {
        ModelNode result;
        String error;
        ResourceAccessControlUtil.ResourceAccessControl accessControl;
        if (!(this.mutabilityChecker.mutable(address) || entry.getFlags().contains(OperationEntry.Flag.READ_ONLY) || entry.getFlags().contains(OperationEntry.Flag.RUNTIME_ONLY))) {
            throw JmxLogger.ROOT_LOGGER.noOperationCalled(operationName);
        }
        if (operationName.equals("add")) {
            accessControl = this.accessControlUtil.getResourceAccess(address, true);
        } else {
            ObjectName objectName = ObjectNameAddressUtil.createObjectName(operationName, address);
            accessControl = this.accessControlUtil.getResourceAccessWithInstanceNotFoundExceptionIfNotAccessible(objectName, address, true);
        }
        if (!accessControl.isExecutableOperation(operationName)) {
            throw JmxLogger.ROOT_LOGGER.notAuthorizedToExecuteOperation(operationName);
        }
        ModelNode description = entry.getDescriptionProvider().getModelDescription(null);
        ModelNode op = new ModelNode();
        op.get("operation").set(operationName);
        op.get("address").set(address.toModelNode());
        if (params.length > 0) {
            ModelNode requestProperties = description.require("request-properties");
            Set keys = requestProperties.keys();
            if (keys.size() != params.length) {
                throw JmxLogger.ROOT_LOGGER.differentLengths("params", "description");
            }
            Object[] it = requestProperties.keys().iterator();
            Object[] objectArray = params;
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                Object param = objectArray[i];
                String attributeName = (String)it.next();
                ModelNode paramDescription = requestProperties.get(attributeName);
                AttributeDefinition[] attrs = entry.getOperationDefinition().getParameters();
                AttributeDefinition attr = null;
                for (AttributeDefinition currAttr : attrs) {
                    if (!currAttr.getName().equals(attributeName)) continue;
                    attr = currAttr;
                    break;
                }
                op.get(attributeName).set(this.converters.toModelNode(attr, paramDescription, param));
            }
        }
        if ((error = this.getFailureDescription(result = this.execute(op))) != null) {
            if (error.contains(AUTHORIZED_ERROR)) {
                for (Object param : params) {
                    if (!this.isVaultExpression(param)) continue;
                    throw JmxLogger.ROOT_LOGGER.notAuthorizedToExecuteOperation(operationName);
                }
            }
            throw new ReflectionException(null, error);
        }
        if (!description.hasDefined("reply-properties")) {
            return null;
        }
        AttributeDefinition reply = null;
        AttributeDefinition[] replyParams = entry.getOperationDefinition().getReplyParameters();
        if (replyParams.length > 0) {
            reply = replyParams[0];
        }
        return this.converters.fromModelNode(reply, description.get("reply-properties"), result.get("result"));
    }

    private ManagementModelIntegration.ResourceAndRegistration getRootResourceAndRegistration() {
        return this.managementModelProvider.getResourceAndRegistration();
    }

    private ModelNode execute(ModelNode op) {
        op.get(new String[]{"operation-headers", "access-mechanism"}).set(AccessMechanism.JMX.toString());
        return this.controller.execute(op, null, ModelController.OperationTransactionControl.COMMIT, null);
    }

    private ImmutableManagementResourceRegistration getMBeanRegistration(PathAddress address, ManagementModelIntegration.ResourceAndRegistration reg) throws InstanceNotFoundException {
        ImmutableManagementResourceRegistration resourceRegistration = reg.getRegistration().getSubModel(address);
        if (resourceRegistration == null) {
            throw JmxLogger.ROOT_LOGGER.registrationNotFound(address);
        }
        return resourceRegistration;
    }

    private String getFailureDescription(ModelNode result) {
        if (result.hasDefined("failure-description")) {
            return result.get("failure-description").toString();
        }
        return null;
    }

    private String findAttributeName(Set<String> attributes, String attributeName) throws AttributeNotFoundException {
        if (attributes.contains(attributeName)) {
            return attributeName;
        }
        for (String key : attributes) {
            if (!NameConverter.convertToCamelCase(key).equals(attributeName)) continue;
            return key;
        }
        throw JmxLogger.ROOT_LOGGER.attributeNotFound(attributeName);
    }

    private boolean isExcludeAddress(PathAddress pathAddress) {
        return pathAddress.equals(this.CORE_SERVICE_PLATFORM_MBEAN);
    }

    private boolean isVaultExpression(Object value) {
        String valueString;
        if (value != null && value.getClass() == String.class && ExpressionResolver.EXPRESSION_PATTERN.matcher(valueString = (String)value).matches()) {
            return TypeConverters.VAULT_PATTERN.matcher(valueString).matches();
        }
        return false;
    }

    public static ObjectName createRootObjectName(String domain) {
        try {
            return ObjectName.getInstance(domain, "management-root", "server");
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
    }

    private static ObjectInstance createRootObjectInstance(String domain) {
        return new ObjectInstance(ModelControllerMBeanHelper.createRootObjectName(domain), CLASS_NAME);
    }

    String getDomain() {
        return this.domain;
    }

    ImmutableManagementResourceRegistration getMBeanRegistration(ObjectName name) throws InstanceNotFoundException {
        ManagementModelIntegration.ResourceAndRegistration reg = this.getRootResourceAndRegistration();
        PathAddress address = this.resolvePathAddress(name, reg);
        return this.getMBeanRegistration(address, reg);
    }

    TypeConverters getConverters() {
        return this.converters;
    }

    private abstract class ObjectNameMatchResourceAction<T>
    implements RootResourceIterator.ResourceAction<T> {
        private final ObjectName baseName;
        private final Map<String, String> properties;
        private final ObjectName domainOnlyName;
        private final boolean propertyListPattern;
        private final ObjectNameAddressUtil.ObjectNameCreationContext creationContext = ObjectNameAddressUtil.ObjectNameCreationContext.create();

        ObjectNameMatchResourceAction(ObjectName baseName) {
            this.baseName = baseName;
            this.properties = baseName == null ? Collections.emptyMap() : baseName.getKeyPropertyList();
            try {
                this.domainOnlyName = baseName == null ? null : ObjectName.getInstance(baseName.getDomain() + ":*");
            }
            catch (MalformedObjectNameException e) {
                throw new IllegalStateException(e);
            }
            this.propertyListPattern = baseName != null && baseName.isPropertyListPattern();
        }

        @Override
        public ObjectName onAddress(PathAddress address) {
            if (ModelControllerMBeanHelper.this.isExcludeAddress(address)) {
                return null;
            }
            ObjectName result = null;
            ObjectName toMatch = ObjectNameAddressUtil.createObjectName(ModelControllerMBeanHelper.this.domain, address, this.creationContext);
            if (this.baseName == null) {
                result = toMatch;
            } else if (address.size() == 0) {
                if (this.domainOnlyName.apply(toMatch)) {
                    result = toMatch;
                }
            } else if (!this.propertyListPattern && address.size() >= this.properties.size()) {
                if (this.baseName.apply(toMatch)) {
                    result = toMatch;
                }
            } else {
                boolean matches = this.domainOnlyName.apply(toMatch);
                if (matches) {
                    for (Map.Entry<String, String> entry : toMatch.getKeyPropertyList().entrySet()) {
                        String propertyValue = this.properties.get(entry.getKey());
                        if ((propertyValue != null || this.propertyListPattern) && (propertyValue == null || entry.getValue().equals(propertyValue) || this.baseName.isPropertyValuePattern(entry.getKey()))) continue;
                        matches = false;
                        break;
                    }
                }
                if (matches) {
                    result = toMatch;
                }
            }
            return result;
        }
    }
}

