/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.impl;

import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.MemoryConfiguration;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.impl.InternalDataContainer;
import org.infinispan.container.impl.KeyValueMetadataSizeCalculator;
import org.infinispan.container.offheap.UnpooledOffHeapMemoryAllocator;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.eviction.EvictionType;
import org.infinispan.expiration.impl.InternalExpirationManager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.interceptors.DDAsyncInterceptor;
import org.infinispan.metadata.Metadata;
import org.infinispan.metadata.impl.PrivateMetadata;
import org.infinispan.transaction.impl.AbstractCacheTransaction;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class TransactionalExceptionEvictionInterceptor
extends DDAsyncInterceptor
implements InternalExpirationManager.ExpirationConsumer<Object, Object>,
Consumer<Iterable<InternalCacheEntry<Object, Object>>> {
    private static final Log log = LogFactory.getLog(TransactionalExceptionEvictionInterceptor.class);
    private static final boolean isTrace = log.isTraceEnabled();
    private final AtomicLong currentSize = new AtomicLong();
    private final ConcurrentMap<GlobalTransaction, Long> pendingSize = new ConcurrentHashMap<GlobalTransaction, Long>();
    private MemoryConfiguration memoryConfiguration;
    private InternalDataContainer<Object, Object> container;
    private DistributionManager dm;
    private long maxSize;
    private long minSize;
    private KeyValueMetadataSizeCalculator<Object, Object> calculator;
    private InternalExpirationManager<Object, Object> expirationManager;

    public long getCurrentSize() {
        return this.currentSize.get();
    }

    public long getMaxSize() {
        return this.maxSize;
    }

    public long getMinSize() {
        return this.minSize;
    }

    public long pendingTransactionCount() {
        return this.pendingSize.size();
    }

    @Inject
    public void inject(Configuration config, InternalDataContainer<Object, Object> dataContainer, KeyValueMetadataSizeCalculator<Object, Object> calculator, DistributionManager dm, InternalExpirationManager<Object, Object> expirationManager) {
        this.memoryConfiguration = config.memory();
        this.container = dataContainer;
        this.maxSize = config.memory().size();
        this.calculator = calculator;
        this.dm = dm;
        this.expirationManager = expirationManager;
    }

    @Start
    public void start() {
        if (this.memoryConfiguration.storageType() == StorageType.OFF_HEAP && this.memoryConfiguration.evictionType() == EvictionType.MEMORY) {
            this.minSize = UnpooledOffHeapMemoryAllocator.estimateSizeOverhead(2048L);
            this.currentSize.set(this.minSize);
        }
        this.container.addRemovalListener(this);
        this.expirationManager.addInternalListener(this);
    }

    @Stop
    public void stop() {
        this.container.removeRemovalListener(this);
        this.expirationManager.removeInternalListener(this);
    }

    @Override
    public void expired(Object key, Object value, Metadata metadata, PrivateMetadata privateMetadata) {
        if (value != null) {
            if (isTrace) {
                log.tracef("Key %s found to have expired", key);
            }
            this.increaseSize(-this.calculator.calculateSize(key, value, metadata, privateMetadata));
        }
    }

    @Override
    public void accept(Iterable<InternalCacheEntry<Object, Object>> entries) {
        long changeAmount = 0L;
        for (InternalCacheEntry<Object, Object> entry : entries) {
            changeAmount -= this.calculator.calculateSize(entry.getKey(), entry.getValue(), entry.getMetadata(), entry.getInternalMetadata());
        }
        if (changeAmount != 0L) {
            this.increaseSize(changeAmount);
        }
    }

    private boolean increaseSize(long increaseAmount) {
        long size;
        long targetSize;
        while ((targetSize = (size = this.currentSize.get()) + increaseAmount) <= this.maxSize) {
            if (!this.currentSize.compareAndSet(size, size + increaseAmount)) continue;
            if (isTrace) {
                log.tracef("Increased exception based size by %d to %d", increaseAmount, size + increaseAmount);
            }
            return true;
        }
        return false;
    }

    @Override
    public Object visitInvalidateCommand(InvocationContext ctx, InvalidateCommand command) throws Throwable {
        Object[] keys = command.getKeys();
        long changeAmount = 0L;
        for (Object key : keys) {
            InternalCacheEntry entry = this.container.peek(key);
            if (entry == null) continue;
            changeAmount -= this.calculator.calculateSize(key, entry.getValue(), entry.getMetadata(), entry.getInternalMetadata());
        }
        if (changeAmount != 0L) {
            this.increaseSize(changeAmount);
        }
        return super.visitInvalidateCommand(ctx, command);
    }

    @Override
    public Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
        if (isTrace) {
            log.tracef("Clear command encountered, resetting size to %d", this.minSize);
        }
        this.currentSize.set(this.minSize);
        return super.visitClearCommand(ctx, command);
    }

    @Override
    public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        List<WriteCommand> modifications = ((AbstractCacheTransaction)ctx.getCacheTransaction()).getAllModifications();
        HashSet modifiedKeys = new HashSet();
        for (WriteCommand modification : modifications) {
            modifiedKeys.addAll(modification.getAffectedKeys());
        }
        long changeAmount = 0L;
        for (Object key : modifiedKeys) {
            InternalCacheEntry containerEntry;
            if (this.dm != null && !this.dm.getCacheTopology().isWriteOwner(key)) continue;
            CacheEntry entry = ctx.lookupEntry(key);
            if (entry.isRemoved()) {
                containerEntry = this.container.peek(key);
                Object value = containerEntry != null ? (Object)containerEntry.getValue() : null;
                if (value == null) continue;
                if (isTrace) {
                    log.tracef("Key %s was removed", key);
                }
                changeAmount -= this.calculator.calculateSize(key, value, entry.getMetadata(), entry.getInternalMetadata());
                continue;
            }
            containerEntry = this.container.peek(key);
            if (isTrace) {
                log.tracef("Key %s was put into cache, replacing existing %s", key, containerEntry != null);
            }
            changeAmount += this.calculator.calculateSize(key, entry.getValue(), entry.getMetadata(), entry.getInternalMetadata());
            if (containerEntry == null) continue;
            changeAmount -= this.calculator.calculateSize(key, containerEntry.getValue(), containerEntry.getMetadata(), containerEntry.getInternalMetadata());
        }
        if (changeAmount != 0L && !this.increaseSize(changeAmount)) {
            throw Log.CONTAINER.containerFull(this.maxSize);
        }
        if (!command.isOnePhaseCommit()) {
            this.pendingSize.put(ctx.getGlobalTransaction(), changeAmount);
        }
        return super.visitPrepareCommand(ctx, command);
    }

    @Override
    public Object visitRollbackCommand(TxInvocationContext ctx, RollbackCommand command) throws Throwable {
        Long size = (Long)this.pendingSize.remove(ctx.getGlobalTransaction());
        if (size != null) {
            long newSize = this.currentSize.addAndGet(-size.longValue());
            if (isTrace) {
                log.tracef("Rollback encountered subtracting exception size by %d to %d", size, newSize);
            }
        }
        return super.visitRollbackCommand(ctx, command);
    }

    @Override
    public Object visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
        this.pendingSize.remove(ctx.getGlobalTransaction());
        return super.visitCommitCommand(ctx, command);
    }
}

