/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld;

import java.lang.annotation.Annotation;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Supplier;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.util.AnnotationLiteral;
import javax.validation.ValidatorFactory;
import org.jboss.as.ee.beanvalidation.BeanValidationAttachments;
import org.jboss.as.ee.beanvalidation.LazyValidatorFactory;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.modules.Module;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.wildfly.security.manager.WildFlySecurityManager;

public class CdiValidatorFactoryService
implements Service {
    public static final ServiceName SERVICE_NAME = ServiceName.of((String[])new String[]{"CdiValidatorFactoryService"});
    private final Supplier<BeanManager> beanManagerSupplier;
    private final ClassLoader classLoader;
    private final DeploymentUnit deploymentUnit;

    public CdiValidatorFactoryService(DeploymentUnit deploymentUnit, Supplier<BeanManager> beanManagerSupplier) {
        this.deploymentUnit = deploymentUnit;
        Module module = (Module)this.deploymentUnit.getAttachment(Attachments.MODULE);
        this.classLoader = module.getClassLoader();
        this.beanManagerSupplier = beanManagerSupplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(StartContext context) {
        ClassLoader cl = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
        try {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)this.classLoader);
            ValidatorFactory validatorFactory = this.getReference(ValidatorFactory.class, this.beanManagerSupplier.get());
            LazyValidatorFactory lazyValidatorFactory = (LazyValidatorFactory)this.deploymentUnit.getAttachment(BeanValidationAttachments.VALIDATOR_FACTORY);
            lazyValidatorFactory.replaceDelegate(validatorFactory);
        }
        finally {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)cl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(StopContext context) {
        ClassLoader cl = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
        try {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)this.classLoader);
            ValidatorFactory validatorFactory = (ValidatorFactory)this.deploymentUnit.getAttachment(BeanValidationAttachments.VALIDATOR_FACTORY);
            if (validatorFactory != null) {
                validatorFactory.close();
            }
        }
        finally {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)cl);
        }
    }

    private <T> T getReference(Class<T> clazz, BeanManager beanManager) {
        Set beans = beanManager.getBeans(clazz, new Annotation[]{new AnnotationLiteral<Default>(){}});
        Iterator i = beans.iterator();
        if (!i.hasNext()) {
            return null;
        }
        Bean bean = (Bean)i.next();
        CreationalContext context = beanManager.createCreationalContext((Contextual)bean);
        return (T)beanManager.getReference(bean, clazz, context);
    }
}

