/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.management;

import java.util.HashMap;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.activemq.artemis.core.config.JMXConnectorConfiguration;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.management.ConnectorServerFactory;
import org.apache.activemq.artemis.core.server.management.JaasAuthenticator;
import org.apache.activemq.artemis.core.server.management.MBeanServerFactory;
import org.apache.activemq.artemis.core.server.management.RmiRegistryFactory;

public class ManagementConnector
implements ActiveMQComponent {
    private final JMXConnectorConfiguration configuration;
    private ConnectorServerFactory connectorServerFactory;
    private RmiRegistryFactory rmiRegistryFactory;
    private MBeanServerFactory mbeanServerFactory;

    public ManagementConnector(JMXConnectorConfiguration configuration) {
        this.configuration = configuration;
    }

    public boolean isStarted() {
        return this.rmiRegistryFactory != null;
    }

    public void start() throws Exception {
        this.rmiRegistryFactory = new RmiRegistryFactory();
        this.rmiRegistryFactory.setPort(this.configuration.getConnectorPort());
        this.rmiRegistryFactory.init();
        this.mbeanServerFactory = new MBeanServerFactory();
        this.mbeanServerFactory.setLocateExistingServerIfPossible(true);
        this.mbeanServerFactory.init();
        MBeanServer mbeanServer = this.mbeanServerFactory.getServer();
        JaasAuthenticator jaasAuthenticator = new JaasAuthenticator();
        jaasAuthenticator.setRealm(this.configuration.getJmxRealm());
        this.connectorServerFactory = new ConnectorServerFactory();
        this.connectorServerFactory.setServer(mbeanServer);
        this.connectorServerFactory.setServiceUrl(this.configuration.getServiceUrl());
        this.connectorServerFactory.setRmiServerHost(this.configuration.getConnectorHost());
        this.connectorServerFactory.setObjectName(new ObjectName(this.configuration.getObjectName()));
        HashMap<String, JaasAuthenticator> environment = new HashMap<String, JaasAuthenticator>();
        environment.put("jmx.remote.authenticator", jaasAuthenticator);
        try {
            this.connectorServerFactory.setEnvironment(environment);
            this.connectorServerFactory.setAuthenticatorType(this.configuration.getAuthenticatorType());
            this.connectorServerFactory.setSecured(this.configuration.isSecured());
            this.connectorServerFactory.setKeyStorePath(this.configuration.getKeyStorePath());
            this.connectorServerFactory.setkeyStoreProvider(this.configuration.getKeyStoreProvider());
            this.connectorServerFactory.setKeyStorePassword(this.configuration.getKeyStorePassword());
            this.connectorServerFactory.setTrustStorePath(this.configuration.getTrustStorePath());
            this.connectorServerFactory.setTrustStoreProvider(this.configuration.getTrustStoreProvider());
            this.connectorServerFactory.setTrustStorePassword(this.configuration.getTrustStorePassword());
            this.connectorServerFactory.init();
        }
        catch (Exception e) {
            ActiveMQServerLogger.LOGGER.error("Can't init JMXConnectorServer: " + e.getMessage());
        }
    }

    public void stop() {
        if (this.connectorServerFactory != null) {
            try {
                this.connectorServerFactory.destroy();
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.warn("Error destroying ConnectorServerFactory", e);
            }
            this.connectorServerFactory = null;
        }
        if (this.mbeanServerFactory != null) {
            try {
                this.mbeanServerFactory.destroy();
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.warn("Error destroying MBeanServerFactory", e);
            }
            this.mbeanServerFactory = null;
        }
        if (this.rmiRegistryFactory != null) {
            try {
                this.rmiRegistryFactory.destroy();
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.warn("Error destroying RMIRegistryFactory", e);
            }
            this.rmiRegistryFactory = null;
        }
    }
}

