/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.global;

import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.executors.BlockingThreadPoolExecutorFactory;
import org.infinispan.commons.executors.ThreadPoolExecutorFactory;
import org.infinispan.configuration.global.AbstractGlobalConfigurationBuilder;
import org.infinispan.configuration.global.BoundedThreadPoolConfiguration;
import org.infinispan.configuration.global.CachedThreadPoolConfiguration;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.global.ThreadPoolBuilderAdapter;
import org.infinispan.configuration.global.ThreadPoolConfiguration;
import org.infinispan.configuration.global.ThreadPoolConfigurationBuilder;
import org.infinispan.factories.threads.DefaultThreadFactory;

public class BoundedThreadPoolConfigurationBuilder
extends AbstractGlobalConfigurationBuilder
implements Builder<BoundedThreadPoolConfiguration>,
ThreadPoolBuilderAdapter {
    private final AttributeSet attributes = BoundedThreadPoolConfiguration.attributeDefinitionSet();

    BoundedThreadPoolConfigurationBuilder(GlobalConfigurationBuilder globalConfig, String name) {
        super(globalConfig);
        this.attributes.attribute(CachedThreadPoolConfiguration.NAME).set((Object)name);
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public BoundedThreadPoolConfigurationBuilder threadFactory(String threadFactory) {
        this.attributes.attribute(CachedThreadPoolConfiguration.THREAD_FACTORY).set((Object)threadFactory);
        return this;
    }

    public BoundedThreadPoolConfigurationBuilder maxThreads(Integer maxThreads) {
        this.attributes.attribute(BoundedThreadPoolConfiguration.MAX_THREADS).set((Object)maxThreads);
        return this;
    }

    public Integer maxThreads() {
        return (Integer)this.attributes.attribute(BoundedThreadPoolConfiguration.MAX_THREADS).get();
    }

    public BoundedThreadPoolConfigurationBuilder coreThreads(Integer coreThreads) {
        this.attributes.attribute(BoundedThreadPoolConfiguration.CORE_THREADS).set((Object)coreThreads);
        return this;
    }

    public Integer coreThreads() {
        return (Integer)this.attributes.attribute(BoundedThreadPoolConfiguration.CORE_THREADS).get();
    }

    public BoundedThreadPoolConfigurationBuilder keepAliveTime(Long keepAlive) {
        this.attributes.attribute(BoundedThreadPoolConfiguration.KEEP_ALIVE_TIME).set((Object)keepAlive);
        return this;
    }

    public Long keepAliveTime() {
        return (Long)this.attributes.attribute(BoundedThreadPoolConfiguration.KEEP_ALIVE_TIME).get();
    }

    public BoundedThreadPoolConfigurationBuilder queueLength(Integer queueLength) {
        this.attributes.attribute(BoundedThreadPoolConfiguration.QUEUE_LENGTH).set((Object)queueLength);
        return this;
    }

    public Integer queueLength() {
        return (Integer)this.attributes.attribute(BoundedThreadPoolConfiguration.QUEUE_LENGTH).get();
    }

    public BoundedThreadPoolConfigurationBuilder nonBlocking(Boolean nonBlocking) {
        this.attributes.attribute(BoundedThreadPoolConfiguration.NON_BLOCKING).set((Object)nonBlocking);
        return this;
    }

    public Boolean isNonBlocking() {
        return (Boolean)this.attributes.attribute(BoundedThreadPoolConfiguration.NON_BLOCKING).get();
    }

    public String name() {
        return (String)this.attributes.attribute(CachedThreadPoolConfiguration.NAME).get();
    }

    public void validate() {
    }

    public BoundedThreadPoolConfiguration create() {
        return new BoundedThreadPoolConfiguration(this.attributes.protect());
    }

    public BoundedThreadPoolConfigurationBuilder read(BoundedThreadPoolConfiguration template) {
        this.attributes.read(template.attributes());
        return this;
    }

    public String threadFactory() {
        return (String)this.attributes.attribute(CachedThreadPoolConfiguration.THREAD_FACTORY).get();
    }

    public String toString() {
        return "BoundedThreadPoolConfigurationBuilder{attributes=" + this.attributes + '}';
    }

    @Override
    public ThreadPoolConfiguration asThreadPoolConfigurationBuilder() {
        ThreadPoolConfigurationBuilder builder = new ThreadPoolConfigurationBuilder(this.getGlobalConfig());
        boolean isNonBlocking = this.isNonBlocking();
        builder.threadPoolFactory((ThreadPoolExecutorFactory)new BlockingThreadPoolExecutorFactory(this.maxThreads().intValue(), this.coreThreads().intValue(), this.queueLength().intValue(), this.keepAliveTime().longValue(), isNonBlocking));
        builder.name(this.name());
        if (this.threadFactory() != null) {
            DefaultThreadFactory threadFactory = this.getGlobalConfig().threads().getThreadFactory(this.threadFactory()).create().getThreadFactory(isNonBlocking);
            builder.threadFactory(threadFactory);
        }
        return builder.create();
    }
}

