/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.sso;

import io.undertow.security.api.AuthenticatedSessionManager;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.Session;
import io.undertow.server.session.SessionListener;
import java.util.function.Consumer;
import org.jboss.as.clustering.controller.CapabilityServiceConfigurator;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.service.SimpleServiceNameProvider;
import org.wildfly.clustering.service.SupplierDependency;
import org.wildfly.clustering.web.sso.SSOManager;
import org.wildfly.clustering.web.sso.Sessions;

public class SessionListenerServiceConfigurator
extends SimpleServiceNameProvider
implements CapabilityServiceConfigurator,
SessionListener {
    private final SupplierDependency<SSOManager<AuthenticatedSessionManager.AuthenticatedSession, String, String, Void, Batch>> manager;

    public SessionListenerServiceConfigurator(ServiceName name, SupplierDependency<SSOManager<AuthenticatedSessionManager.AuthenticatedSession, String, String, Void, Batch>> manager) {
        super(name);
        this.manager = manager;
    }

    public ServiceBuilder<?> build(ServiceTarget target) {
        ServiceBuilder builder = target.addService(this.getServiceName());
        Consumer listener = this.manager.register(builder).provides(new ServiceName[]{this.getServiceName()});
        Service service = Service.newInstance((Consumer)listener, (Object)((Object)this));
        return builder.setInstance(service).setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    public void sessionIdChanged(Session session, String oldSessionId) {
        block13: {
            SSOManager manager = (SSOManager)this.manager.get();
            try (Batch batch = manager.getBatcher().createBatch();){
                Sessions sessions = manager.findSessionsContaining((Object)oldSessionId);
                if (sessions == null) break block13;
                for (String deployment : sessions.getDeployments()) {
                    if (sessions.getSession((Object)deployment) == null) continue;
                    sessions.removeSession((Object)deployment);
                    sessions.addSession((Object)deployment, (Object)session.getId());
                    break;
                }
            }
        }
    }

    public void sessionCreated(Session session, HttpServerExchange exchange) {
    }

    public void sessionDestroyed(Session session, HttpServerExchange exchange, SessionListener.SessionDestroyedReason reason) {
    }

    public void attributeAdded(Session session, String name, Object value) {
    }

    public void attributeUpdated(Session session, String name, Object newValue, Object oldValue) {
    }

    public void attributeRemoved(Session session, String name, Object oldValue) {
    }
}

