/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.metrics;

import io.smallrye.metrics.ExtendedMetadata;
import io.smallrye.metrics.MetricRegistries;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.Tag;
import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.controller.LocalModelControllerClient;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ProcessStateNotifier;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.extension.microprofile.metrics._private.MicroProfileMetricsLogger;

public class MetricCollector {
    private final boolean exposeAnySubsystem;
    private String globalPrefix;
    private final List<String> exposedSubsystems;
    private final LocalModelControllerClient modelControllerClient;
    private final ProcessStateNotifier processStateNotifier;

    public MetricCollector(LocalModelControllerClient modelControllerClient, ProcessStateNotifier processStateNotifier, List<String> exposedSubsystems, String globalPrefix) {
        this.modelControllerClient = modelControllerClient;
        this.processStateNotifier = processStateNotifier;
        this.exposedSubsystems = exposedSubsystems;
        this.exposeAnySubsystem = exposedSubsystems.remove("*");
        this.globalPrefix = globalPrefix;
    }

    public MetricRegistration collectResourceMetrics(Resource resource, ImmutableManagementResourceRegistration managementResourceRegistration, Function<PathAddress, PathAddress> resourceAddressResolver) {
        final MetricRegistration registration = new MetricRegistration();
        this.collectResourceMetrics0(resource, managementResourceRegistration, PathAddress.EMPTY_ADDRESS, resourceAddressResolver, registration);
        PropertyChangeListener listener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (ControlledProcessState.State.RUNNING == evt.getNewValue()) {
                    registration.register();
                } else if (ControlledProcessState.State.STOPPING == evt.getNewValue()) {
                    registration.unregister();
                    MetricCollector.this.processStateNotifier.removePropertyChangeListener((PropertyChangeListener)this);
                }
            }
        };
        this.processStateNotifier.addPropertyChangeListener(listener);
        if (ControlledProcessState.State.RUNNING == this.processStateNotifier.getCurrentState()) {
            registration.register();
        }
        return registration;
    }

    private void collectResourceMetrics0(Resource current, ImmutableManagementResourceRegistration managementResourceRegistration, PathAddress address, Function<PathAddress, PathAddress> resourceAddressResolver, MetricRegistration registration) {
        if (!this.isExposingMetrics(address)) {
            return;
        }
        Map attributes = managementResourceRegistration.getAttributes(address);
        if (attributes == null) {
            return;
        }
        ModelNode resourceDescription = null;
        for (Map.Entry entry : attributes.entrySet()) {
            String attributeName = (String)entry.getKey();
            AttributeAccess attributeAccess = (AttributeAccess)entry.getValue();
            if (!this.isCollectibleMetric(attributeAccess)) continue;
            if (resourceDescription == null) {
                DescriptionProvider modelDescription = managementResourceRegistration.getModelDescription(address);
                resourceDescription = modelDescription.getModelDescription(Locale.getDefault());
            }
            PathAddress resourceAddress = resourceAddressResolver.apply(address);
            MeasurementUnit unit = attributeAccess.getAttributeDefinition().getMeasurementUnit();
            boolean isCounter = attributeAccess.getFlags().contains(AttributeAccess.Flag.COUNTER_METRIC);
            MetricMetadata metricMetadata = new MetricMetadata(attributeName, resourceAddress, this.globalPrefix);
            String attributeDescription = resourceDescription.get(new String[]{"attributes", attributeName, "description"}).asStringOrNull();
            Tag[] tags = this.createTags(metricMetadata);
            MetricID metricID = new MetricID(metricMetadata.metricName, tags);
            registration.addRegistrationTask(() -> this.registerMetric(metricMetadata, resourceAddress, attributeName, unit, attributeDescription, isCounter, tags));
            registration.addUnregistrationTask(metricID);
        }
        for (String type : current.getChildTypes()) {
            if (!current.hasChildren(type)) continue;
            for (Resource.ResourceEntry entry : current.getChildren(type)) {
                PathElement pathElement = entry.getPathElement();
                PathAddress childAddress = address.append(new PathElement[]{pathElement});
                this.collectResourceMetrics0((Resource)entry, managementResourceRegistration, childAddress, resourceAddressResolver, registration);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerMetric(MetricMetadata metricMetadata, final PathAddress address, final String attributeName, MeasurementUnit unit, String description, boolean isCounter, Tag[] tags) {
        MetricRegistry vendorRegistry;
        Object metric = isCounter ? new Counter(){

            public void inc() {
            }

            public void inc(long n) {
            }

            public long getCount() {
                ModelNode result = MetricCollector.this.readAttributeValue(address, attributeName);
                if (result.isDefined()) {
                    try {
                        return result.asLong();
                    }
                    catch (Exception e) {
                        throw MicroProfileMetricsLogger.LOGGER.unableToConvertAttribute(attributeName, address, e);
                    }
                }
                return 0L;
            }
        } : new Gauge<Number>(){

            public Double getValue() {
                ModelNode result = MetricCollector.this.readAttributeValue(address, attributeName);
                if (result.isDefined()) {
                    try {
                        return result.asDouble();
                    }
                    catch (Exception e) {
                        throw MicroProfileMetricsLogger.LOGGER.unableToConvertAttribute(attributeName, address, e);
                    }
                }
                return 0.0;
            }
        };
        MetricRegistry metricRegistry = vendorRegistry = MetricRegistries.get((MetricRegistry.Type)MetricRegistry.Type.VENDOR);
        synchronized (metricRegistry) {
            Metadata existingMetadata = (Metadata)vendorRegistry.getMetadata().get(metricMetadata.metricName);
            Object metadata = existingMetadata != null ? existingMetadata : new ExtendedMetadata(metricMetadata.metricName, metricMetadata.metricName, description, isCounter ? MetricType.COUNTER : MetricType.GAUGE, this.metricUnit(unit), null, false, Optional.of(false));
            vendorRegistry.register(metadata, (Metric)metric, tags);
        }
    }

    private String metricUnit(MeasurementUnit unit) {
        if (unit == null) {
            return "none";
        }
        switch (unit) {
            case PERCENTAGE: {
                return "percent";
            }
            case BYTES: {
                return "bytes";
            }
            case KILOBYTES: {
                return "kilobytes";
            }
            case MEGABYTES: {
                return "megabytes";
            }
            case GIGABYTES: {
                return "gigabytes";
            }
            case TERABYTES: {
                return "terabytes";
            }
            case PETABYTES: {
                return "petabytes";
            }
            case BITS: {
                return "bits";
            }
            case KILOBITS: {
                return "kilobits";
            }
            case MEGABITS: {
                return "mebibits";
            }
            case GIGABITS: {
                return "gigabits";
            }
            case TERABITS: {
                return "terabits";
            }
            case PETABITS: {
                return "petabits";
            }
            case EPOCH_MILLISECONDS: {
                return "milliseconds";
            }
            case EPOCH_SECONDS: {
                return "seconds";
            }
            case JIFFYS: {
                return "jiffys";
            }
            case NANOSECONDS: {
                return "nanoseconds";
            }
            case MICROSECONDS: {
                return "microseconds";
            }
            case MILLISECONDS: {
                return "milliseconds";
            }
            case SECONDS: {
                return "seconds";
            }
            case MINUTES: {
                return "minutes";
            }
            case HOURS: {
                return "hours";
            }
            case DAYS: {
                return "days";
            }
            case PER_JIFFY: {
                return "per-jiffy";
            }
            case PER_NANOSECOND: {
                return "per_nanoseconds";
            }
            case PER_MICROSECOND: {
                return "per_microseconds";
            }
            case PER_MILLISECOND: {
                return "per_milliseconds";
            }
            case PER_SECOND: {
                return "per_second";
            }
            case PER_MINUTE: {
                return "per_minutes";
            }
            case PER_HOUR: {
                return "per_hour";
            }
            case PER_DAY: {
                return "per_day";
            }
            case CELSIUS: {
                return "degree_celsius";
            }
            case KELVIN: {
                return "kelvin";
            }
            case FAHRENHEIGHT: {
                return "degree_fahrenheit";
            }
        }
        return "none";
    }

    private Tag[] createTags(MetricMetadata metadata) {
        Tag[] tags = new Tag[metadata.labelNames.size()];
        for (int i = 0; i < metadata.labelNames.size(); ++i) {
            String name = (String)metadata.labelNames.get(i);
            String value = (String)metadata.labelValues.get(i);
            tags[i] = new Tag(name, value);
        }
        return tags;
    }

    private ModelNode readAttributeValue(PathAddress address, String attributeName) {
        ModelNode readAttributeOp = new ModelNode();
        readAttributeOp.get("operation").set("read-attribute");
        readAttributeOp.get("address").set(address.toModelNode());
        readAttributeOp.get("include-undefined-metric-values").set(true);
        readAttributeOp.get("name").set(attributeName);
        ModelNode response = this.modelControllerClient.execute(readAttributeOp);
        String error = this.getFailureDescription(response);
        if (error != null) {
            throw MicroProfileMetricsLogger.LOGGER.unableToReadAttribute(attributeName, address, error);
        }
        return response.get("result");
    }

    private boolean isExposingMetrics(PathAddress address) {
        if (address.size() == 0) {
            return true;
        }
        String subsystemName = this.getSubsystemName(address);
        if (subsystemName != null) {
            return this.exposeAnySubsystem || this.exposedSubsystems.contains(subsystemName);
        }
        return false;
    }

    private String getSubsystemName(PathAddress address) {
        if (address.size() == 0) {
            return null;
        }
        if (address.getElement(0).getKey().equals("subsystem")) {
            return address.getElement(0).getValue();
        }
        return this.getSubsystemName(address.subAddress(1));
    }

    private boolean isCollectibleMetric(AttributeAccess attributeAccess) {
        ModelType type;
        return attributeAccess.getAccessType() == AttributeAccess.AccessType.METRIC && attributeAccess.getStorageType() == AttributeAccess.Storage.RUNTIME && ((type = attributeAccess.getAttributeDefinition().getType()) == ModelType.INT || type == ModelType.LONG || type == ModelType.DOUBLE);
    }

    private String getFailureDescription(ModelNode result) {
        if (result.hasDefined("failure-description")) {
            return result.get("failure-description").toString();
        }
        return null;
    }

    private static class MetricMetadata {
        private static final Pattern SNAKE_CASE_PATTERN = Pattern.compile("(?<=[a-z])[A-Z]");
        private final String metricName;
        private final List<String> labelNames;
        private final List<String> labelValues;

        MetricMetadata(String attributeName, PathAddress address, String globalPrefix) {
            String metricPrefix = "";
            this.labelNames = new ArrayList<String>();
            this.labelValues = new ArrayList<String>();
            for (PathElement element : address) {
                String key = element.getKey();
                String value = element.getValue();
                if (key.equals("subsystem") || key.equals("statistics")) {
                    metricPrefix = metricPrefix + value + "-";
                    continue;
                }
                this.labelNames.add(MetricMetadata.getPrometheusMetricName(key));
                this.labelValues.add(value);
            }
            if (this.labelNames.contains("deployment") && !this.labelNames.contains("subdeployment")) {
                this.labelNames.add("subdeployment");
                this.labelValues.add(this.labelValues.get(this.labelNames.indexOf("deployment")));
            }
            if (globalPrefix != null && !globalPrefix.isEmpty()) {
                metricPrefix = globalPrefix + "-" + metricPrefix;
            }
            this.metricName = MetricMetadata.getPrometheusMetricName(metricPrefix + attributeName);
        }

        private static String getPrometheusMetricName(String name) {
            name = name.replaceAll("[^\\w]+", "_");
            name = MetricMetadata.decamelize(name);
            return name;
        }

        private static String decamelize(String in) {
            Matcher m = SNAKE_CASE_PATTERN.matcher(in);
            StringBuffer sb = new StringBuffer();
            while (m.find()) {
                m.appendReplacement(sb, "_" + m.group().toLowerCase());
            }
            m.appendTail(sb);
            return sb.toString().toLowerCase();
        }
    }

    public static final class MetricRegistration {
        private final List<Runnable> registrationTasks = new ArrayList<Runnable>();
        private final List<MetricID> unregistrationTasks = new ArrayList<MetricID>();

        MetricRegistration() {
        }

        public synchronized void register() {
            for (Runnable task : this.registrationTasks) {
                task.run();
            }
            this.registrationTasks.clear();
        }

        public void unregister() {
            MetricRegistry registry = MetricRegistries.get((MetricRegistry.Type)MetricRegistry.Type.VENDOR);
            for (MetricID id : this.unregistrationTasks) {
                registry.remove(id);
            }
        }

        private synchronized void addRegistrationTask(Runnable task) {
            this.registrationTasks.add(task);
        }

        private void addUnregistrationTask(MetricID metricID) {
            this.unregistrationTasks.add(metricID);
        }
    }
}

