/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.singleton.deployment;

import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.server.deployment.DeploymentUnitPhaseBuilder;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.singleton.SingletonPolicy;

public class SingletonDeploymentUnitPhaseBuilder
implements DeploymentUnitPhaseBuilder {
    private static final String EJB_REMOTE_CAPABILITY = "org.wildfly.ejb.remote";
    private final CapabilityServiceSupport support;
    private final SingletonPolicy policy;

    public SingletonDeploymentUnitPhaseBuilder(CapabilityServiceSupport support, SingletonPolicy policy) {
        this.support = support;
        this.policy = policy;
    }

    public <T> ServiceBuilder<T> build(ServiceTarget target, ServiceName name, Service<T> service) {
        ServiceBuilder builder = this.policy.createSingletonServiceBuilder(name, service).build(target).setInitialMode(ServiceController.Mode.ACTIVE);
        if (this.support.hasCapability(EJB_REMOTE_CAPABILITY)) {
            builder.requires(this.support.getCapabilityServiceName(EJB_REMOTE_CAPABILITY));
        }
        return builder;
    }
}

