/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.configuration;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.configuration.ConfigurationBuilderInfo;
import org.infinispan.commons.configuration.ConfigurationInfo;
import org.infinispan.commons.configuration.Json;
import org.infinispan.commons.configuration.JsonCustomFactory;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeSerializer;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.elements.ElementDefinition;

public class JsonWriter {
    public String toJSON(ConfigurationInfo configurationInfo) {
        ConfigurationInfo configInfo = Objects.requireNonNull(configurationInfo, "expect a non-null configuration object");
        Json json = Json.object();
        this.writeElement(json, configInfo, true);
        return json.toString();
    }

    void writeElement(Json parent, ConfigurationInfo element, boolean renderName) {
        ElementDefinition configurationElement = element.getElementDefinition();
        if (configurationElement == null) {
            throw new CacheConfigurationException("No ElementDefinition found for " + element.getClass());
        }
        AttributeSet attributes = element.attributes();
        List<ConfigurationInfo> childElements = element.subElements();
        Json body = Json.object();
        ElementDefinition.ElementOutput elementOutput = element.getElementDefinition().toExternalName(element);
        if (elementOutput.getClassName() != null) {
            body.set("class", (Object)elementOutput.getClassName());
        }
        if (attributes != null && !attributes.isEmpty()) {
            this.writeAttributes(body, attributes, element);
        }
        Map<String, List<ConfigurationInfo>> elementsByName = this.groupElementsByName(childElements);
        elementsByName.forEach((name, cfg) -> {
            if (cfg.size() > 1) {
                this.writeArray(body, element, (List<ConfigurationInfo>)cfg);
            } else {
                ConfigurationInfo subElement = (ConfigurationInfo)cfg.iterator().next();
                ElementDefinition definition = subElement.getElementDefinition();
                this.writeElement(body, subElement, definition.isTopLevel());
            }
        });
        if (!body.asJsonMap().isEmpty() || !configurationElement.omitIfEmpty()) {
            if (renderName) {
                String name2 = elementOutput.getName();
                Json existingElement = parent.at(name2);
                if (existingElement == null) {
                    parent.set(name2, Json.object());
                }
                parent.at(name2).asJsonMap().putAll(body.asJsonMap());
            } else {
                parent.asJsonMap().putAll(body.asJsonMap());
            }
        }
    }

    private void writeArray(Json parent, ConfigurationInfo configurationInfo, List<ConfigurationInfo> configurationInfos) {
        ElementDefinition.ElementOutput elementOutput = configurationInfos.iterator().next().getElementDefinition().toExternalName(configurationInfo);
        String arrayName = elementOutput.getName();
        Json arrayJson = Json.array();
        configurationInfos.forEach(info -> {
            Json arrayItemJson = Json.object();
            this.writeElement(arrayItemJson, (ConfigurationInfo)info, false);
            arrayJson.add(arrayItemJson);
        });
        parent.set(arrayName, arrayJson);
    }

    private void writeAttributes(Json parent, AttributeSet attributeSet, ConfigurationInfo element) {
        Json json = Json.object();
        for (Attribute<?> attribute : attributeSet.attributes()) {
            AttributeSerializer<?, ConfigurationInfo, ConfigurationBuilderInfo> serializerConfig = attribute.getAttributeDefinition().getSerializerConfig();
            String attrName = serializerConfig.getSerializationName(attribute, element);
            Object attrValue = serializerConfig.getSerializationValue(attribute, element);
            if (!attribute.isModified()) continue;
            if (attrName == null && attrValue instanceof Map) {
                Map valueMap = (Map)attrValue;
                valueMap.forEach(json::set);
                continue;
            }
            if (attrName == null || attrName.isEmpty() || attrValue == null) continue;
            json.set(attrName, attrValue);
        }
        if (json != null) {
            parent.asJsonMap().putAll(json.asJsonMap());
        }
    }

    private Map<String, List<ConfigurationInfo>> groupElementsByName(List<ConfigurationInfo> configurationInfos) {
        LinkedHashMap<String, List<ConfigurationInfo>> configsByName = new LinkedHashMap<String, List<ConfigurationInfo>>();
        configurationInfos.forEach(c -> {
            ElementDefinition elementDefinition = c.getElementDefinition();
            if (elementDefinition != null) {
                String elementName = elementDefinition.toExternalName(c).getName();
                configsByName.computeIfAbsent(elementName, v -> new ArrayList()).add(c);
            }
        });
        return configsByName;
    }

    static {
        Json.setGlobalFactory(new JsonCustomFactory());
    }
}

