/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream;

import java.io.IOException;
import java.io.StreamCorruptedException;
import java.util.EnumSet;
import java.util.OptionalInt;
import org.infinispan.protostream.BaseMarshaller;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.RawProtoStreamReader;
import org.infinispan.protostream.RawProtoStreamWriter;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.impl.WireFormat;
import org.wildfly.clustering.marshalling.protostream.AbstractSerializationContextInitializer;
import org.wildfly.clustering.marshalling.protostream.AnyField;
import org.wildfly.clustering.marshalling.protostream.Predictable;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;

public class LangSerializationContextInitializer
extends AbstractSerializationContextInitializer {
    @Override
    public String getProtoFileName() {
        return "java.lang.proto";
    }

    public void registerMarshallers(SerializationContext context) {
        for (AnyField field : EnumSet.allOf(AnyField.class)) {
            Class<? extends Object> fieldClass = field.getJavaClass();
            if (fieldClass == Void.class) continue;
            context.registerMarshaller((BaseMarshaller)new AnyFieldProtoStreamMarshaller(field));
        }
    }

    private static class AnyFieldProtoStreamMarshaller
    implements ProtoStreamMarshaller<Object> {
        private final AnyField field;

        AnyFieldProtoStreamMarshaller(AnyField field) {
            this.field = field;
        }

        @Override
        public OptionalInt size(ImmutableSerializationContext context, Object value) {
            OptionalInt size = this.field.size(context, value);
            return size.isPresent() ? OptionalInt.of(size.getAsInt() + Predictable.unsignedIntSize(this.field.getIndex() << 3 | 0)) : OptionalInt.empty();
        }

        @Override
        public String getTypeName() {
            return this.field.getTypeName();
        }

        public Class<? extends Object> getJavaClass() {
            return this.field.getJavaClass();
        }

        public Object readFrom(ImmutableSerializationContext context, RawProtoStreamReader reader) throws IOException {
            if (WireFormat.getTagFieldNumber((int)reader.readTag()) != this.field.getIndex()) {
                throw new StreamCorruptedException();
            }
            Object result = this.field.readFrom(context, reader);
            if (reader.readTag() != 0) {
                throw new StreamCorruptedException();
            }
            return result;
        }

        public void writeTo(ImmutableSerializationContext context, RawProtoStreamWriter writer, Object object) throws IOException {
            this.field.writeTo(context, writer, object);
        }
    }
}

