/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.subsystem;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jboss.as.clustering.controller.Operations;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.transform.CombinedTransformer;
import org.jboss.as.controller.transform.ExtensionTransformerRegistration;
import org.jboss.as.controller.transform.OperationRejectionPolicy;
import org.jboss.as.controller.transform.OperationResultTransformer;
import org.jboss.as.controller.transform.OperationTransformer;
import org.jboss.as.controller.transform.ResourceTransformationContext;
import org.jboss.as.controller.transform.ResourceTransformer;
import org.jboss.as.controller.transform.SubsystemTransformerRegistration;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.controller.transform.description.AttributeConverter;
import org.jboss.as.controller.transform.description.AttributeTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.ChainedTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.DiscardAttributeChecker;
import org.jboss.as.controller.transform.description.RejectAttributeChecker;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.TransformationDescriptionBuilder;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.subsystem.EJB3Model;
import org.jboss.as.ejb3.subsystem.EJB3RemoteResourceDefinition;
import org.jboss.as.ejb3.subsystem.EJB3SubsystemModel;
import org.jboss.as.ejb3.subsystem.EJB3SubsystemRootResourceDefinition;
import org.jboss.as.ejb3.subsystem.PassivationStoreResourceDefinition;
import org.jboss.as.ejb3.subsystem.RemotingProfileResourceDefinition;
import org.jboss.as.ejb3.subsystem.StaticEJBDiscoveryDefinition;
import org.jboss.as.ejb3.subsystem.StrictMaxPoolResourceDefinition;
import org.jboss.as.ejb3.subsystem.TimerServiceResourceDefinition;
import org.jboss.as.threads.PoolAttributeDefinitions;
import org.jboss.dmr.ModelNode;

public class EJBTransformers
implements ExtensionTransformerRegistration {
    private static final RejectAttributeChecker REJECT_NON_SINGLETON_LIST = new RejectAttributeChecker.DefaultRejectAttributeChecker(){

        protected boolean rejectAttribute(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
            return attributeValue.isDefined() && attributeValue.asList().size() > 1;
        }

        public String getRejectionLogMessageId() {
            return this.getRejectionLogMessage(Collections.emptyMap());
        }

        public String getRejectionLogMessage(Map<String, ModelNode> attributes) {
            return EjbLogger.REMOTE_LOGGER.multipleValuesNotSupported(attributes.keySet());
        }
    };
    private static final DiscardAttributeChecker DISCARD_SINGLETON_LIST = new DiscardAttributeChecker.DefaultDiscardAttributeChecker(false, true){

        protected boolean isValueDiscardable(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
            return !attributeValue.isDefined() || attributeValue.asList().size() == 1;
        }
    };
    private static final AttributeConverter CONVERT_CONNECTOR_REF = new AttributeConverter.DefaultAttributeConverter(){

        protected void convertAttribute(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
            ModelNode model = context.readResource(PathAddress.EMPTY_ADDRESS).getModel();
            if (model.hasDefined("connectors")) {
                attributeValue.set(((ModelNode)model.get("connectors").asList().get(0)).asString());
            }
        }
    };

    public String getSubsystemName() {
        return "ejb3";
    }

    public void registerTransformers(SubsystemTransformerRegistration subsystemRegistration) {
        ModelVersion currentModel = subsystemRegistration.getCurrentSubsystemVersion();
        ChainedTransformationDescriptionBuilder chainedBuilder = TransformationDescriptionBuilder.Factory.createChainedSubystemInstance((ModelVersion)currentModel);
        EJBTransformers.registerTransformers_7_0_0(chainedBuilder.createBuilder(currentModel, EJB3Model.VERSION_7_0_0.getVersion()));
        EJBTransformers.registerTransformers_6_0_0(chainedBuilder.createBuilder(EJB3Model.VERSION_7_0_0.getVersion(), EJB3Model.VERSION_6_0_0.getVersion()));
        EJBTransformers.registerTransformers_5_0_0(chainedBuilder.createBuilder(EJB3Model.VERSION_6_0_0.getVersion(), EJB3Model.VERSION_5_0_0.getVersion()));
        EJBTransformers.registerTransformers_4_0_0(chainedBuilder.createBuilder(EJB3Model.VERSION_5_0_0.getVersion(), EJB3Model.VERSION_4_0_0.getVersion()));
        EJBTransformers.registerTransformers_3_0_0(chainedBuilder.createBuilder(EJB3Model.VERSION_4_0_0.getVersion(), EJB3Model.VERSION_3_0_0.getVersion()));
        EJBTransformers.registerTransformers_1_3_0(chainedBuilder.createBuilder(EJB3Model.VERSION_3_0_0.getVersion(), EJB3Model.VERSION_1_3_0.getVersion()));
        EJBTransformers.registerTransformers_1_2_1(chainedBuilder.createBuilder(EJB3Model.VERSION_1_3_0.getVersion(), EJB3Model.VERSION_1_2_1.getVersion()));
        chainedBuilder.buildAndRegister(subsystemRegistration, (ModelVersion[][])new ModelVersion[][]{{EJB3Model.VERSION_7_0_0.getVersion(), EJB3Model.VERSION_6_0_0.getVersion(), EJB3Model.VERSION_5_0_0.getVersion(), EJB3Model.VERSION_4_0_0.getVersion(), EJB3Model.VERSION_3_0_0.getVersion(), EJB3Model.VERSION_1_3_0.getVersion(), EJB3Model.VERSION_1_2_1.getVersion()}});
    }

    private static void registerTransformers_1_2_1(ResourceTransformationDescriptionBuilder subsystemBuilder) {
        DataStoreTransformer dataStoreTransformer = new DataStoreTransformer();
        ResourceTransformationDescriptionBuilder timerService = subsystemBuilder.addChildResource(EJB3SubsystemModel.TIMER_SERVICE_PATH);
        ((AttributeTransformationDescriptionBuilder)timerService.getAttributeBuilder().setDiscard(DiscardAttributeChecker.ALWAYS, new String[]{"default-data-store"})).end();
        timerService.discardOperations(new String[]{"add"});
        timerService.setCustomResourceTransformer((ResourceTransformer)dataStoreTransformer);
        timerService.rejectChildResource(EJB3SubsystemModel.DATABASE_DATA_STORE_PATH);
        ResourceTransformationDescriptionBuilder fileDataStore = timerService.addChildRedirection(EJB3SubsystemModel.FILE_DATA_STORE_PATH, (current, theBuilder) -> theBuilder.getCurrent());
        fileDataStore.addOperationTransformationOverride("add").inheritResourceAttributeDefinitions().setCustomOperationTransformer((OperationTransformer)dataStoreTransformer).end();
    }

    private static void registerTransformers_1_3_0(ResourceTransformationDescriptionBuilder subsystemBuilder) {
        StatefulCacheRefTransformer statefulCacheRefTransformer = new StatefulCacheRefTransformer();
        subsystemBuilder.setCustomResourceTransformer((ResourceTransformer)statefulCacheRefTransformer);
        for (String name : Arrays.asList("write-attribute", "undefine-attribute", "read-attribute")) {
            subsystemBuilder.addOperationTransformationOverride(name).inheritResourceAttributeDefinitions().setCustomOperationTransformer((OperationTransformer)statefulCacheRefTransformer).end();
        }
        subsystemBuilder.addOperationTransformationOverride("add").inheritResourceAttributeDefinitions().setCustomOperationTransformer((OperationTransformer)new AddStatefulCacheRefTransformer()).end();
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)subsystemBuilder.getAttributeBuilder().setDiscard(DiscardAttributeChecker.DEFAULT_VALUE, new AttributeDefinition[]{EJB3SubsystemRootResourceDefinition.LOG_EJB_EXCEPTIONS})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{EJB3SubsystemRootResourceDefinition.LOG_EJB_EXCEPTIONS})).end();
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)subsystemBuilder.getAttributeBuilder().addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{EJB3SubsystemRootResourceDefinition.DISABLE_DEFAULT_EJB_PERMISSIONS})).setDiscard((DiscardAttributeChecker)new DiscardAttributeChecker.DiscardAttributeValueChecker(new ModelNode[]{ModelNode.FALSE}), new AttributeDefinition[]{EJB3SubsystemRootResourceDefinition.DISABLE_DEFAULT_EJB_PERMISSIONS})).end();
        subsystemBuilder.rejectChildResource(PathElement.pathElement((String)"remoting-profile"));
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)subsystemBuilder.addChildRedirection(PassivationStoreResourceDefinition.INSTANCE.getPathElement(), PathElement.pathElement((String)"cluster-passivation-store")).getAttributeBuilder().setValueConverter(AttributeConverter.Factory.createHardCoded((ModelNode)ModelNode.TRUE, (boolean)true), new String[]{"passivate-events-on-replicate"})).setValueConverter(AttributeConverter.Factory.createHardCoded((ModelNode)new ModelNode("default"), (boolean)true), new String[]{"client-mappings-cache"})).setValueConverter(AttributeConverter.Factory.createHardCoded((ModelNode)new ModelNode().set(Long.valueOf(Integer.MAX_VALUE).longValue()), (boolean)true), new String[]{"idle-timeout"})).setValueConverter(AttributeConverter.Factory.createHardCoded((ModelNode)new ModelNode().set(TimeUnit.SECONDS.name()), (boolean)true), new String[]{"idle-timeout-unit"})).end();
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)subsystemBuilder.addChildResource(EJB3SubsystemModel.TIMER_SERVICE_PATH).addChildResource(EJB3SubsystemModel.DATABASE_DATA_STORE_PATH).getAttributeBuilder().setDiscard(DiscardAttributeChecker.DEFAULT_VALUE, new String[]{"refresh-interval", "allow-execution"})).addRejectCheck(RejectAttributeChecker.DEFINED, new String[]{"refresh-interval", "allow-execution"})).end();
    }

    private static void registerTransformers_3_0_0(ResourceTransformationDescriptionBuilder subsystemBuilder) {
        ((AttributeTransformationDescriptionBuilder)subsystemBuilder.getAttributeBuilder().setValueConverter(AttributeConverter.Factory.createHardCoded((ModelNode)new ModelNode("hornetq-ra"), (boolean)true), new AttributeDefinition[]{EJB3SubsystemRootResourceDefinition.DEFAULT_RESOURCE_ADAPTER_NAME})).end();
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)subsystemBuilder.addChildResource(EJB3SubsystemModel.REMOTE_SERVICE_PATH).getAttributeBuilder().setDiscard(DiscardAttributeChecker.DEFAULT_VALUE, new String[]{"cluster"})).addRejectCheck(RejectAttributeChecker.DEFINED, new String[]{"cluster"})).setDiscard(DiscardAttributeChecker.ALWAYS, new String[]{"execute-in-worker"})).end();
        subsystemBuilder.rejectChildResource(PathElement.pathElement((String)"mdb-delivery-group"));
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)subsystemBuilder.addChildResource(PathElement.pathElement((String)"strict-max-bean-instance-pool")).getAttributeBuilder().setDiscard((DiscardAttributeChecker)new DiscardAttributeChecker.DiscardAttributeValueChecker(new ModelNode[]{new ModelNode(StrictMaxPoolResourceDefinition.DeriveSize.NONE.toString())}), new AttributeDefinition[]{StrictMaxPoolResourceDefinition.DERIVE_SIZE})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{StrictMaxPoolResourceDefinition.DERIVE_SIZE})).end();
    }

    private static void registerTransformers_4_0_0(ResourceTransformationDescriptionBuilder subsystemBuilder) {
        subsystemBuilder.rejectChildResource(PathElement.pathElement((String)"application-security-domain"));
        subsystemBuilder.rejectChildResource(EJB3SubsystemModel.IDENTITY_PATH);
        ((AttributeTransformationDescriptionBuilder)subsystemBuilder.addChildResource((ResourceDefinition)RemotingProfileResourceDefinition.INSTANCE).getAttributeBuilder().addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{StaticEJBDiscoveryDefinition.INSTANCE})).end();
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)subsystemBuilder.getAttributeBuilder().setDiscard(DiscardAttributeChecker.DEFAULT_VALUE, new AttributeDefinition[]{EJB3SubsystemRootResourceDefinition.ALLOW_EJB_NAME_REGEX})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{EJB3SubsystemRootResourceDefinition.ALLOW_EJB_NAME_REGEX})).end();
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)subsystemBuilder.getAttributeBuilder().setDiscard(DiscardAttributeChecker.DEFAULT_VALUE, new AttributeDefinition[]{EJB3SubsystemRootResourceDefinition.ENABLE_GRACEFUL_TXN_SHUTDOWN})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{EJB3SubsystemRootResourceDefinition.ENABLE_GRACEFUL_TXN_SHUTDOWN})).end();
        ((AttributeTransformationDescriptionBuilder)subsystemBuilder.getAttributeBuilder().addRename("statistics-enabled", "enable-statistics")).end();
        ((AttributeTransformationDescriptionBuilder)subsystemBuilder.getAttributeBuilder().setValueConverter(AttributeConverter.Factory.createHardCoded((ModelNode)ModelNode.TRUE, (boolean)true), new AttributeDefinition[]{EJB3SubsystemRootResourceDefinition.LOG_EJB_EXCEPTIONS})).end();
    }

    private static void registerTransformers_5_0_0(ResourceTransformationDescriptionBuilder subsystemBuilder) {
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)subsystemBuilder.getAttributeBuilder().setDiscard(DiscardAttributeChecker.UNDEFINED, new AttributeDefinition[]{EJB3SubsystemRootResourceDefinition.CLIENT_INTERCEPTORS, EJB3SubsystemRootResourceDefinition.SERVER_INTERCEPTORS})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{EJB3SubsystemRootResourceDefinition.CLIENT_INTERCEPTORS, EJB3SubsystemRootResourceDefinition.SERVER_INTERCEPTORS})).end();
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)subsystemBuilder.addChildResource(PathElement.pathElement((String)"thread-pool")).getAttributeBuilder().setDiscard(DiscardAttributeChecker.UNDEFINED, new AttributeDefinition[]{PoolAttributeDefinitions.CORE_THREADS})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{PoolAttributeDefinitions.CORE_THREADS})).end();
    }

    private static void registerTransformers_6_0_0(ResourceTransformationDescriptionBuilder subsystemBuilder) {
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)subsystemBuilder.getAttributeBuilder().setDiscard(DiscardAttributeChecker.UNDEFINED, new AttributeDefinition[]{EJB3SubsystemRootResourceDefinition.DEFAULT_STATEFUL_BEAN_SESSION_TIMEOUT})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{EJB3SubsystemRootResourceDefinition.DEFAULT_STATEFUL_BEAN_SESSION_TIMEOUT})).end();
    }

    private static void registerTransformers_7_0_0(ResourceTransformationDescriptionBuilder subsystemBuilder) {
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)subsystemBuilder.addChildResource(EJB3SubsystemModel.REMOTE_SERVICE_PATH).getAttributeBuilder().setDiscard(DISCARD_SINGLETON_LIST, new AttributeDefinition[]{EJB3RemoteResourceDefinition.CONNECTORS})).addRejectCheck(REJECT_NON_SINGLETON_LIST, new AttributeDefinition[]{EJB3RemoteResourceDefinition.CONNECTORS})).setValueConverter(CONVERT_CONNECTOR_REF, new String[]{"connector-ref"})).end();
    }

    private static class AddStatefulCacheRefTransformer
    implements OperationTransformer {
        private AddStatefulCacheRefTransformer() {
        }

        public OperationTransformer.TransformedOperation transformOperation(TransformationContext context, PathAddress address, ModelNode operation) {
            if (!(operation == null || operation.hasDefined("operation-headers") && operation.get(new String[]{"operation-headers", "push-to-servers"}).asBoolean(false))) {
                operation = operation.clone();
                String statefulCache = operation.get("default-sfsb-cache").asString();
                String statefulPassivationDisabledCache = operation.get("default-sfsb-passivation-disabled-cache").asString();
                operation.get("default-sfsb-cache").set(statefulPassivationDisabledCache);
                operation.get("default-clustered-sfsb-cache").set(statefulCache);
                operation.remove("default-sfsb-passivation-disabled-cache");
            }
            return new OperationTransformer.TransformedOperation(operation, OperationResultTransformer.ORIGINAL_RESULT);
        }
    }

    private static class StatefulCacheRefTransformer
    implements CombinedTransformer {
        private final Map<String, String> renames = new HashMap<String, String>();

        public StatefulCacheRefTransformer() {
            this.renames.put("default-sfsb-cache", "default-clustered-sfsb-cache");
            this.renames.put("default-sfsb-passivation-disabled-cache", "default-sfsb-cache");
        }

        public OperationTransformer.TransformedOperation transformOperation(TransformationContext context, PathAddress address, ModelNode operation) {
            String originalAttribute;
            if (!(operation == null || operation.hasDefined("operation-headers") && operation.get(new String[]{"operation-headers", "push-to-servers"}).asBoolean(false) || !this.renames.containsKey(originalAttribute = Operations.getAttributeName((ModelNode)operation)))) {
                operation = operation.clone();
                operation.get("name").set(this.renames.get(originalAttribute));
            }
            return new OperationTransformer.TransformedOperation(operation, OperationResultTransformer.ORIGINAL_RESULT);
        }

        public void transformResource(ResourceTransformationContext context, PathAddress address, Resource resource) throws OperationFailedException {
            Resource untransformedResource = context.readResource(PathAddress.EMPTY_ADDRESS);
            ModelNode untransformedModel = Resource.Tools.readModel((Resource)untransformedResource);
            String statefulCache = untransformedModel.get("default-sfsb-cache").asString();
            String statefulPassivationDisabledCache = untransformedModel.get("default-sfsb-passivation-disabled-cache").asString();
            ModelNode transformed = resource.getModel();
            transformed.get("default-sfsb-cache").set(statefulPassivationDisabledCache);
            transformed.get("default-clustered-sfsb-cache").set(statefulCache);
            transformed.remove("default-sfsb-passivation-disabled-cache");
            ResourceTransformationContext childContext = context.addTransformedResource(PathAddress.EMPTY_ADDRESS, resource);
            childContext.processChildren(resource);
        }
    }

    private static class DataStoreTransformer
    implements CombinedTransformer {
        private DataStoreTransformer() {
        }

        public OperationTransformer.TransformedOperation transformOperation(final TransformationContext context, final PathAddress address, final ModelNode operation) throws OperationFailedException {
            Resource original = context.readResourceFromRoot(address);
            String defaultDataStore = original.getModel().get(TimerServiceResourceDefinition.DEFAULT_DATA_STORE.getName()).asString();
            boolean hasFileDataStore = original.hasChild(PathElement.pathElement((String)EJB3SubsystemModel.FILE_DATA_STORE_PATH.getKey(), (String)defaultDataStore));
            if (original.getChildren("file-data-store").size() > 1 || !hasFileDataStore) {
                return new OperationTransformer.TransformedOperation(operation, new OperationRejectionPolicy(){

                    public boolean rejectOperation(ModelNode preparedResult) {
                        return true;
                    }

                    public String getFailureDescription() {
                        return context.getLogger().getRejectedResourceWarning(address, operation);
                    }
                }, OperationResultTransformer.ORIGINAL_RESULT);
            }
            operation.get(TimerServiceResourceDefinition.THREAD_POOL_NAME.getName()).set(original.getModel().get(TimerServiceResourceDefinition.THREAD_POOL_NAME.getName()));
            return new OperationTransformer.TransformedOperation(operation, OperationResultTransformer.ORIGINAL_RESULT);
        }

        public void transformResource(ResourceTransformationContext context, PathAddress address, Resource resource) throws OperationFailedException {
            Resource untransformedResource = context.readResource(PathAddress.EMPTY_ADDRESS);
            ModelNode untransformedModel = Resource.Tools.readModel((Resource)untransformedResource);
            String defaultDataStore = untransformedModel.get(TimerServiceResourceDefinition.DEFAULT_DATA_STORE.getName()).asString();
            ModelNode transformed = resource.getModel();
            transformed.remove(TimerServiceResourceDefinition.DEFAULT_DATA_STORE.getName());
            ModelNode fileStore = untransformedModel.get(new String[]{"file-data-store", defaultDataStore});
            if (!fileStore.isDefined()) {
                this.rejectIncompatibleDataStores(context, address);
            } else if (untransformedModel.hasDefined("database-data-store") && untransformedModel.get("database-data-store").keys().size() > 0 || untransformedModel.get("file-data-store").keys().size() > 1) {
                this.rejectIncompatibleDataStores(context, address);
            }
            ModelNode path = fileStore.get("path");
            transformed.get("path").set(path);
            transformed.get("relative-to").set(fileStore.get("relative-to"));
            context.addTransformedResource(PathAddress.EMPTY_ADDRESS, resource);
        }

        private void rejectIncompatibleDataStores(ResourceTransformationContext context, PathAddress address) throws OperationFailedException {
            throw new OperationFailedException(EjbLogger.ROOT_LOGGER.untransformableTimerService(address));
        }
    }
}

