/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.StreamCorruptedException;
import java.nio.charset.StandardCharsets;
import java.util.OptionalInt;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.RawProtoStreamReader;
import org.infinispan.protostream.RawProtoStreamWriter;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoadException;
import org.wildfly.clustering.marshalling.protostream.Predictable;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;

public enum ModuleMarshaller implements ProtoStreamMarshaller<Module>
{
    INSTANCE;


    public Module readFrom(ImmutableSerializationContext context, RawProtoStreamReader reader) throws IOException {
        String moduleName = new String(reader.readByteArray(), StandardCharsets.UTF_8);
        if (reader.readTag() != 0) {
            throw new StreamCorruptedException();
        }
        try {
            return Module.getBootModuleLoader().loadModule(moduleName);
        }
        catch (ModuleLoadException e) {
            InvalidObjectException exception = new InvalidObjectException(e.getMessage());
            exception.initCause(e);
            throw exception;
        }
    }

    public void writeTo(ImmutableSerializationContext context, RawProtoStreamWriter writer, Module module) throws IOException {
        byte[] name = module.getName().getBytes(StandardCharsets.UTF_8);
        writer.writeUInt32NoTag(name.length);
        writer.writeRawBytes(name, 0, name.length);
    }

    @Override
    public OptionalInt size(ImmutableSerializationContext context, Module value) {
        return OptionalInt.of(Predictable.stringSize(value.getName()));
    }

    public Class<? extends Module> getJavaClass() {
        return Module.class;
    }
}

