/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.client;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import org.jboss.dmr.ModelNode;

public interface OperationResponse
extends Closeable {
    public ModelNode getResponseNode();

    public List<StreamEntry> getInputStreams();

    public StreamEntry getInputStream(String var1);

    @Override
    public void close() throws IOException;

    public static class Factory {
        public static OperationResponse createSimple(final ModelNode responseNode) {
            return new OperationResponse(){

                @Override
                public ModelNode getResponseNode() {
                    return responseNode;
                }

                @Override
                public List<StreamEntry> getInputStreams() {
                    return Collections.emptyList();
                }

                @Override
                public StreamEntry getInputStream(String uuid) {
                    return null;
                }

                @Override
                public void close() throws IOException {
                }
            };
        }
    }

    public static interface StreamEntry
    extends Closeable {
        public String getUUID();

        public String getMimeType();

        public InputStream getStream();

        @Override
        public void close() throws IOException;
    }
}

