/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.configuration;

import java.util.Arrays;
import java.util.List;
import org.infinispan.commons.configuration.ConfigurationInfo;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.elements.DefaultElementDefinition;
import org.infinispan.commons.configuration.elements.ElementDefinition;
import org.infinispan.configuration.cache.AbstractStoreConfiguration;
import org.infinispan.persistence.jdbc.configuration.DataColumnConfiguration;
import org.infinispan.persistence.jdbc.configuration.Element;
import org.infinispan.persistence.jdbc.configuration.IdColumnConfiguration;
import org.infinispan.persistence.jdbc.configuration.SegmentColumnConfiguration;
import org.infinispan.persistence.jdbc.configuration.TimestampColumnConfiguration;

public class TableManipulationConfiguration
implements ConfigurationInfo {
    public static final AttributeDefinition<String> TABLE_NAME_PREFIX = AttributeDefinition.builder((String)"tableNamePrefix", null, String.class).xmlName("prefix").immutable().build();
    public static final AttributeDefinition<String> CACHE_NAME = AttributeDefinition.builder((String)"cacheName", null, String.class).immutable().build();
    public static final AttributeDefinition<Integer> BATCH_SIZE = AttributeDefinition.builder((String)"batchSize", (Object)((Integer)AbstractStoreConfiguration.MAX_BATCH_SIZE.getDefaultValue())).immutable().build();
    public static final AttributeDefinition<Integer> FETCH_SIZE = AttributeDefinition.builder((String)"fetchSize", (Object)100).immutable().build();
    public static final AttributeDefinition<Boolean> CREATE_ON_START = AttributeDefinition.builder((String)"createOnStart", (Object)true).immutable().build();
    public static final AttributeDefinition<Boolean> DROP_ON_EXIT = AttributeDefinition.builder((String)"dropOnExit", (Object)false).immutable().build();
    static ElementDefinition ELEMENT_DEFINITION = new DefaultElementDefinition(Element.STRING_KEYED_TABLE.getLocalName());
    private final Attribute<String> tableNamePrefix;
    private final Attribute<String> cacheName;
    private final Attribute<Integer> batchSize;
    private final Attribute<Integer> fetchSize;
    private final Attribute<Boolean> createOnStart;
    private final Attribute<Boolean> dropOnExit;
    private final AttributeSet attributes;
    private final IdColumnConfiguration idColumn;
    private final DataColumnConfiguration dataColumn;
    private final TimestampColumnConfiguration timeStamp;
    private final SegmentColumnConfiguration segmentColumn;
    private List<ConfigurationInfo> subElements;

    static AttributeSet attributeSet() {
        return new AttributeSet(TableManipulationConfiguration.class, new AttributeDefinition[]{TABLE_NAME_PREFIX, CACHE_NAME, BATCH_SIZE, FETCH_SIZE, CREATE_ON_START, DROP_ON_EXIT});
    }

    TableManipulationConfiguration(AttributeSet attributes, IdColumnConfiguration idColumn, DataColumnConfiguration dataColumn, TimestampColumnConfiguration timestampColumn, SegmentColumnConfiguration segmentColumn) {
        this.attributes = attributes.checkProtection();
        this.tableNamePrefix = attributes.attribute(TABLE_NAME_PREFIX);
        this.cacheName = attributes.attribute(CACHE_NAME);
        this.batchSize = attributes.attribute(BATCH_SIZE);
        this.fetchSize = attributes.attribute(FETCH_SIZE);
        this.createOnStart = attributes.attribute(CREATE_ON_START);
        this.dropOnExit = attributes.attribute(DROP_ON_EXIT);
        this.idColumn = idColumn;
        this.dataColumn = dataColumn;
        this.timeStamp = timestampColumn;
        this.segmentColumn = segmentColumn;
        this.subElements = Arrays.asList(idColumn, dataColumn, timestampColumn, segmentColumn);
    }

    public ElementDefinition getElementDefinition() {
        return ELEMENT_DEFINITION;
    }

    public List<ConfigurationInfo> subElements() {
        return this.subElements;
    }

    public boolean createOnStart() {
        return (Boolean)this.createOnStart.get();
    }

    public boolean dropOnExit() {
        return (Boolean)this.dropOnExit.get();
    }

    public String idColumnName() {
        return this.idColumn.idColumnName();
    }

    public String idColumnType() {
        return this.idColumn.idColumnType();
    }

    public String tableNamePrefix() {
        return (String)this.tableNamePrefix.get();
    }

    public String cacheName() {
        return (String)this.cacheName.get();
    }

    public String dataColumnName() {
        return this.dataColumn.dataColumnName();
    }

    public String dataColumnType() {
        return this.dataColumn.dataColumnType();
    }

    public String timestampColumnName() {
        return this.timeStamp.dataColumnName();
    }

    public String timestampColumnType() {
        return this.timeStamp.dataColumnType();
    }

    public String segmentColumnName() {
        return this.segmentColumn.segmentColumnName();
    }

    public String segmentColumnType() {
        return this.segmentColumn.segmentColumnType();
    }

    public int fetchSize() {
        return (Integer)this.fetchSize.get();
    }

    @Deprecated
    public int batchSize() {
        return (Integer)this.batchSize.get();
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public IdColumnConfiguration idColumnConfiguration() {
        return this.idColumn;
    }

    public DataColumnConfiguration dataColumnConfiguration() {
        return this.dataColumn;
    }

    public TimestampColumnConfiguration timeStampColumnConfiguration() {
        return this.timeStamp;
    }

    public SegmentColumnConfiguration segmentColumnConfiguration() {
        return this.segmentColumn;
    }

    public String toString() {
        return "TableManipulationConfiguration [attributes=" + this.attributes + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attributes == null ? 0 : this.attributes.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TableManipulationConfiguration other = (TableManipulationConfiguration)obj;
        return !(this.attributes == null ? other.attributes != null : !this.attributes.equals((Object)other.attributes));
    }
}

