/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.opentracing;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.transform.ExtensionTransformerRegistration;
import org.jboss.as.controller.transform.SubsystemTransformerRegistration;
import org.jboss.as.controller.transform.description.AttributeTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.ChainedTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.DiscardAttributeChecker;
import org.jboss.as.controller.transform.description.RejectAttributeChecker;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.TransformationDescriptionBuilder;
import org.wildfly.extension.microprofile.opentracing.JaegerTracerConfigurationDefinition;
import org.wildfly.extension.microprofile.opentracing.SubsystemDefinition;
import org.wildfly.extension.microprofile.opentracing.SubsystemExtension;
import org.wildfly.extension.microprofile.opentracing.TracerAttributes;

public class OpentracingTransformers
implements ExtensionTransformerRegistration {
    public String getSubsystemName() {
        return "microprofile-opentracing-smallrye";
    }

    public void registerTransformers(SubsystemTransformerRegistration registration) {
        ChainedTransformationDescriptionBuilder builder = TransformationDescriptionBuilder.Factory.createChainedSubystemInstance((ModelVersion)registration.getCurrentSubsystemVersion());
        OpentracingTransformers.registerTransformers_WF_20(builder.createBuilder(SubsystemExtension.VERSION_3_0_0, SubsystemExtension.VERSION_2_0_0));
        OpentracingTransformers.registerTransformers_WF_19(builder.createBuilder(SubsystemExtension.VERSION_2_0_0, SubsystemExtension.VERSION_1_0_0));
        builder.buildAndRegister(registration, (ModelVersion[][])new ModelVersion[][]{{SubsystemExtension.VERSION_3_0_0, SubsystemExtension.VERSION_2_0_0, SubsystemExtension.VERSION_1_0_0}});
    }

    private static void registerTransformers_WF_20(ResourceTransformationDescriptionBuilder subsystem) {
        ((AttributeTransformationDescriptionBuilder)subsystem.addChildResource(JaegerTracerConfigurationDefinition.TRACER_CONFIGURATION_PATH).getAttributeBuilder().addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, new AttributeDefinition[]{TracerAttributes.PROPAGATION, TracerAttributes.SAMPLER_TYPE, TracerAttributes.SAMPLER_PARAM, TracerAttributes.SAMPLER_MANAGER_HOST_PORT, TracerAttributes.SENDER_BINDING, TracerAttributes.SENDER_ENDPOINT, TracerAttributes.SENDER_AUTH_TOKEN, TracerAttributes.SENDER_AUTH_USER, TracerAttributes.SENDER_AUTH_PASSWORD, TracerAttributes.REPORTER_LOG_SPANS, TracerAttributes.REPORTER_FLUSH_INTERVAL, TracerAttributes.REPORTER_MAX_QUEUE_SIZE, TracerAttributes.TRACER_TAGS, TracerAttributes.TRACEID_128BIT})).end();
    }

    private static void registerTransformers_WF_19(ResourceTransformationDescriptionBuilder subsystem) {
        subsystem.rejectChildResource(JaegerTracerConfigurationDefinition.TRACER_CONFIGURATION_PATH);
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)subsystem.getAttributeBuilder().addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{SubsystemDefinition.DEFAULT_TRACER})).setDiscard(DiscardAttributeChecker.UNDEFINED, new AttributeDefinition[]{SubsystemDefinition.DEFAULT_TRACER})).end();
    }
}

