/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.singleton;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import org.wildfly.clustering.group.Node;
import org.wildfly.clustering.marshalling.Externalizer;
import org.wildfly.clustering.marshalling.spi.IndexSerializer;
import org.wildfly.clustering.server.singleton.SingletonElectionCommand;

public class SingletonElectionCommandExternalizer
implements Externalizer<SingletonElectionCommand> {
    public void writeObject(ObjectOutput output, SingletonElectionCommand command) throws IOException {
        List<Node> candidates = command.getCandidates();
        Integer index = command.getIndex();
        IndexSerializer.VARIABLE.writeInt((DataOutput)output, candidates.size());
        for (Node candidate : candidates) {
            output.writeObject(candidate);
        }
        IndexSerializer.select((int)(candidates.size() + 1)).writeInt((DataOutput)output, index != null ? index.intValue() : candidates.size());
    }

    public SingletonElectionCommand readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        int size = IndexSerializer.VARIABLE.readInt((DataInput)input);
        ArrayList<Node> candidates = new ArrayList<Node>(size);
        for (int i = 0; i < size; ++i) {
            candidates.add((Node)input.readObject());
        }
        int index = IndexSerializer.select((int)(size + 1)).readInt((DataInput)input);
        return new SingletonElectionCommand(candidates, index != size ? Integer.valueOf(index) : null);
    }

    public Class<SingletonElectionCommand> getTargetClass() {
        return SingletonElectionCommand.class;
    }
}

