/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.ssl;

import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLSession;
import org.xnio.Bits;
import org.xnio.Buffers;
import org.xnio.Pool;
import org.xnio.Pooled;
import org.xnio.XnioIoThread;
import org.xnio.XnioWorker;
import org.xnio._private.Messages;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.conduits.ConduitReadableByteChannel;
import org.xnio.conduits.ConduitWritableByteChannel;
import org.xnio.conduits.Conduits;
import org.xnio.conduits.ReadReadyHandler;
import org.xnio.conduits.StreamSinkConduit;
import org.xnio.conduits.StreamSourceConduit;
import org.xnio.conduits.WriteReadyHandler;
import org.xnio.ssl.JsseSslConnection;

final class JsseStreamConduit
implements StreamSourceConduit,
StreamSinkConduit,
Runnable {
    private static final boolean TRACE_SSL = Boolean.getBoolean("org.xnio.ssl.TRACE_SSL");
    private final JsseSslConnection connection;
    private final SSLEngine engine;
    private final StreamSourceConduit sourceConduit;
    private final StreamSinkConduit sinkConduit;
    private final Pooled<ByteBuffer> receiveBuffer;
    private final Pooled<ByteBuffer> sendBuffer;
    private final Pooled<ByteBuffer> readBuffer;
    private int state = 262144;
    private int tasks;
    private ReadReadyHandler readReadyHandler;
    private WriteReadyHandler writeReadyHandler;
    private static final int FLAG_TLS = 131072;
    private static final int FLAG_INLINE_TASKS = 262144;
    private static final int FLAG_TASK_QUEUED = 524288;
    private static final int FLAG_NEED_ENGINE_TASK = 0x100000;
    private static final int FLAG_FLUSH_NEEDED = 0x200000;
    private static final int READ_FLAG_SHUTDOWN = 1;
    private static final int READ_FLAG_EOF = 2;
    private static final int READ_FLAG_RESUMED = 4;
    private static final int READ_FLAG_UP_RESUMED = 8;
    private static final int READ_FLAG_WAKEUP = 16;
    private static final int READ_FLAG_READY = 32;
    private static final int READ_FLAG_NEEDS_WRITE = 64;
    private static final int WRITE_FLAG_SHUTDOWN = 256;
    private static final int WRITE_FLAG_SHUTDOWN2 = 512;
    private static final int WRITE_FLAG_SHUTDOWN3 = 1024;
    private static final int WRITE_FLAG_FINISHED = 2048;
    private static final int WRITE_FLAG_RESUMED = 4096;
    private static final int WRITE_FLAG_UP_RESUMED = 8192;
    private static final int WRITE_FLAG_WAKEUP = 16384;
    private static final int WRITE_FLAG_READY = 32768;
    private static final int WRITE_FLAG_NEEDS_READ = 65536;
    private final WriteReadyHandler writeReady = new WriteReadyHandler(){

        @Override
        public void forceTermination() {
            WriteReadyHandler writeReadyHandler;
            if (Bits.anyAreClear(JsseStreamConduit.this.state, 2048)) {
                JsseStreamConduit.this.state = JsseStreamConduit.this.state | 0xF00;
            }
            if ((writeReadyHandler = JsseStreamConduit.this.writeReadyHandler) != null) {
                try {
                    writeReadyHandler.forceTermination();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        @Override
        public void terminated() {
            WriteReadyHandler writeReadyHandler;
            if (Bits.anyAreClear(JsseStreamConduit.this.state, 2048)) {
                JsseStreamConduit.this.state = JsseStreamConduit.this.state | 0xF00;
            }
            if ((writeReadyHandler = JsseStreamConduit.this.writeReadyHandler) != null) {
                try {
                    writeReadyHandler.terminated();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        @Override
        public void writeReady() {
            JsseStreamConduit.this.writeReady();
        }
    };
    private final ReadReadyHandler readReady = new ReadReadyHandler(){

        @Override
        public void forceTermination() {
            ReadReadyHandler readReadyHandler;
            if (Bits.anyAreClear(JsseStreamConduit.this.state, 1)) {
                JsseStreamConduit.this.state = JsseStreamConduit.this.state | 1;
            }
            if ((readReadyHandler = JsseStreamConduit.this.readReadyHandler) != null) {
                try {
                    readReadyHandler.forceTermination();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        @Override
        public void terminated() {
            ReadReadyHandler readReadyHandler;
            if (Bits.anyAreClear(JsseStreamConduit.this.state, 1)) {
                JsseStreamConduit.this.state = JsseStreamConduit.this.state | 1;
            }
            if ((readReadyHandler = JsseStreamConduit.this.readReadyHandler) != null) {
                try {
                    readReadyHandler.terminated();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        @Override
        public void readReady() {
            JsseStreamConduit.this.readReady();
        }
    };
    private final ByteBuffer[] readBufferHolder = new ByteBuffer[1];
    private final ByteBuffer[] writeBufferHolder = new ByteBuffer[1];
    private static final ByteBuffer[] NO_BUFFERS = new ByteBuffer[0];
    private static final int IO_GOAL_READ = 0;
    private static final int IO_GOAL_WRITE = 1;
    private static final int IO_GOAL_FLUSH = 2;
    private static final int IO_GOAL_WRITE_FINAL = 3;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JsseStreamConduit(JsseSslConnection connection, SSLEngine engine, StreamSourceConduit sourceConduit, StreamSinkConduit sinkConduit, Pool<ByteBuffer> socketBufferPool, Pool<ByteBuffer> applicationBufferPool) {
        Pooled<ByteBuffer> readBuffer;
        Pooled<ByteBuffer> sendBuffer;
        boolean ok = false;
        SSLSession session = engine.getSession();
        int packetBufferSize = session.getPacketBufferSize();
        Pooled<ByteBuffer> receiveBuffer = socketBufferPool.allocate();
        try {
            receiveBuffer.getResource().flip();
            sendBuffer = socketBufferPool.allocate();
            try {
                if (receiveBuffer.getResource().capacity() < packetBufferSize || sendBuffer.getResource().capacity() < packetBufferSize) {
                    throw Messages.msg.socketBufferTooSmall();
                }
                int applicationBufferSize = session.getApplicationBufferSize();
                readBuffer = applicationBufferPool.allocate();
                try {
                    if (readBuffer.getResource().capacity() < applicationBufferSize) {
                        throw Messages.msg.appBufferTooSmall();
                    }
                    ok = true;
                }
                finally {
                    if (!ok) {
                        readBuffer.free();
                    }
                }
            }
            finally {
                if (!ok) {
                    sendBuffer.free();
                }
            }
        }
        finally {
            if (!ok) {
                receiveBuffer.free();
            }
        }
        this.receiveBuffer = receiveBuffer;
        this.sendBuffer = sendBuffer;
        this.readBuffer = readBuffer;
        receiveBuffer.getResource().clear().limit(0);
        if (sourceConduit.getReadThread() != sinkConduit.getWriteThread()) {
            throw new IllegalArgumentException("Source and sink thread mismatch");
        }
        this.connection = connection;
        this.engine = engine;
        this.sourceConduit = sourceConduit;
        this.sinkConduit = sinkConduit;
        sourceConduit.setReadReadyHandler(this.readReady);
        sinkConduit.setWriteReadyHandler(this.writeReady);
    }

    public String getStatus() {
        StringBuilder b = new StringBuilder();
        b.append("General flags:");
        int state = this.state;
        if (Bits.allAreSet(state, 131072)) {
            b.append(" TLS");
        }
        if (Bits.allAreSet(state, 262144)) {
            b.append(" INLINE_TASKS");
        }
        if (Bits.allAreSet(state, 524288)) {
            b.append(" TASK_QUEUED");
        }
        if (Bits.allAreSet(state, 0x100000)) {
            b.append(" NEED_ENGINE_TASK");
        }
        if (Bits.allAreSet(state, 0x200000)) {
            b.append(" FLUSH_NEEDED");
        }
        b.append("\nRead flags:");
        if (Bits.allAreSet(state, 1)) {
            b.append(" SHUTDOWN");
        }
        if (Bits.allAreSet(state, 2)) {
            b.append(" EOF");
        }
        if (Bits.allAreSet(state, 4)) {
            b.append(" RESUMED");
        }
        if (Bits.allAreSet(state, 8)) {
            b.append(" UP_RESUMED");
        }
        if (Bits.allAreSet(state, 16)) {
            b.append(" WAKEUP");
        }
        if (Bits.allAreSet(state, 32)) {
            b.append(" READY");
        }
        if (Bits.allAreSet(state, 64)) {
            b.append(" NEEDS_WRITE");
        }
        b.append("\nWrite flags:");
        if (Bits.allAreSet(state, 256)) {
            b.append(" SHUTDOWN");
        }
        if (Bits.allAreSet(state, 512)) {
            b.append(" SHUTDOWN2");
        }
        if (Bits.allAreSet(state, 1024)) {
            b.append(" SHUTDOWN3");
        }
        if (Bits.allAreSet(state, 2048)) {
            b.append(" FINISHED");
        }
        if (Bits.allAreSet(state, 4096)) {
            b.append(" RESUMED");
        }
        if (Bits.allAreSet(state, 8192)) {
            b.append(" UP_RESUMED");
        }
        if (Bits.allAreSet(state, 16384)) {
            b.append(" WAKEUP");
        }
        if (Bits.allAreSet(state, 32768)) {
            b.append(" READY");
        }
        if (Bits.allAreSet(state, 65536)) {
            b.append(" NEEDS_READ");
        }
        b.append('\n');
        return b.toString();
    }

    public String toString() {
        return String.format("JSSE Stream Conduit for %s, status:%n%s", this.connection, this.getStatus());
    }

    @Override
    public XnioWorker getWorker() {
        return this.connection.getIoThread().getWorker();
    }

    @Override
    public XnioIoThread getReadThread() {
        return this.connection.getIoThread();
    }

    @Override
    public XnioIoThread getWriteThread() {
        return this.connection.getIoThread();
    }

    void beginHandshake() throws IOException {
        int state = this.state;
        if (Bits.anyAreSet(state, 258)) {
            throw new ClosedChannelException();
        }
        if (Bits.allAreClear(state, 131072)) {
            this.state = state | 0x20000;
        }
        this.engine.beginHandshake();
    }

    SSLSession getSslSession() {
        return Bits.allAreSet(this.state, 131072) ? this.engine.getSession() : null;
    }

    SSLEngine getEngine() {
        return this.engine;
    }

    boolean isTls() {
        return Bits.allAreSet(this.state, 131072);
    }

    boolean markTerminated() {
        this.readBuffer.free();
        this.receiveBuffer.free();
        this.sendBuffer.free();
        if (Bits.anyAreClear(this.state, 2049)) {
            this.state |= 0xF01;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block44: {
            boolean flagTaskQueued;
            assert (Thread.currentThread() == this.getWriteThread());
            int state = this.state;
            boolean modify = flagTaskQueued = Bits.allAreSet(state, 524288);
            boolean queueTask = false;
            state &= 0xFFF7FFFF;
            try {
                if (Bits.allAreSet(state, 0x100000)) {
                    throw new UnsupportedOperationException();
                }
                if (Bits.anyAreSet(state, 16384) || Bits.allAreSet(state, 36864)) {
                    WriteReadyHandler writeReadyHandler = this.writeReadyHandler;
                    if (Bits.allAreSet(state, 16384)) {
                        state = state & 0xFFFFBFFF | 0x1000;
                        modify = true;
                    }
                    if (writeReadyHandler != null) {
                        if (Bits.allAreSet(state, 4096)) {
                            try {
                                if (modify) {
                                    modify = false;
                                    this.state = state;
                                }
                                writeReadyHandler.writeReady();
                            }
                            catch (Throwable throwable) {
                            }
                            finally {
                                state = this.state & 0xFFF7FFFF;
                                modify = true;
                            }
                            if (Bits.allAreSet(state, 4096)) {
                                if (!Bits.allAreSet(state, 32768) && Bits.allAreSet(state, 65536) && Bits.allAreClear(state, 8)) {
                                    state |= 8;
                                    modify = true;
                                    this.sourceConduit.resumeReads();
                                } else if (Bits.allAreClear(state, 8192)) {
                                    this.sinkConduit.resumeWrites();
                                }
                            }
                        } else if (Bits.allAreClear(state, 68) && Bits.allAreSet(state, 8192)) {
                            state &= 0xFFFFDFFF;
                            modify = true;
                            this.suspendWrites();
                        }
                    } else {
                        modify = true;
                        if (Bits.allAreClear(state &= 0xFFFFEFFF, 68) && Bits.allAreSet(state, 8192)) {
                            state &= 0xFFFFDFFF;
                            modify = true;
                            this.suspendWrites();
                        }
                    }
                }
                if (!Bits.anyAreSet(state, 16) && !Bits.allAreSet(state, 36)) break block44;
                ReadReadyHandler readReadyHandler = this.readReadyHandler;
                if (Bits.allAreSet(state, 16)) {
                    state = state & 0xFFFFFFEF | 4;
                    modify = true;
                }
                if (readReadyHandler != null) {
                    if (Bits.allAreSet(state, 4)) {
                        try {
                            if (modify) {
                                modify = false;
                                this.state = state;
                            }
                            readReadyHandler.readReady();
                        }
                        catch (Throwable throwable) {
                        }
                        finally {
                            state = this.state & 0xFFF7FFFF;
                            modify = true;
                        }
                        if (Bits.allAreSet(state, 4)) {
                            if (Bits.allAreSet(state, 32)) {
                                if (!flagTaskQueued) {
                                    state |= 0x80000;
                                    queueTask = true;
                                    modify = true;
                                }
                            } else if (Bits.allAreSet(state, 64) && Bits.allAreClear(state, 8192)) {
                                state |= 0x2000;
                                modify = true;
                                this.sinkConduit.resumeWrites();
                            } else if (Bits.allAreClear(state, 8)) {
                                this.sourceConduit.resumeReads();
                            }
                        }
                        break block44;
                    }
                    if (Bits.allAreClear(state, 69632) && Bits.allAreSet(state, 8)) {
                        state &= 0xFFFFFFF7;
                        modify = true;
                        this.suspendReads();
                    }
                    break block44;
                }
                modify = true;
                if (Bits.allAreClear(state &= 0xFFFFFFFB, 69632) && Bits.allAreSet(state, 8)) {
                    state &= 0xFFFFFFF7;
                    this.suspendReads();
                }
            }
            finally {
                if (modify) {
                    this.state = state;
                    if (queueTask) {
                        this.getReadThread().execute(this);
                    }
                }
            }
        }
    }

    @Override
    public void setWriteReadyHandler(WriteReadyHandler handler) {
        this.writeReadyHandler = handler;
    }

    @Override
    public void setReadReadyHandler(ReadReadyHandler handler) {
        this.readReadyHandler = handler;
    }

    public void writeReady() {
        int state = this.state;
        if (Bits.allAreSet(state |= 0x8000, 64)) {
            state |= 0x20;
        }
        this.state = state;
        if (Bits.allAreClear(state, 524288)) {
            this.run();
        }
        state = this.state;
        if (this.sinkConduit.isWriteResumed() && Bits.allAreClear(state, 4160)) {
            this.sinkConduit.suspendWrites();
        }
        if (this.sourceConduit.isReadResumed() && Bits.allAreClear(state, 65540)) {
            this.sourceConduit.suspendReads();
        }
    }

    public void readReady() {
        int state = this.state;
        if (Bits.allAreSet(state |= 0x20, 65536)) {
            state |= 0x8000;
        }
        this.state = state;
        if (Bits.allAreClear(state, 524288)) {
            this.run();
        }
        state = this.state;
        if (this.sourceConduit.isReadResumed() && Bits.allAreClear(state, 65540)) {
            this.sourceConduit.suspendReads();
        }
        if (this.sinkConduit.isWriteResumed() && Bits.allAreClear(state, 4160)) {
            this.sinkConduit.suspendWrites();
        }
    }

    @Override
    public void suspendWrites() {
        int state = this.state;
        try {
            if (Bits.allAreSet(state, 4096)) {
                if (Bits.allAreSet(state &= 0xFFFFEFFF, 8192) && Bits.allAreClear(state, 64)) {
                    state &= 0xFFFFDFFF;
                    this.sinkConduit.suspendWrites();
                }
                if (Bits.allAreSet(state, 8) && Bits.allAreClear(state, 4)) {
                    state &= 0xFFFFFFF7;
                    this.sourceConduit.suspendReads();
                }
            }
        }
        finally {
            this.state = state;
        }
    }

    @Override
    public void resumeWrites() {
        int state = this.state;
        if (Bits.allAreClear(state, 4096)) {
            if (Bits.allAreSet(state, 2048)) {
                this.wakeupWrites();
                return;
            }
            boolean queueTask = false;
            try {
                if (Bits.allAreSet(state |= 0x1000, 32768)) {
                    queueTask = Bits.allAreClear(state, 524288);
                    if (queueTask) {
                        state |= 0x80000;
                    }
                } else if (Bits.allAreSet(state, 65536) && Bits.allAreClear(state, 8)) {
                    state |= 8;
                    this.sourceConduit.resumeReads();
                } else if (Bits.allAreClear(state, 8192)) {
                    state |= 0x2000;
                    this.sinkConduit.resumeWrites();
                }
            }
            finally {
                this.state = state;
                if (queueTask) {
                    this.getReadThread().execute(this);
                }
            }
        }
    }

    @Override
    public void wakeupWrites() {
        int state = this.state;
        if (Bits.allAreClear(state, 16384)) {
            if (Bits.allAreClear(state, 524288)) {
                this.state = state | 0x4000 | 0x80000;
                this.getReadThread().execute(this);
            } else {
                this.state = state | 0x4000;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void terminateWrites() throws IOException {
        int state = this.state;
        if (!Bits.allAreClear(state, 2048)) return;
        this.state = state | 0x100;
        if (Bits.allAreSet(state, 131072)) {
            try {
                if (this.engine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
                    this.engine.closeOutbound();
                }
                this.performIO(2, NO_BUFFERS, 0, 0, NO_BUFFERS, 0, 0);
                if (!Bits.allAreSet(this.state, 2048)) return;
                this.sinkConduit.terminateWrites();
                return;
            }
            catch (Throwable t) {
                this.state |= 0x800;
                try {
                    this.sinkConduit.truncateWrites();
                    throw t;
                }
                catch (Throwable t2) {
                    t.addSuppressed(t2);
                }
                throw t;
            }
        }
        this.sinkConduit.terminateWrites();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void truncateWrites() throws IOException {
        block10: {
            int state = this.state;
            if (Bits.allAreClear(state, 256)) {
                if (Bits.allAreSet(state, 131072)) {
                    try {
                        state |= 0xD00;
                        try {
                            this.engine.closeOutbound();
                            break block10;
                        }
                        finally {
                            this.sinkConduit.truncateWrites();
                        }
                    }
                    finally {
                        this.state = state;
                    }
                }
                this.state = state | 0x100 | 0x400 | 0x800;
                this.sinkConduit.truncateWrites();
            }
        }
    }

    @Override
    public boolean isWriteResumed() {
        return Bits.anyAreSet(this.state, 20480);
    }

    @Override
    public boolean isWriteShutdown() {
        return Bits.allAreSet(this.state, 256);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void awaitWritable() throws IOException {
        int state = this.state;
        while (Bits.allAreSet(state, 0x100000)) {
            JsseStreamConduit jsseStreamConduit = this;
            synchronized (jsseStreamConduit) {
                while (this.tasks != 0) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new InterruptedIOException();
                    }
                }
                this.state = state &= 0xFFEFFFFF;
            }
        }
        if (Bits.allAreClear(state, 32768)) {
            if (Bits.allAreSet(state, 65536)) {
                this.sourceConduit.awaitReadable();
            } else {
                this.sinkConduit.awaitWritable();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void awaitWritable(long time, TimeUnit timeUnit) throws IOException {
        int state = this.state;
        long nanos = timeUnit.toNanos(time);
        while (Bits.allAreSet(state, 0x100000)) {
            JsseStreamConduit jsseStreamConduit = this;
            synchronized (jsseStreamConduit) {
                long start = System.nanoTime();
                while (this.tasks != 0) {
                    try {
                        if (nanos <= 0L) {
                            return;
                        }
                        this.wait(nanos / 1000000L, (int)(nanos % 1000000L));
                        long l = -start;
                        start = System.nanoTime();
                        nanos -= l + start;
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new InterruptedIOException();
                    }
                }
                this.state = state &= 0xFFEFFFFF;
            }
        }
        if (Bits.allAreClear(state, 32768)) {
            if (Bits.allAreSet(state, 65536)) {
                this.sourceConduit.awaitReadable(nanos, TimeUnit.NANOSECONDS);
            } else {
                this.sinkConduit.awaitWritable(nanos, TimeUnit.NANOSECONDS);
            }
        }
    }

    @Override
    public void suspendReads() {
        int state = this.state;
        try {
            if (Bits.allAreSet(state, 4)) {
                if (Bits.allAreSet(state &= 0xFFFFFFFB, 8) && Bits.allAreClear(state, 65536)) {
                    state &= 0xFFFFFFF7;
                    this.sourceConduit.suspendReads();
                }
                if (Bits.allAreSet(state, 8192) && Bits.allAreClear(state, 4096)) {
                    state &= 0xFFFFDFFF;
                    this.sinkConduit.suspendWrites();
                }
            }
        }
        finally {
            this.state = state;
        }
    }

    @Override
    public void resumeReads() {
        int state = this.state;
        boolean queueTask = false;
        if (Bits.allAreClear(state, 4)) {
            try {
                if (Bits.allAreClear(state |= 4, 4096)) {
                    state |= 0x20;
                }
                if (Bits.allAreSet(state, 32)) {
                    queueTask = Bits.allAreClear(state, 524288);
                    if (queueTask) {
                        state |= 0x80000;
                    }
                } else if (Bits.allAreSet(state, 64) && Bits.allAreClear(state, 8192)) {
                    state |= 0x2000;
                    this.sinkConduit.resumeWrites();
                } else if (Bits.allAreClear(state, 8)) {
                    state |= 8;
                    this.sourceConduit.resumeReads();
                }
            }
            finally {
                this.state = state;
                if (queueTask) {
                    this.getReadThread().execute(this);
                }
            }
        }
    }

    @Override
    public void wakeupReads() {
        int state = this.state;
        if (Bits.allAreClear(state, 16)) {
            if (Bits.allAreClear(state, 524288)) {
                this.state = state | 0x10 | 0x80000;
                this.getReadThread().execute(this);
            } else {
                this.state = state | 0x10;
            }
        }
    }

    @Override
    public void terminateReads() throws IOException {
        int state = this.state;
        if (Bits.allAreClear(state, 1)) {
            if (Bits.allAreClear(state, 131072)) {
                this.sourceConduit.terminateReads();
            } else {
                this.state = state | 1;
                if (Bits.allAreClear(state, 2)) {
                    long res;
                    this.performIO(2, NO_BUFFERS, 0, 0, NO_BUFFERS, 0, 0);
                    if (Bits.allAreSet(state, 65536) && Bits.allAreClear(state, 2)) {
                        return;
                    }
                    if (!this.engine.isInboundDone() && this.engine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
                        this.engine.closeInbound();
                    }
                    if ((res = this.performIO(0, NO_BUFFERS, 0, 0, NO_BUFFERS, 0, 0)) == -1L) {
                        this.state |= 2;
                    }
                }
                if (Bits.allAreClear(this.state, 2) || this.receiveBuffer.getResource().hasRemaining()) {
                    EOFException exception = Messages.msg.connectionClosedEarly();
                    try {
                        this.sourceConduit.terminateReads();
                    }
                    catch (IOException e) {
                        exception.addSuppressed(e);
                    }
                    throw exception;
                }
                this.sourceConduit.terminateReads();
            }
        }
    }

    @Override
    public boolean isReadResumed() {
        return Bits.anyAreSet(this.state, 20);
    }

    @Override
    public boolean isReadShutdown() {
        return Bits.allAreSet(this.state, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void awaitReadable() throws IOException {
        int state = this.state;
        while (Bits.allAreSet(state, 0x100000)) {
            JsseStreamConduit jsseStreamConduit = this;
            synchronized (jsseStreamConduit) {
                while (this.tasks != 0) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new InterruptedIOException();
                    }
                }
                this.state = state &= 0xFFEFFFFF;
            }
        }
        if (Bits.allAreClear(state, 32)) {
            if (Bits.allAreSet(state, 64)) {
                this.sinkConduit.awaitWritable();
            } else {
                this.sourceConduit.awaitReadable();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void awaitReadable(long time, TimeUnit timeUnit) throws IOException {
        int state = this.state;
        long nanos = timeUnit.toNanos(time);
        while (Bits.allAreSet(state, 0x100000)) {
            JsseStreamConduit jsseStreamConduit = this;
            synchronized (jsseStreamConduit) {
                long start = System.nanoTime();
                while (this.tasks != 0) {
                    try {
                        if (nanos <= 0L) {
                            return;
                        }
                        this.wait(nanos / 1000000L, (int)(nanos % 1000000L));
                        long l = -start;
                        start = System.nanoTime();
                        nanos -= l + start;
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new InterruptedIOException();
                    }
                }
                this.state = state &= 0xFFEFFFFF;
            }
        }
        if (Bits.allAreClear(state, 32)) {
            if (Bits.allAreSet(state, 64)) {
                this.sinkConduit.awaitWritable(nanos, TimeUnit.NANOSECONDS);
            } else {
                this.sourceConduit.awaitReadable(nanos, TimeUnit.NANOSECONDS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(ByteBuffer dst) throws IOException {
        int state = this.state;
        if (Bits.anyAreSet(state, 1)) {
            return -1;
        }
        if (Bits.anyAreSet(state, 2)) {
            if (this.readBuffer.getResource().position() > 0) {
                ByteBuffer readBufferResource = this.readBuffer.getResource();
                readBufferResource.flip();
                try {
                    if (TRACE_SSL) {
                        Messages.msg.tracef("TLS copy unwrapped data from %s to %s", (Object)Buffers.debugString(readBufferResource), (Object)Buffers.debugString(dst));
                    }
                    int n = Buffers.copy(dst, readBufferResource);
                    return n;
                }
                finally {
                    readBufferResource.compact();
                }
            }
            return -1;
        }
        if (Bits.allAreClear(state, 131072)) {
            int res = this.sourceConduit.read(dst);
            if (res == 0) {
                if (Bits.allAreSet(state, 32)) {
                    this.state = state & 0xFFFFFFDF;
                }
            } else if (res == -1) {
                this.state = (state | 2) & 0xFFFFFFDF;
            }
            return res;
        }
        ByteBuffer[] readBufferHolder = this.readBufferHolder;
        readBufferHolder[0] = dst;
        try {
            int n = (int)this.performIO(0, NO_BUFFERS, 0, 0, readBufferHolder, 0, 1);
            return n;
        }
        finally {
            readBufferHolder[0] = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long read(ByteBuffer[] dsts, int offs, int len) throws IOException {
        int state = this.state;
        if (Bits.anyAreSet(state, 1)) {
            return -1L;
        }
        if (Bits.anyAreSet(state, 2)) {
            if (this.readBuffer.getResource().position() > 0) {
                ByteBuffer readBufferResource = this.readBuffer.getResource();
                readBufferResource.flip();
                try {
                    if (TRACE_SSL) {
                        Messages.msg.tracef("TLS copy unwrapped data from %s to %s", (Object)Buffers.debugString(readBufferResource), (Object)Buffers.debugString(dsts, offs, len));
                    }
                    long l = Buffers.copy(dsts, offs, len, readBufferResource);
                    return l;
                }
                finally {
                    readBufferResource.compact();
                }
            }
            return -1L;
        }
        if (Bits.allAreClear(state, 131072)) {
            long res = this.sourceConduit.read(dsts, offs, len);
            if (res == 0L) {
                if (Bits.allAreSet(state, 32)) {
                    this.state = state & 0xFFFFFFDF;
                }
            } else if (res == -1L) {
                this.state = (state | 2) & 0xFFFFFFDF;
            }
            return res;
        }
        return this.performIO(0, NO_BUFFERS, 0, 0, dsts, offs, len);
    }

    @Override
    public long transferTo(long position, long count, FileChannel target) throws IOException {
        if (Bits.allAreClear(this.state, 131072)) {
            return this.sourceConduit.transferTo(position, count, target);
        }
        return target.transferFrom(new ConduitReadableByteChannel(this), position, count);
    }

    @Override
    public long transferTo(long count, ByteBuffer throughBuffer, StreamSinkChannel target) throws IOException {
        if (Bits.allAreClear(this.state, 131072)) {
            return this.sourceConduit.transferTo(count, throughBuffer, target);
        }
        return Conduits.transfer(this, count, throughBuffer, target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(ByteBuffer src) throws IOException {
        if (Bits.allAreSet(this.state, 256)) {
            throw new ClosedChannelException();
        }
        if (Bits.allAreClear(this.state, 131072)) {
            return this.sinkConduit.write(src);
        }
        ByteBuffer[] writeBufferHolder = this.writeBufferHolder;
        writeBufferHolder[0] = src;
        try {
            int n = (int)this.write(writeBufferHolder, 0, 1);
            return n;
        }
        finally {
            writeBufferHolder[0] = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int writeFinal(ByteBuffer src) throws IOException {
        if (Bits.allAreSet(this.state, 256)) {
            throw new ClosedChannelException();
        }
        if (Bits.allAreClear(this.state, 131072)) {
            return this.sinkConduit.writeFinal(src);
        }
        ByteBuffer[] writeBufferHolder = this.writeBufferHolder;
        writeBufferHolder[0] = src;
        try {
            int n = (int)this.writeFinal(writeBufferHolder, 0, 1);
            return n;
        }
        finally {
            writeBufferHolder[0] = null;
        }
    }

    @Override
    public long write(ByteBuffer[] srcs, int offs, int len) throws IOException {
        if (Bits.allAreSet(this.state, 256)) {
            throw new ClosedChannelException();
        }
        if (Bits.allAreClear(this.state, 131072)) {
            return this.sinkConduit.write(srcs, offs, len);
        }
        long r1 = Buffers.remaining(srcs, offs, len);
        this.performIO(1, srcs, offs, len, NO_BUFFERS, 0, 0);
        return r1 - Buffers.remaining(srcs, offs, len);
    }

    @Override
    public long writeFinal(ByteBuffer[] srcs, int offs, int len) throws IOException {
        if (Bits.allAreSet(this.state, 256)) {
            throw new ClosedChannelException();
        }
        if (Bits.allAreClear(this.state, 131072)) {
            return this.sinkConduit.writeFinal(srcs, offs, len);
        }
        long r1 = Buffers.remaining(srcs, offs, len);
        this.performIO(3, srcs, offs, len, NO_BUFFERS, 0, 0);
        return r1 - Buffers.remaining(srcs, offs, len);
    }

    @Override
    public boolean flush() throws IOException {
        int state = this.state;
        if (Bits.allAreSet(state, 2048)) {
            return true;
        }
        if (Bits.allAreSet(state, 1024)) {
            if (this.sinkConduit.flush()) {
                this.state = state | 0x800;
                return true;
            }
            return false;
        }
        if (Bits.allAreClear(state, 131072)) {
            boolean flushed = this.sinkConduit.flush();
            if (Bits.allAreSet(state, 256) && flushed) {
                this.state = state | 0x200 | 0x400 | 0x800;
            }
            return flushed;
        }
        if (Bits.allAreSet(state, 256)) {
            return this.performIO(2, NO_BUFFERS, 0, 0, NO_BUFFERS, 0, 0) != 0L;
        }
        return this.performIO(2, NO_BUFFERS, 0, 0, NO_BUFFERS, 0, 0) != 0L;
    }

    @Override
    public long transferFrom(FileChannel src, long position, long count) throws IOException {
        if (Bits.allAreClear(this.state, 131072)) {
            return this.sinkConduit.transferFrom(src, position, count);
        }
        return src.transferTo(position, count, new ConduitWritableByteChannel(this));
    }

    @Override
    public long transferFrom(StreamSourceChannel source, long count, ByteBuffer throughBuffer) throws IOException {
        if (Bits.allAreClear(this.state, 131072)) {
            return this.sinkConduit.transferFrom(source, count, throughBuffer);
        }
        return Conduits.transfer(source, count, throughBuffer, this);
    }

    private static long actualIOResult(long xfer, int goal, boolean flushed, boolean eof) {
        long result;
        long l = goal == 2 && flushed ? 1L : (result = goal == 0 && eof && xfer == 0L ? -1L : xfer);
        if (TRACE_SSL) {
            Messages.msg.tracef("returned TLS result %d", result);
        }
        return result;
    }

    private static String decodeGoal(int goal) {
        switch (goal) {
            case 0: {
                return "READ";
            }
            case 1: {
                return "WRITE";
            }
            case 2: {
                return "FLUSH";
            }
            case 3: {
                return "WRITE_FINAL";
            }
        }
        return "UNKNOWN(" + goal + ")";
    }

    /*
     * Exception decompiling
     */
    private long performIO(int goal, ByteBuffer[] srcs, int srcOff, int srcLen, ByteBuffer[] dsts, int dstOff, int dstLen) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[TRYBLOCK]], but top level block is 81[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    class TaskWrapper
    implements Runnable {
        private final Runnable task;

        TaskWrapper(Runnable task) {
            this.task = task;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.task.run();
            }
            finally {
                JsseStreamConduit jsseStreamConduit = JsseStreamConduit.this;
                synchronized (jsseStreamConduit) {
                    if (JsseStreamConduit.this.tasks-- == 1) {
                        JsseStreamConduit.this.notifyAll();
                    }
                }
            }
        }
    }
}

