/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.util;

import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;

public class StrictSizeTable {
    private final int rowsTotal;
    private final Map<String, Column> columns = new LinkedHashMap<String, Column>();
    private int rowIndex = 0;
    private int totalWidth;

    public StrictSizeTable(int rowsTotal) {
        if (rowsTotal <= 0) {
            throw new IllegalArgumentException("The number of rows must be bigger than zero: " + rowsTotal);
        }
        this.rowsTotal = rowsTotal;
    }

    public boolean isAtLastRow() {
        return this.rowIndex == this.rowsTotal - 1;
    }

    public void nextRow() {
        if (this.rowIndex + 1 >= this.rowsTotal) {
            throw new IndexOutOfBoundsException("Row index exceeded table size " + this.rowsTotal + ": " + this.rowIndex);
        }
        ++this.rowIndex;
    }

    public void addCell(String header, String value) {
        if (header == null) {
            throw new IllegalArgumentException("Header can't be null.");
        }
        Column column = this.columns.get(header);
        if (column == null) {
            column = new Column(header);
            this.columns.put(header, column);
            column.maxWidth = Math.max(header.length() + 1, 4);
            this.totalWidth += column.maxWidth;
        }
        if (value != null) {
            column.cells[this.rowIndex] = value;
            if (value.length() + 1 > column.maxWidth) {
                this.totalWidth -= column.maxWidth;
                column.maxWidth = value.length() + 1;
                this.totalWidth += column.maxWidth;
            }
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder((this.rowsTotal + 1) * this.totalWidth);
        int columnOffset = 0;
        for (Column column : this.columns.values()) {
            int i;
            if (buf.length() < columnOffset) {
                buf.setLength(columnOffset);
            }
            buf.insert(columnOffset, column.header.toUpperCase(Locale.ENGLISH));
            for (i = column.header.length(); i < column.maxWidth; ++i) {
                buf.insert(columnOffset + i, ' ');
            }
            if (columnOffset == 0) {
                buf.insert(column.maxWidth, '\n');
            }
            for (i = 0; i < this.rowsTotal; ++i) {
                String value;
                int offset = (i + 1) * (columnOffset + column.maxWidth + 1) + columnOffset;
                if (buf.length() < offset) {
                    buf.setLength(offset);
                }
                if ((value = column.cells[i]) == null) {
                    value = "n/a";
                }
                buf.insert(offset, value);
                for (int j = value.length(); j < column.maxWidth; ++j) {
                    buf.insert(offset + j, ' ');
                }
                if (columnOffset != 0) continue;
                buf.insert(offset + column.maxWidth, '\n');
            }
            columnOffset += column.maxWidth;
        }
        return buf.toString();
    }

    public boolean isEmpty() {
        return this.columns.isEmpty();
    }

    public static void main(String[] args) throws Exception {
        StrictSizeTable t = new StrictSizeTable(4);
        t.addCell("h1", "r1 h1");
        t.nextRow();
        t.addCell("h1", "r2 h1");
        t.addCell("h2", "r2 h2");
        t.nextRow();
        t.addCell("h2", "r3 h2");
        t.nextRow();
        t.addCell("h3", "r4 h3");
        System.out.println(t.toString());
    }

    private class Column {
        final String header;
        final String[] cells;
        int maxWidth;

        Column(String header) {
            this.cells = new String[StrictSizeTable.this.rowsTotal];
            this.header = header;
        }
    }
}

