/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.internal.entities.mapper.id;

import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import org.hibernate.Session;
import org.hibernate.envers.boot.internal.EnversService;
import org.hibernate.envers.internal.entities.PropertyData;
import org.hibernate.envers.internal.entities.mapper.id.IdMapper;
import org.hibernate.envers.internal.entities.mapper.id.SingleIdMapper;
import org.hibernate.envers.internal.tools.ReflectionTools;
import org.hibernate.property.access.spi.Getter;
import org.hibernate.property.access.spi.Setter;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.type.EntityType;

public class VirtualEntitySingleIdMapper
extends SingleIdMapper {
    private final PropertyData propertyData;
    private final String entityName;
    private IdMapper entityIdMapper;

    public VirtualEntitySingleIdMapper(ServiceRegistry serviceRegistry, PropertyData propertyData) {
        super(serviceRegistry, propertyData);
        this.propertyData = propertyData;
        this.entityName = VirtualEntitySingleIdMapper.resolveEntityName(this.propertyData);
    }

    @Override
    public void mapToMapFromId(Session session, Map<String, Object> data, final Object obj) {
        Serializable value = AccessController.doPrivileged(new PrivilegedAction<Serializable>(){

            @Override
            public Serializable run() {
                Getter getter = ReflectionTools.getGetter(obj.getClass(), VirtualEntitySingleIdMapper.this.propertyData, VirtualEntitySingleIdMapper.this.getServiceRegistry());
                return (Serializable)getter.get(obj);
            }
        });
        Object entity = session.load(this.entityName, value);
        data.put(this.propertyData.getName(), entity);
    }

    @Override
    public boolean mapToEntityFromMap(final Object obj, Map data) {
        if (data == null || obj == null) {
            return false;
        }
        final Object value = data.get(this.propertyData.getName());
        if (value == null) {
            return false;
        }
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                Setter setter = ReflectionTools.getSetter(obj.getClass(), VirtualEntitySingleIdMapper.this.propertyData, VirtualEntitySingleIdMapper.this.getServiceRegistry());
                Class<?> paramClass = ReflectionTools.getType(obj.getClass(), VirtualEntitySingleIdMapper.this.propertyData, VirtualEntitySingleIdMapper.this.getServiceRegistry());
                if (paramClass != null && paramClass.equals(VirtualEntitySingleIdMapper.this.propertyData.getVirtualReturnClass())) {
                    setter.set(obj, VirtualEntitySingleIdMapper.this.getAssociatedEntityIdMapper().mapToIdFromEntity(value), null);
                } else {
                    setter.set(obj, value, null);
                }
                return true;
            }
        });
    }

    @Override
    public void mapToMapFromEntity(Map<String, Object> data, final Object obj) {
        if (obj == null) {
            data.put(this.propertyData.getName(), null);
        } else if (obj instanceof HibernateProxy) {
            HibernateProxy proxy = (HibernateProxy)obj;
            data.put(this.propertyData.getName(), proxy.getHibernateLazyInitializer().getIdentifier());
        } else {
            Object value = AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    Getter getter = ReflectionTools.getGetter(obj.getClass(), VirtualEntitySingleIdMapper.this.propertyData, VirtualEntitySingleIdMapper.this.getServiceRegistry());
                    return getter.get(obj);
                }
            });
            if (this.propertyData.getVirtualReturnClass().isInstance(value)) {
                this.getPrefixedAssociatedEntityIdMapper(this.propertyData).mapToMapFromId(data, value);
            } else {
                data.put(this.propertyData.getName(), value);
            }
        }
    }

    private IdMapper getAssociatedEntityIdMapper() {
        if (this.entityIdMapper == null) {
            this.entityIdMapper = VirtualEntitySingleIdMapper.resolveEntityIdMapper(this.getServiceRegistry(), this.entityName);
        }
        return this.entityIdMapper;
    }

    private IdMapper getPrefixedAssociatedEntityIdMapper(PropertyData propertyData) {
        return this.getAssociatedEntityIdMapper().prefixMappedProperties(propertyData.getName() + ".");
    }

    private static String resolveEntityName(PropertyData propertyData) {
        if (EntityType.class.isInstance(propertyData.getType())) {
            EntityType entityType = (EntityType)propertyData.getType();
            return entityType.getAssociatedEntityName();
        }
        return null;
    }

    private static IdMapper resolveEntityIdMapper(ServiceRegistry serviceRegistry, String entityName) {
        EnversService enversService = (EnversService)serviceRegistry.getService(EnversService.class);
        return enversService.getEntitiesConfigurations().get(entityName).getIdMapper();
    }
}

