/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.metrics.elementdesc.adapter.cdi;

import io.smallrye.metrics.elementdesc.AnnotationInfo;
import io.smallrye.metrics.elementdesc.BeanInfo;
import io.smallrye.metrics.elementdesc.adapter.cdi.CDIAnnotationInfoAdapter;
import java.lang.annotation.Annotation;
import javax.enterprise.inject.Stereotype;

public class CDIBeanInfo
implements BeanInfo {
    private final Class<?> input;

    CDIBeanInfo(Class<?> input) {
        this.input = input;
    }

    @Override
    public String getSimpleName() {
        return this.input.getSimpleName();
    }

    @Override
    public String getPackageName() {
        return this.input.getPackage().getName();
    }

    @Override
    public <T extends Annotation> AnnotationInfo getAnnotation(Class<T> metric) {
        T annotation = this.input.getAnnotation(metric);
        if (annotation != null) {
            return new CDIAnnotationInfoAdapter().convert((Annotation)annotation);
        }
        for (Annotation stereotypeCandidate : this.input.getAnnotations()) {
            if (!stereotypeCandidate.annotationType().isAnnotationPresent(Stereotype.class) || !stereotypeCandidate.annotationType().isAnnotationPresent(metric)) continue;
            return new CDIAnnotationInfoAdapter().convert((Annotation)stereotypeCandidate.annotationType().getAnnotation(metric));
        }
        return null;
    }

    @Override
    public <T extends Annotation> boolean isAnnotationPresent(Class<T> metric) {
        if (this.input.isAnnotationPresent(metric)) {
            return true;
        }
        for (Annotation stereotypeCandidate : this.input.getAnnotations()) {
            if (!stereotypeCandidate.annotationType().isAnnotationPresent(Stereotype.class) || !stereotypeCandidate.annotationType().isAnnotationPresent(metric)) continue;
            return true;
        }
        return false;
    }

    @Override
    public BeanInfo getSuperclass() {
        Class<?> superclass = this.input.getSuperclass();
        if (superclass != null) {
            return new CDIBeanInfo(superclass);
        }
        return null;
    }

    public String toString() {
        return this.input.toString();
    }
}

